import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/ApproverBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/KambanBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TahapanBloc.dart';
import 'package:absenkuv3/Bloc/SalesActivity/TotalKambanBloc.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataKanban.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mMasterTahapan.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/halamanDetailKanbanBoard.dart';
import 'package:absenkuv3/UI/Modul/SalesActivity/Kanban/templeteCRUDLayanan.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/FilterBottomKanbanSheet.dart';
import 'package:absenkuv3/UI/Template/FilterBottomSheet.dart';
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerRekapBloc.dart' as monthPicker;
import 'package:absenkuv3/UI/Template/MonthPicker/UI/templateMonthPickerRekap.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateConfirmationDialog.dart';
import 'package:absenkuv3/UI/Template/templateTextFieldForm.dart';
import 'package:absenkuv3/main.dart';
import 'package:intl/intl.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

class HalamanKambanBoard extends StatefulWidget {
  const HalamanKambanBoard({super.key});

  @override
  State<HalamanKambanBoard> createState() => _HalamanKambanBoardState();
}

class _HalamanKambanBoardState extends State<HalamanKambanBoard> {
  double? initialPosition;
  ScrollController _scrollController = new ScrollController();
  GlobalKey<ScaffoldState> __scaffoldKey = GlobalKey();
  String firstTahapan = "";
  ModelFilter? modelFilter = ModelFilter(monthYear: DateTime.now());
  String selectedTahapan = "";
  String idSelectedTahapan = "";

  @override
  void initState() {
    super.initState();
    // BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    BlocProvider.of<monthPicker.MonthPickerRekapBloc>(context).add(monthPicker.SetDate(DateTime.now()));
    BlocProvider.of<FilterBottomSheetBloc>(context).add(setFilterBottomSheet(modelFilter));
    // BlocProvider.of<TahapanBloc>(context).add(GetTahapanEvent(context, ModelFilter(monthYear: Date),DateTime.now().month.toString(), DateTime.now().year.toString()));
    _scrollController.addListener(()=>BlocProvider.of<KambanBloc>(context).add(loadMoreEvent(context, __scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: CustomStyle.backgroundColor,
      key: __scaffoldKey,
      appBar: AppBar(
        centerTitle: true,
        flexibleSpace: Image(
          image: AssetImage(ValueImage.headerBiruDashboard),
          fit: BoxFit.cover,
        ),
        backgroundColor: Colors.transparent,
        title: Text(
          'Kanban Board',
          style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
        ),
        actions: [
          GestureDetector(
            onTap: ()=> BlocProvider.of<NavigatorBloc>(context)
                .add(NavigateToAddLayanan(context, firstTahapan)),
            child: Container(
                margin: EdgeInsets.only(right: 14),
                child: Icon(Icons.add, size: 26,)),
          ),
        ],
      ),
      body: BlocBuilder<AuthBloc, LoginRespon>(
          builder: (context, stateLogin) {
            return Stack(
              children: [
                BlocBuilder<TahapanBloc, TahapanState>(
                    builder: (context, state) {
                      if (state is TahapanSuccessState) {
                        initialPosition = 0;
                        ScrollController _controller = ScrollController(initialScrollOffset: initialPosition!);
                        BlocProvider.of<TotalKambanBloc>(context).add(getTotalKambanEvent(context, state.idSelected, state.modelFilter));
                        BlocProvider.of<KambanBloc>(context).add(getListDataKambanEvent(context, state.idSelected, state.modelFilter));
                        return Column(
                          children: [
                            Container(
                              height: 50,
                              width: MediaQuery.of(context).size.width * 1.5,
                              padding: EdgeInsets.only(left: 5.0, top: 5),
                              child: ListView.builder(
                                  itemCount: state.dataColumn!.length,
                                  scrollDirection: Axis.horizontal,
                                  controller: _controller,
                                  itemBuilder: (BuildContext context, index) {
                                    firstTahapan = state.dataColumn![0].id!;
                                    return Stack(
                                      children: [
                                        Row(
                                          children: [
                                            SizedBox(width: 2),
                                            ChoiceChip(
                                                shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(21)),
                                                backgroundColor: Color(int.parse(state.dataColumn![index].warna!)),
                                                // backgroundColor: Color(int.parse(state.dataColumn![index].warna!)).withOpacity(0.5),
                                                labelPadding: EdgeInsets.only(left: 17, right: 17, top: 3, bottom: 3),
                                                selectedColor: Color(int.parse(state.dataColumn![index].warna!)),
                                                selected: state.selected == state.dataColumn![index].value,
                                                side: BorderSide(color: state.selected == state.dataColumn![index].value ? Colors.black : Colors.transparent, width: 1.5),
                                                label: Text(state.dataColumn![index].nama ?? ''),
                                                labelStyle: TextStyle(color: Color(int.parse(state.dataColumn![index].warnaText!))),
                                                elevation: 1,
                                                onSelected: (_) {
                                                  BlocProvider.of<TahapanBloc>(context).add(SelectedTahapanEvent(state.dataColumn!, state.dataColumn![index].value!, state.dataColumn![index].id!, state.dataColumn![index].warna!, state.dataColumn![index].warnaText!, state.modelFilter!));
                                                }),
                                            SizedBox(width: 11)
                                          ],
                                        ),
                                        state.dataColumn![index].jumlah != 0
                                            ? Positioned(
                                          right: 6,
                                          top: 3,
                                          child: Container(
                                              child: Center(
                                                  child: Text(
                                                      state.dataColumn![index].jumlah.toString(),
                                                      style: TextStyle(color: Colors.white))),
                                              decoration: new BoxDecoration(
                                                  color: Colors.red,
                                                  shape: BoxShape.circle),
                                              height: MediaQuery.of(context).size.width * 0.05,
                                              width: MediaQuery.of(context).size.width * 0.05),
                                        )
                                            : Container()
                                      ],
                                    );
                                  }),
                            ),
                            BlocBuilder<TotalKambanBloc, TotalKambanState>(
                                builder: (context, stateTotalKanban) {
                                  return Container(
                                      margin: EdgeInsets.only(top: 13, left: 27, right: 27),
                                      padding: EdgeInsets.fromLTRB(17,13,17,13),
                                      decoration: BoxDecoration(
                                          borderRadius: BorderRadius.circular(17),
                                          border: Border.all(color: Colors.grey.shade300, width: 1.5)
                                      ),
                                      child: Row(
                                        mainAxisAlignment: MainAxisAlignment.center,
                                        children: [
                                          Expanded(
                                            child: Row(
                                              children: [
                                                Image.asset(ValueImage.iconTotalKanban, width: 31),
                                                SizedBox(width: 13),
                                                Expanded(
                                                  child: Column(
                                                    crossAxisAlignment: CrossAxisAlignment.start,
                                                    children: [
                                                      Text('Total ${state.selected}', style: TextStyle(fontSize: 12, color: Colors.grey.shade500)),
                                                      SizedBox(height: 3),
                                                      stateTotalKanban is getTotalKambanSuccessState
                                                          ? Text(stateTotalKanban.dataTotalKanban!.totalLead!, style: TextStyle(fontWeight: FontWeight.w700))
                                                          : Container(
                                                        height: 15,
                                                        width: 50,
                                                        child: Shimmer.fromColors(
                                                          baseColor: Colors.grey[300]!,
                                                          highlightColor: Colors.white,
                                                          period: Duration(seconds: 4),
                                                          child: Card(),
                                                        ),
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                          Container(
                                              margin: EdgeInsets.only(left: 13, right: 13),
                                              height: 50,
                                              child: VerticalDivider(color: Colors.grey.shade300, thickness: 1, width: 1)),
                                          Expanded(
                                            child: Row(
                                              children: [
                                                Image.asset(ValueImage.iconTotalNominal, width: 31),
                                                SizedBox(width: 13),
                                                Expanded(
                                                  child: Column(
                                                    crossAxisAlignment: CrossAxisAlignment.start,
                                                    children: [
                                                      Text('Total Nominal', style: TextStyle(fontSize: 12, color: Colors.grey.shade500)),
                                                      SizedBox(height: 3),
                                                      stateTotalKanban is getTotalKambanSuccessState
                                                          ? Text('${stateTotalKanban.dataTotalKanban!.totalNominal}', style: TextStyle(fontWeight: FontWeight.w700))
                                                          : Container(
                                                        height: 15,
                                                        width: 50,
                                                        child: Shimmer.fromColors(
                                                          baseColor: Colors.grey[300]!,
                                                          highlightColor: Colors.white,
                                                          period: Duration(seconds: 4),
                                                          child: Card(),
                                                        ),
                                                      ),
                                                    ],
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                        ],
                                      )
                                  );
                                }
                            ),

                            SizedBox(height: 17),
                            BlocBuilder<KambanBloc, KambanState>(
                                builder: (context, stateKanban) {
                                  if(stateKanban is getListDataKambanSuccessState || stateKanban is LoadMoreProgressState){
                                    return Expanded(
                                      child: Stack(
                                        children: [
                                          ListView.builder(
                                              itemCount: stateKanban.data!.length,
                                              physics: AlwaysScrollableScrollPhysics(),
                                              controller: _scrollController,
                                              itemBuilder: (con, ind){
                                                return GestureDetector(
                                                  onTap: (){
                                                    Navigator.pushNamed(context, '/detail_sales_activity', arguments: [stateKanban.data![ind], 'Data Pelanggan', '', state.idSelected]).then((value){
                                                      value = value.toString().replaceAll("[", "");
                                                      value = value.toString().replaceAll("]", "");
                                                      if (value.toString().split(", ")[0] == "refresh") {
                                                        BlocProvider.of<TotalKambanBloc>(context).add(
                                                            getTotalKambanEvent(context, value.toString().split(", ")[1], modelFilter));
                                                        BlocProvider.of<KambanBloc>(context).add(
                                                            getListDataKambanEvent(context, value.toString().split(", ")[1], modelFilter));
                                                      }
                                                    });
                                                    // BlocProvider.of<NavigatorBloc>(context)
                                                    //     .add(NavigateToDetailSalesActivityPage(context, [stateKanban.data![ind], 'Data Pelanggan', '', state.idSelected]));
                                                  },
                                                  child: Container(
                                                    margin: EdgeInsets.only(left: 27, right: 27, bottom: 13),
                                                    decoration: BoxDecoration(
                                                        border: Border.all(color: Colors.grey.shade300, width: 1.5),
                                                        borderRadius: BorderRadius.circular(17),
                                                        color: stateKanban.data![ind].statusPengajuan!.value == 'pengajuan'
                                                            ? Color(int.parse(stateKanban.data![ind].statusPengajuan!.color!))
                                                            : Colors.white
                                                    ),
                                                    child: Column(
                                                      children: [
                                                        Container(
                                                          padding: EdgeInsets.all(13),
                                                          child: Column(
                                                            crossAxisAlignment: CrossAxisAlignment.start,
                                                            children: [
                                                              Row(
                                                                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                                                children: [
                                                                  Row(
                                                                    children: [
                                                                      Text(stateKanban.data![ind].tglInput!, style: TextStyle(fontSize: 13, color: Colors.grey.shade500)),
                                                                      SizedBox(width: 13),
                                                                      Container(
                                                                        decoration: BoxDecoration(
                                                                            color: Color(int.parse(stateKanban.data![ind].statusPengajuan!.labelColor!)),
                                                                            borderRadius: BorderRadius.circular(13)
                                                                        ),
                                                                        padding: EdgeInsets.fromLTRB(7, 3, 7, 3),
                                                                        child: Text(stateKanban.data![ind].statusPengajuan!.status!, style: TextStyle(color: Color(int.parse(stateKanban.data![ind].statusPengajuan!.labelFontColor!)), fontSize: 12)),
                                                                      )
                                                                    ],
                                                                  ),
                                                                  PopupMenuButton<String>(
                                                                    onSelected: (value) => doAction(context, __scaffoldKey, value, stateKanban.data![ind], state.dataColumn!, state.idSelected!, state.selected!, state.bgColor!, state.textColor!),
                                                                    itemBuilder: (BuildContext context) {
                                                                      List<String> button = [];
                                                                      if(stateKanban.data![ind].button!.buttonDetail!){
                                                                        button.add('Detail');
                                                                      }
                                                                      if(stateKanban.data![ind].button!.buttonUbahTahapan!){
                                                                        button.add('Ubah Tahapan');
                                                                      }
                                                                      if(stateKanban.data![ind].button!.buttonHapus!){
                                                                        button.add('Hapus');
                                                                      }
                                                                      if(stateKanban.data![ind].button!.buttonBatalkan!){
                                                                        button.add('Batalkan');
                                                                      }
                                                                      if(stateKanban.data![ind].button!.buttonPindahBulan!){
                                                                        button.add('Pindah Bulan');
                                                                      }
                                                                      if(stateKanban.data![ind].button!.buttonApprove!){
                                                                        button.add('Setujui');
                                                                      }
                                                                      if(stateKanban.data![ind].button!.buttonTolak!){
                                                                        button.add('Tolak');
                                                                      }
                                                                      return button.map((String choice) {
                                                                        return PopupMenuItem<String>(
                                                                          value: choice,
                                                                          child: Text(choice, style: TextStyle(fontSize: 13)),
                                                                        );
                                                                      }).toList();
                                                                    },
                                                                    child: Icon(
                                                                      Icons.more_vert_sharp,
                                                                      color: CustomStyle.fontColorGrey,
                                                                    ),
                                                                  )
                                                                ],
                                                              ),

                                                              SizedBox(height: 17),
                                                              Text(stateKanban.data![ind].namaPerusahaan!, style: TextStyle(fontWeight: FontWeight.w700)),

                                                            ],
                                                          ),
                                                        ),
                                                        !stateLogin.dataLogin!.adminAtasan! ? Container() :
                                                        Column(
                                                          children: [
                                                            Divider(color: Colors.grey,height: 1),
                                                            Container(
                                                              padding: EdgeInsets.all(13),
                                                              child: Row(
                                                                crossAxisAlignment: CrossAxisAlignment.start,
                                                                children: [
                                                                  Text('Sales : ', style: TextStyle(fontSize: 13, color: Colors.grey.shade500)),
                                                                  Expanded(child: Text(stateKanban.data![ind].namaLengkapSales!, style: TextStyle(fontSize: 13, color: Colors.grey.shade700, fontWeight: FontWeight.w500))),
                                                                ],
                                                              ),
                                                            ),
                                                          ],
                                                        ),

                                                        // Container(
                                                        //   padding: EdgeInsets.only(left: 13, right: 13, bottom: 13),
                                                        //   child: Row(
                                                        //     mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                                        //     children: [
                                                        //       Text('No. Telepon', style: TextStyle(fontSize: 13, color: Colors.grey.shade500)),
                                                        //       Text(stateKanban.data![ind].picTelp!, style: TextStyle(fontSize: 13, color: Colors.grey.shade700, fontWeight: FontWeight.w400)),
                                                        //     ],
                                                        //   ),
                                                        // ),
                                                        // Container(
                                                        //   padding: EdgeInsets.only(left: 13, right: 13, bottom: 13),
                                                        //   child: Row(
                                                        //     mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                                        //     children: [
                                                        //       Text('Total', style: TextStyle(fontSize: 13, color: Colors.grey.shade500)),
                                                        //       Text(stateKanban.data![ind].totalHarga!, style: TextStyle(fontSize: 13, color: Colors.grey.shade700, fontWeight: FontWeight.w400)),
                                                        //     ],
                                                        //   ),
                                                        // ),
                                                        // Container(
                                                        //   padding: EdgeInsets.only(left: 13, right: 13, bottom: 13),
                                                        //   child: Row(
                                                        //     mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                                        //     children: [
                                                        //       Text('Layanan', style: TextStyle(fontSize: 13, color: Colors.grey.shade500)),
                                                        //       Text('${stateKanban.data![ind].layanan}', style: TextStyle(fontSize: 13, color: Colors.grey.shade700, fontWeight: FontWeight.w400)),
                                                        //     ],
                                                        //   ),
                                                        // ),
                                                      ],
                                                    ),
                                                  ),
                                                );
                                              }
                                          ),
                                          stateKanban is LoadMoreProgressState? Positioned(
                                              bottom :16,
                                              child: Container(
                                                  width: MediaQuery.of(context).size.width,
                                                  child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                                        ],
                                      ),
                                    );
                                  }else if(stateKanban is KambanProgressState){
                                    return Expanded(
                                      child: Center(
                                        child: CircularProgressIndicator(strokeWidth: 8),
                                      ),
                                    );
                                  } else if(stateKanban is KambanProgressState){
                                    return Center(
                                      child: CircularProgressIndicator(strokeWidth: 8),
                                    );
                                  }
                                  else{
                                    return Expanded(
                                      child: Container(
                                          child: Center(child: Image.asset(ValueImage.noData, height: 250,),)),
                                    );
                                  }
                                }
                            )
                          ],
                        );
                      } else
                        return Center(child: CircularProgressIndicator(strokeWidth: 8));
                    }),

                BlocListener<TahapanBloc, TahapanState>(
                    listener: (context, stateTahapan) {
                      if (stateTahapan is TahapanSuccessState){
                        selectedTahapan = stateTahapan.selected!;
                        idSelectedTahapan = stateTahapan.idSelected!;
                      }
                    },
                  child: Positioned(
                      bottom: 20,
                      right: 10,
                      child: BlocListener<FilterBottomSheetBloc, FilterBottomSheetState>(
                          listener: (BuildContext context, FilterBottomSheetState state) {
                            if (state is setFilterSuccess) {
                              modelFilter = state.modelFilter;
                              print("kakaka");
                              print(state.modelFilter!.monthYear);
                              if(state != null){
                                modelFilter = state.modelFilter;

                                BlocProvider.of<TahapanBloc>(context).add(GetTahapanEvent(context, modelFilter, idSelectedTahapan: idSelectedTahapan==""?null:idSelectedTahapan, selectedTahapan: selectedTahapan==""?null:selectedTahapan));
                              }
                            }
                          },
                          child: FilterBottomSheetKanban(modelFilter!.monthYear, null,adaFilterRangeTanggal: false,))
                    // BlocListener<MonthPickerRekapBloc, MonthPickerRekapState>(
                    // listener: (BuildContext context, MonthPickerRekapState state) {
                    //   if(state.dateTime != null){
                    //     BlocProvider.of<TahapanBloc>(context).add(GetTahapanEvent(context, ModelFilter(monthYear: state.dateTime)));
                    //   }
                    // },
                    // child: TemplateMonthPickerRekap(backgroundColor: CustomStyle.color1))
                  ),
                )
                // Positioned(
                //     bottom: 20,
                //     right: 10,
                //     child: BlocListener<FilterBottomSheetBloc, FilterBottomSheetState>(
                //         listener: (BuildContext context, FilterBottomSheetState state) {
                //           if (state is setFilterSuccess) {
                //             modelFilter = state.modelFilter;
                //             print(state.modelFilter!.monthYear);
                //             if(state != null){
                //               modelFilter = state.modelFilter;
                //               BlocProvider.of<TahapanBloc>(context).add(GetTahapanEvent(context, modelFilter));
                //             }
                //           }
                //         },
                //         child: FilterBottomSheetKanban(modelFilter!.monthYear!, adaFilterRangeTanggal: false,))
                //   // BlocListener<MonthPickerRekapBloc, MonthPickerRekapState>(
                //   // listener: (BuildContext context, MonthPickerRekapState state) {
                //   //   if(state.dateTime != null){
                //   //     BlocProvider.of<TahapanBloc>(context).add(GetTahapanEvent(context, ModelFilter(monthYear: state.dateTime)));
                //   //   }
                //   // },
                //   // child: TemplateMonthPickerRekap(backgroundColor: CustomStyle.color1))
                // )
              ],
            );
          }
      ),
    );
  }

  void doAction(BuildContext context, scaffoldKeys, String value, DataKanban dataKanban, List<DataTahapan> dataTahapan, String idSelected, String selectedName, String color, String textColor) {
    if (value == 'Detail'){
      BlocProvider.of<NavigatorBloc>(context)
          .add(NavigateToDetailSalesActivityPage(context, [dataKanban, 'Data Pelanggan', '', idSelected]));
    }else if(value == 'Ubah Tahapan'){
      TemplateCRUDLayanan().showDialogPindahTahapan(context, dataTahapan, dataKanban, idSelected, selectedName, color, textColor, 'data', "").then((v){
        if(v[0] == true || v[1] == 'refresh'){
          BlocProvider.of<TotalKambanBloc>(context).add(getTotalKambanEvent(context, idSelected, modelFilter));
          BlocProvider.of<KambanBloc>(context).add(getListDataKambanEvent(context, idSelected, modelFilter));
        }
      });
    }else if(value == 'Hapus'){
      TemplateConfirmationDialog(
          "Apakah Anda yakin akan menghapus data ini?",
              () => BlocProvider.of<KambanBloc>(context)
              .add(deleteKambanEvent(context, scaffoldKeys, dataKanban.idPipelineMain, idSelected)),
          context);
    }else if(value == 'Batalkan'){
      TemplateConfirmationDialog(
          "Apakah Anda yakin akan membatalkan tahapan data ini?",
              () => BlocProvider.of<KambanBloc>(context)
              .add(batalkanKambanEvent(context, scaffoldKeys, dataKanban.idPipelineMain, idSelected)),
          context);
    }else if(value == 'Pindah Bulan'){
      DateFormat dateFormatView = DateFormat('MMMM', 'id_ID');
      TemplateConfirmationDialog(
          "Apakah Anda yakin akan membawa data ${selectedName} ini ke bulan ${dateFormatView.format(DateTime.now())}?",marginHeight: 35,
              () => {
                  Navigator.pop(context),
                  BlocProvider.of<KambanBloc>(context)
                .add(pindahBulanKambanEvent(context, scaffoldKeys, dataKanban.idPipelineMain, dataKanban.idPipelineMainLog, idSelected))
              },
          context);
    }else if(value == 'Setujui'){
      TemplateConfirmationDialog(
          "Apakah Anda yakin akan menyetujui kanban ini?",marginHeight: 35,
              () => {
            BlocProvider.of<ApproverBloc>(context)
                .add(SetujuiKanbanEvent(context, dataKanban, dataKanban.idPipelineMain!, dataKanban.idPipelineMainLog!, idSelected, modelFilter!, 'list_data'))
          },
          context);
    }else if(value == 'Tolak'){
      DataTahapan? _dataTahapanM;
      dataTahapan.forEach((element) {
        if(element.id == idSelected){
          _dataTahapanM = element;
        }
      });
      TemplateConfirmationDialog(
          "Apakah Anda yakin akan menolak kanban ini?",marginHeight: 35,
              () => {
            BlocProvider.of<ApproverBloc>(context)
                .add(TolakKanbanEvent(context, "", dataKanban, dataKanban.idPipelineMain!, dataKanban.idPipelineMainLog!, idSelected, _dataTahapanM!.jenis!, modelFilter!, 'list_data'))
          },
          context);
    }
  }

  // void showDialogUbahTahapan(BuildContext context, List<DataTahapan> dataTahapan, DataKanban dataKanban, String idSelected, String selectedName, String color, String textColor){
  //   GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  //   DataTahapan? _selected;
  //   TextEditingController keterangan = TextEditingController();
  //
  //   showModalBottomSheet(
  //       context: context,
  //       showDragHandle: true,
  //       isDismissible: false,
  //       shape: RoundedRectangleBorder(
  //           borderRadius: BorderRadius.circular(18)
  //       ),
  //       builder: (BuildContext _context){
  //         return Scaffold(
  //           body: StatefulBuilder(
  //               builder: (BuildContext con, StateSetter setState) {
  //                 return Stack(
  //                   children: [
  //                     Column(
  //                       crossAxisAlignment: CrossAxisAlignment.start,
  //                       mainAxisAlignment: MainAxisAlignment.start,
  //                       children: [
  //                         Container(
  //                           margin: EdgeInsets.fromLTRB(27, 0, 27, 0),
  //                           child: Row(
  //                             mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                             children: [
  //                               Text("Pindah Tahapan", style: TextStyle(fontWeight: FontWeight.w700, fontSize: 14),),
  //                               GestureDetector(
  //                                   onTap: ()=> Navigator.pop(context),
  //                                   child: Icon(Icons.close, size: 21))
  //                             ],
  //                           ),
  //                         ),
  //                         SizedBox(height: 7),
  //                         Divider(thickness: 1, color: Colors.grey.shade400),
  //                         SizedBox(height: 7),
  //                         Row(
  //                           mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                           children: [
  //                             Container(
  //                                 margin: EdgeInsets.fromLTRB(27, 0, 27, 0),
  //                                 child: Text("Tahapan Sekarang", style: TextStyle(fontSize: 13, color: Colors.grey))),
  //                             Container(
  //                                 margin: EdgeInsets.fromLTRB(27, 0, 27, 0),
  //                                 padding: EdgeInsets.fromLTRB(17, 7, 17, 7),
  //                                 decoration: BoxDecoration(
  //                                   borderRadius: BorderRadius.circular(9),
  //                                   color: Color(int.parse(color)),
  //                                 ),
  //                                 child: Text(selectedName, style: TextStyle(fontSize: 14, color: Color(int.parse(textColor))))),
  //                           ],
  //                         ),
  //                         // SizedBox(height: 3),
  //
  //                         SizedBox(height: 3),
  //                         Divider(thickness: 1),
  //                         Container(
  //                             margin: EdgeInsets.fromLTRB(27, 0, 27, 0),
  //                             child: Text("Pindah Ke", style: TextStyle(fontSize: 13, color: Colors.grey))),
  //                         SizedBox(height: 3),
  //                         Expanded(
  //                           child: Container(
  //                             margin: EdgeInsets.only(bottom: 60, top: 7),
  //                             child: ListView.builder(
  //                                 itemCount: dataTahapan.length,
  //                                 // physics: NeverScrollableScrollPhysics(),
  //                                 shrinkWrap: true,
  //                                 itemBuilder: (context, index){
  //                                   return Container(
  //                                     margin: EdgeInsets.fromLTRB(27, 0, 27, 3),
  //                                     // color: Colors.yellow,
  //                                     child: Row(
  //                                       mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                                       children: [
  //                                         Text(dataTahapan[index].nama!),
  //                                         dataTahapan[index].id == idSelected
  //                                           ? Container(
  //                                               width: 19,
  //                                               height: 19,
  //                                               margin: EdgeInsets.only(right: 14, bottom: 9, top: 9),
  //                                               decoration: BoxDecoration(
  //                                                 shape: BoxShape.circle,
  //                                                 border: Border.all(color: Colors.grey.shade600),
  //                                                 color: Colors.grey.shade400,
  //                                               ),
  //                                             )
  //                                           : Radio<DataTahapan>(
  //                                               visualDensity: VisualDensity(vertical: -3),
  //                                               value: dataTahapan[index],
  //                                               onChanged: (DataTahapan? value) {
  //                                                 setState(() {
  //                                                   _selected = value;
  //                                                 });
  //                                               },
  //                                               groupValue: _selected,
  //                                             ),
  //                                       ],
  //                                     ),
  //                                   );
  //                                 }
  //                             ),
  //                           ),
  //                         )
  //                       ],
  //                     ),
  //                     Positioned(
  //                         bottom: 0,
  //                         child: Container(
  //                           padding: EdgeInsets.only(left: 22, right: 22, top: 7, bottom: 7),
  //                           decoration: BoxDecoration(
  //                             boxShadow: [
  //                               BoxShadow(
  //                                   color: Colors.grey.shade300,
  //                                   spreadRadius: 2
  //                               ),
  //                             ],
  //                             color: Colors.white,
  //                           ),
  //                           height: 51,
  //                           width: MediaQuery.of(context).size.width,
  //                           child: TemplateButton(
  //                             onClick: () async {
  //                               if(_selected == null){
  //                                 showSnackBarDelayed(scaffoldKey, "Pilih tujuan tahapan terlebih dahulu", context, backgroundColor: Colors.red, textColor: Colors.white);
  //                               }else if(_selected!.id == idSelected){
  //                                 showSnackBarDelayed(scaffoldKey, "Tahapan sekarang sama dengan tahapan tujuan", context, backgroundColor: Colors.red, textColor: Colors.white);
  //                               }else{
  //                                 if(_selected!.jenis == 'wont'){
  //                                   showModalBottomSheet(
  //                                       context: context,
  //                                       showDragHandle: true,
  //                                       isDismissible: false,
  //                                       shape: RoundedRectangleBorder(
  //                                           borderRadius: BorderRadius.circular(18)
  //                                       ),
  //                                       builder: (_context){
  //                                         List<DataRow> listTable = [];
  //                                         dataKanban.layanan!.forEach((element) {
  //                                           int i = 0;
  //                                           listTable.add(DataRow(
  //                                             color: i%2==0?MaterialStateProperty.all(Colors.white):MaterialStateProperty.all(Colors.grey),
  //                                               cells: [
  //                                                 DataCell(Center(
  //                                                     child: Container(
  //                                                         padding: EdgeInsets.symmetric(vertical: 3),
  //                                                         child: Text("${element.namaLayanan} (${element.jumlah})", style: TextStyle(fontSize: 12))))),
  //                                                 DataCell(Center(
  //                                                     child: Container(
  //                                                         padding: EdgeInsets.symmetric(vertical: 3),
  //                                                         child: Text("${element.harga} (${element.diskon})", style: TextStyle(fontSize: 12))))),
  //                                                 DataCell(Center(
  //                                                     child: Container(
  //                                                         padding: EdgeInsets.symmetric(vertical: 3),
  //                                                         child: Text("${element.hargaTotal}", style: TextStyle(fontSize: 12)))))
  //                                               ]
  //                                           ));
  //                                           i++;
  //                                         });
  //                                         return Scaffold(
  //                                           body: Container(
  //                                             height: double.infinity,
  //                                             margin: EdgeInsets.fromLTRB(9,0,9,13),
  //                                             child: SingleChildScrollView(
  //                                               child: Column(
  //                                                 mainAxisAlignment: MainAxisAlignment.spaceBetween,
  //                                                 children: [
  //                                                   Column(
  //                                                     crossAxisAlignment: CrossAxisAlignment.start,
  //                                                     mainAxisAlignment: MainAxisAlignment.start,
  //                                                     children: [
  //                                                       Text(
  //                                                         "Layanan",
  //                                                         style: TextStyle(color: Colors.grey[600], fontWeight: FontWeight.bold, fontSize: 14),
  //                                                       ),
  //                                                       SizedBox(height: 3),
  //                                                       Container(
  //                                                           height: listTable.length > 8 ? 200 : null,
  //                                                           decoration: BoxDecoration(
  //                                                             border: Border.all(),
  //                                                             // color : Colors.yellow,
  //                                                           ),
  //                                                           width: MediaQuery.of(context).size.width,
  //                                                           child: SingleChildScrollView(
  //                                                             child: Column(
  //                                                               children: [
  //                                                                 Container(
  //                                                                   width: MediaQuery.of(context).size.width,
  //                                                                   child: DataTable(
  //                                                                     horizontalMargin: 0,
  //                                                                     columnSpacing: 0,
  //                                                                     headingRowHeight: 25,
  //                                                                     dataRowHeight: 25,
  //                                                                     border: TableBorder.all(),
  //                                                                     headingRowColor: MaterialStateProperty.all(CustomStyle.color1),
  //                                                                     rows: listTable,
  //                                                                     columns: [
  //                                                                       DataColumn(label: Expanded(child: Center(child: Text("Layanan (Jumlah)", style: TextStyle(fontSize: 12, fontWeight: FontWeight.bold, color: Colors.white))))),
  //                                                                       DataColumn(label: Expanded(child: Center(child: Text("Harga (Diskon)", style: TextStyle(fontSize: 12, fontWeight: FontWeight.bold, color: Colors.white))))),
  //                                                                       DataColumn(label: Expanded(child: Center(child: Text("Harga Total", style: TextStyle(fontSize: 12, fontWeight: FontWeight.bold, color: Colors.white)))))
  //                                                                     ],
  //                                                                   ),
  //                                                                 ),
  //                                                                 dataKanban.layanan!.length > 0 ? Container() :
  //                                                                 Container(
  //                                                                     margin: EdgeInsets.symmetric(vertical: 13),
  //                                                                     child: Text("Tidak ada data", style: TextStyle(fontSize: 13),))
  //                                                               ],
  //                                                             ),
  //                                                           )
  //                                                       ),
  //                                                       SizedBox(height: 13),
  //                                                       TemplateTextFieldForm(
  //                                                         adaValidasi: true,
  //                                                         controller: keterangan,
  //                                                         color: Colors.grey[600],
  //                                                         maxLine: 5,
  //                                                         minLine: 5,
  //                                                         titleText: "Keterangan",
  //                                                         radius: CustomStyle.formRadius,
  //                                                         hintText: "Keterangan",
  //                                                       ),
  //                                                     ],
  //                                                   ),
  //                                                   Container(
  //                                                     margin: EdgeInsets.only(top: 127),
  //                                                     child: TemplateButton(
  //                                                       expand: true,
  //                                                       onClick: (){
  //                                                         if(keterangan.text.trim().isEmpty){
  //                                                           showSnackBarDelayed(scaffoldKey, "Keterangan wajib diisi", _context, backgroundColor: Colors.red, textColor: Colors.white);
  //                                                         }else{
  //                                                           TemplateConfirmationDialog(
  //                                                               "Apakah Anda yakin akan mengubah tahapan ini ke ${_selected!.nama}?",
  //                                                                   () =>  BlocProvider.of<KambanBloc>(context)
  //                                                                   .add(ubahTahapanKambanEvent(context, dataKanban, idSelected, dataKanban.statusPengajuan!.value, idSelected, selectedName, _selected!.id, _selected!.nama, false, keterangan.text, "")),
  //                                                               context);
  //                                                         }
  //                                                       },
  //                                                       label: 'SUBMIT',
  //                                                     ),
  //                                                   )
  //                                                 ],
  //                                               ),
  //                                             ),
  //                                           ),
  //                                         );
  //                                       }
  //                                   );
  //                                 }
  //                                 else if(_selected!.jenis == 'lost'){
  //                                   showModalBottomSheet(
  //                                       context: context,
  //                                       showDragHandle: true,
  //                                       isDismissible: false,
  //                                       shape: RoundedRectangleBorder(
  //                                           borderRadius: BorderRadius.circular(18)
  //                                       ),
  //                                       builder: (_context){
  //                                         return Scaffold(
  //                                           body: Container(
  //                                             height: double.infinity,
  //                                             margin: EdgeInsets.fromLTRB(9,0,9,13),
  //                                             child: SingleChildScrollView(
  //                                               child: Column(
  //                                                 children: [
  //                                                   TemplateTextFieldForm(
  //                                                     adaValidasi: true,
  //                                                     controller: keterangan,
  //                                                     color: Colors.grey[600],
  //                                                     maxLine: 5,
  //                                                     minLine: 5,
  //                                                     titleText: "Keterangan",
  //                                                     radius: CustomStyle.formRadius,
  //                                                     hintText: "Keterangan",
  //                                                   ),
  //                                                   Container(
  //                                                     margin: EdgeInsets.only(top: 197),
  //                                                     child: TemplateButton(
  //                                                       expand: true,
  //                                                       onClick: (){
  //                                                         if(keterangan.text.trim().isEmpty){
  //                                                           showSnackBarDelayed(scaffoldKey, "Keterangan wajib diisi", _context, backgroundColor: Colors.red, textColor: Colors.white);
  //                                                         }else{
  //                                                           TemplateConfirmationDialog(
  //                                                               "Apakah Anda yakin akan mengubah tahapan ini ke ${_selected!.nama}?",
  //                                                                   () =>  BlocProvider.of<KambanBloc>(context)
  //                                                                   .add(ubahTahapanKambanEvent(context, dataKanban, idSelected, dataKanban.statusPengajuan!.value, idSelected, selectedName, _selected!.id, _selected!.nama, false, "", keterangan.text)),
  //                                                               context);
  //                                                         }
  //                                                       },
  //                                                       label: 'SUBMIT',
  //                                                     ),
  //                                                   )
  //                                                 ],
  //                                               ),
  //                                             ),
  //                                           ),
  //                                         );
  //                                       }
  //                                   );
  //                                 }
  //                                 else{
  //                                   TemplateConfirmationDialog(
  //                                       "Apakah Anda yakin akan mengubah tahapan ini ke ${_selected!.nama}?",
  //                                           () =>  BlocProvider.of<KambanBloc>(context)
  //                                           .add(ubahTahapanKambanEvent(context, dataKanban, idSelected, dataKanban.statusPengajuan!.value, idSelected, selectedName, _selected!.id, _selected!.nama, false, "", "")),
  //                                       context);
  //                                 }
  //                               }
  //                             },
  //                             label: "SUBMIT",
  //                             color: CustomStyle.color1,
  //                             heightButton: 28,
  //                             radius: CustomStyle.boxRadius + 4,
  //                             bold: true,
  //                             fontSize: CustomStyle.fontSizeSmall - 1,
  //                             iconSize: 16,
  //                             paddingTopBottom: 0,
  //                           ),
  //                         )
  //                     )
  //                   ],
  //                 );
  //               }
  //           ),
  //         );
  //       }
  //   );
  // }
}
