import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Bloc/Summary/SummaryBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mRangkumanAbsensiPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/FilterBottomSheet.dart';
import 'package:absenkuv3/UI/Template/FilterHeaderRekapSheet.dart';
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanRekapKaryawan extends StatefulWidget {
  @override
  _HalamanRekapKaryawanState createState() => _HalamanRekapKaryawanState();
}

class _HalamanRekapKaryawanState extends State<HalamanRekapKaryawan> {
  ModelFilter? modelFilterDataAbsensi;

  @override
  void initState() {
    //  BlocProvider.of<SummaryBloc>(context)
    //     .add(getSummaryEvent(context, ModelFilter(monthYear: DateTime.now())));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageRangkumanAbsensiModel>(
        future: PengaturanBahasa().rangkumanAbsensi(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return Scaffold(
              backgroundColor: CustomStyle.backgroundColor,
              appBar: AppBar(
                centerTitle: true,
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
                title: Text(
                  snapshot.data!.menuRangkumanAbsensi!.title!,
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                ),
              ),
              body: Stack(
                children: [
                  Column(
                    children: [
                      Container(
                        height: 50,
                        width: MediaQuery.of(context).size.width * 1.5,
                        child: BlocListener<FilterBottomSheetBloc,
                                FilterBottomSheetState>(
                            listener: (BuildContext context,
                                FilterBottomSheetState state) {
                              if (state is setFilterSuccess) {
                                modelFilterDataAbsensi = state.modelFilter;
                                if (modelFilterDataAbsensi!.idPegawai != null &&
                                    modelFilterDataAbsensi!.monthYear != null)
                                  BlocProvider.of<SummaryBloc>(context).add(
                                      getSummaryEvent(
                                          context, modelFilterDataAbsensi));
                              }
                            },
                            child: FilterHeaderRekapSheet()),
                      ),
                    ],
                  ),
                  Padding(
                    padding: const EdgeInsets.only(top: 50),
                    child: BlocBuilder<SummaryBloc, SummaryState>(
                        builder: (BuildContext context, SummaryState state) {
                      if (state is getSummarySuccessState) {
                        return Container(
                          margin: EdgeInsets.symmetric(horizontal: 20),
                          padding: EdgeInsets.fromLTRB(8, 30, 8, 26),
                          child: Column(
                            children: [
                              Text(
                                modelFilterDataAbsensi!.namaPegawai!,
                                style: TextStyle(
                                    fontSize: CustomStyle.fontSizeNormal - 1,
                                    fontWeight: FontWeight.w700,
                                    color: CustomStyle.fontColorBlack),
                              ),
                              SizedBox(
                                height: 12,
                              ),
                              Divider(thickness: 1),
                              SizedBox(
                                height: 8,
                              ),
                              TemplateRow(
                                snapshot
                                    .data!.menuRangkumanAbsensi!.data!.hadir!,
                                "${state.data!.hadir} ${snapshot.data!.menuRangkumanAbsensi!.data!.hari}",
                                null,
                                CustomStyle.fontColorBlack,
                                fontSize: CustomStyle.fontSizeNormal - 1,
                                titikDua: true,
                                flex: [4, 6, 0],
                              ),
                              SizedBox(
                                height: 3,
                              ),
                              Divider(thickness: 1),
                              SizedBox(
                                height: 3,
                              ),
                              TemplateRow(
                                snapshot
                                    .data!.menuRangkumanAbsensi!.data!.alpa!,
                                "${state.data!.alpha} ${snapshot.data!.menuRangkumanAbsensi!.data!.hari}",
                                null,
                                CustomStyle.fontColorBlack,
                                fontSize: CustomStyle.fontSizeNormal - 1,
                                titikDua: true,
                                flex: [4, 6, 0],
                              ),
                              SizedBox(
                                height: 3,
                              ),
                              Divider(thickness: 1),
                              SizedBox(
                                height: 3,
                              ),
                              TemplateRow(
                                snapshot
                                    .data!.menuRangkumanAbsensi!.data!.sakit!,
                                "${state.data!.sakit} ${snapshot.data!.menuRangkumanAbsensi!.data!.hari}",
                                null,
                                CustomStyle.fontColorBlack,
                                fontSize: CustomStyle.fontSizeNormal - 1,
                                titikDua: true,
                                flex: [4, 6, 0],
                              ),
                              SizedBox(
                                height: 3,
                              ),
                              Divider(thickness: 1),
                              SizedBox(
                                height: 3,
                              ),
                              TemplateRow(
                                snapshot
                                    .data!.menuRangkumanAbsensi!.data!.izin!,
                                "${state.data!.izin} ${snapshot.data!.menuRangkumanAbsensi!.data!.hari}",
                                null,
                                CustomStyle.fontColorBlack,
                                fontSize: CustomStyle.fontSizeNormal - 1,
                                titikDua: true,
                                flex: [4, 6, 0],
                              ),
                              SizedBox(
                                height: 3,
                              ),
                              Divider(thickness: 1),
                              SizedBox(
                                height: 3,
                              ),
                              TemplateRow(
                                snapshot
                                    .data!.menuRangkumanAbsensi!.data!.cuti!,
                                "${state.data!.cuti} ${snapshot.data!.menuRangkumanAbsensi!.data!.hari}",
                                null,
                                CustomStyle.fontColorBlack,
                                fontSize: CustomStyle.fontSizeNormal - 1,
                                titikDua: true,
                                flex: [4, 6, 0],
                              ),
                              SizedBox(
                                height: 3,
                              ),
                              Divider(thickness: 1),
                              SizedBox(
                                height: 3,
                              ),
                              TemplateRow(
                                snapshot
                                    .data!.menuRangkumanAbsensi!.data!.lembur!,
                                "${state.data!.lembur} ${snapshot.data!.menuRangkumanAbsensi!.data!.kali} (${state.data!.menitLembur} ${snapshot.data!.menuRangkumanAbsensi!.data!.menit})",
                                null,
                                CustomStyle.fontColorBlack,
                                fontSize: CustomStyle.fontSizeNormal - 1,
                                titikDua: true,
                                flex: [4, 6, 0],
                              ),
                              SizedBox(
                                height: 3,
                              ),
                              Divider(thickness: 1),
                              SizedBox(
                                height: 3,
                              ),
                              TemplateRow(
                                snapshot.data!.menuRangkumanAbsensi!.data!
                                    .terlambat!,
                                "${state.data!.terlambat} ${snapshot.data!.menuRangkumanAbsensi!.data!.kali} (${state.data!.menitTerlambat} ${snapshot.data!.menuRangkumanAbsensi!.data!.menit})",
                                null,
                                CustomStyle.fontColorBlack,
                                fontSize: CustomStyle.fontSizeNormal - 1,
                                titikDua: true,
                                flex: [4, 6, 0],
                              ),
                              SizedBox(
                                height: 3,
                              ),
                              Divider(thickness: 1),
                              SizedBox(
                                height: 3,
                              ),
                              TemplateRow(
                                snapshot.data!.menuRangkumanAbsensi!.data!
                                    .pulangCepat!,
                                "${state.data!.pulangCepat} ${snapshot.data!.menuRangkumanAbsensi!.data!.kali} (${state.data!.menitPulangCepat} ${snapshot.data!.menuRangkumanAbsensi!.data!.menit})",
                                null,
                                CustomStyle.fontColorBlack,
                                fontSize: CustomStyle.fontSizeNormal - 1,
                                titikDua: true,
                                flex: [4, 6, 0],
                              ),
                              SizedBox(
                                height: 3,
                              ),
                              Divider(thickness: 1),
                              SizedBox(
                                height: 3,
                              ),
                              TemplateRow(
                                snapshot.data!.menuRangkumanAbsensi!.data!
                                    .tidakAbsenPulang!,
                                "${state.data!.tidakAbsenPulang} ${snapshot.data!.menuRangkumanAbsensi!.data!.kali}",
                                null,
                                CustomStyle.fontColorBlack,
                                fontSize: CustomStyle.fontSizeNormal - 1,
                                titikDua: true,
                                flex: [4, 6, 0],
                              ),
                            ],
                          ),
                        );
                      } else if (state is getSummarySuccessNullState) {
                        return Container(
                            height: MediaQuery.of(context).size.height,
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Center(
                                  child: Image.asset(
                                    ValueImage.noData,
                                    height: 250,
                                  ),
                                ),
                                Container(
                                  child: Center(
                                      child: TemplateButton(
                                    label: snapshot
                                        .data!.menuRangkumanAbsensi!.message,
                                    gradient: LinearGradient(
                                        begin: Alignment.centerLeft,
                                        end: Alignment.centerRight,
                                        stops: [
                                          0.0,
                                          0.5,
                                          1.0
                                        ],
                                        colors: [
                                          CustomStyle.color1,
                                          Colors.blue[400]!,
                                          CustomStyle.color1,
                                        ]),
                                    fontSize: CustomStyle.fontSizeNormal,
                                    expandText: true,
                                    textAlignCenter: true,
                                  )),
                                  padding: EdgeInsets.symmetric(horizontal: 40),
                                )
                              ],
                            ));
                      } else if (state is SummaryProgressState)
                        return Center(
                          child: CircularProgressIndicator(
                            strokeWidth: 8,
                          ),
                        );
                      else
                        return Container(
                            height: MediaQuery.of(context).size.height,
                            child: Column(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Center(
                                  child: Image.asset(
                                    ValueImage.noData,
                                    height: 250,
                                  ),
                                ),
                                Container(
                                  child: Center(
                                      child: TemplateButton(
                                    label: snapshot
                                        .data!.menuRangkumanAbsensi!.message,
                                    gradient: LinearGradient(
                                        begin: Alignment.centerLeft,
                                        end: Alignment.centerRight,
                                        stops: [
                                          0.0,
                                          0.5,
                                          1.0
                                        ],
                                        colors: [
                                          CustomStyle.color1,
                                          Colors.blue[400]!,
                                          CustomStyle.color1,
                                        ]),
                                    fontSize: CustomStyle.fontSizeNormal,
                                    expandText: true,
                                    textAlignCenter: true,
                                  )),
                                  padding: EdgeInsets.symmetric(horizontal: 40),
                                )
                              ],
                            ));
                    }),
                  ),
                  // Positioned(
                  //   bottom: 16,
                  //   right: 14,
                  //   child: BlocListener<FilterBottomSheetBloc,
                  //           FilterBottomSheetState>(
                  //       listener: (BuildContext context,
                  //           FilterBottomSheetState state) {
                  //         if (state is setFilterSuccess) {
                  //           modelFilterDataAbsensi = state.modelFilter;
                  //           if (modelFilterDataAbsensi!.idPegawai != null &&
                  //               modelFilterDataAbsensi!.monthYear != null)
                  //             BlocProvider.of<SummaryBloc>(context).add(
                  //                 getSummaryEvent(
                  //                     context, modelFilterDataAbsensi));
                  //         }
                  //       },
                  //       child: FilterBottomSheet(
                  //         adaFilterRangeTanggal: false,
                  //       )),
                  // )
                
                ],
              ),
            );
          } else {
            return CircularProgressIndicator(strokeWidth: 8);
          }
        });
  }
}

class TemplateRow extends StatelessWidget {
  final String title;
  final String? subTitle;
  final Color? color;
  final String? imageUrl;
  final bool titikDua;
  final fontSize;
  final List<int>? flex;
  final String? lat;
  final String? long;
  TemplateRow(this.title, this.subTitle, this.imageUrl, this.color,
      {this.fontSize,
      this.flex,
      this.titikDua = false,
      this.lat = '-',
      this.long = '-'});

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        Expanded(
          flex: flex != null ? flex![0] : 4,
          child: Text(
            title,
            style: TextStyle(
                fontWeight: FontWeight.w600,
                color: color,
                fontSize: fontSize ?? CustomStyle.fontSizeSmall - 1),
          ),
        ),
        SizedBox(
          width: 12,
        ),
        titikDua
            ? Row(
                children: [
                  SizedBox(
                    width: 12,
                  ),
                  Text(
                    ":",
                    style: TextStyle(
                        color: CustomStyle.fontColorBlack,
                        fontSize: fontSize ?? CustomStyle.fontSizeSmall - 1),
                  ),
                  SizedBox(
                    width: 12,
                  ),
                ],
              )
            : Container(),
        Expanded(
          flex: flex != null ? flex![1] : 7,
          child: Text(
            subTitle!,
            style: TextStyle(
                color: CustomStyle.fontColorBlack,
                fontSize: fontSize ?? CustomStyle.fontSizeSmall - 1),
          ),
        ),
        SizedBox(
          width: 8,
        )
      ],
    );
  }
}
