import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/MonitorAbsensi/MonitorListBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Summary/SummaryBloc.dart';
import 'package:absenkuv3/Bloc/Summary/rekap/SummaryRekapAlpaBloc.dart';
import 'package:absenkuv3/Bloc/Summary/rekap/SummaryRekapCutiBloc.dart';
import 'package:absenkuv3/Bloc/Summary/rekap/SummaryRekapHadirBloc.dart';
import 'package:absenkuv3/Bloc/Summary/rekap/SummaryRekapIzinBloc.dart';
import 'package:absenkuv3/Bloc/Summary/rekap/SummaryRekapLemburBloc.dart';
import 'package:absenkuv3/Bloc/Summary/rekap/SummaryRekapPulangCepatBloc.dart';
import 'package:absenkuv3/Bloc/Summary/rekap/SummaryRekapSakitBloc.dart';
import 'package:absenkuv3/Bloc/Summary/rekap/SummaryRekapTAPBloc.dart';
import 'package:absenkuv3/Bloc/Summary/rekap/SummaryRekapTerlambatBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mRekapPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Dashboard/komponenDashboard.dart';
import 'package:absenkuv3/UI/Template/MonthPicker/Bloc/MonthPickerRekapBloc.dart';
import 'package:absenkuv3/UI/Template/MonthPicker/UI/templateMonthPickerRekap.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateMenu.dart';
import 'package:absenkuv3/UI/Template/verticalDivider.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanRekap extends StatefulWidget {
  @override
  _HalamanRekapState createState() => _HalamanRekapState();
}

class _HalamanRekapState extends State<HalamanRekap> {
  @override
  void initState() {
    super.initState();
    BlocProvider.of<MonthPickerRekapBloc>(context).add(SetDate(DateTime.now()));
    BlocProvider.of<SummaryRekapHadirBloc>(context).add(
        getSummaryRekapHadirEvent(
            context, ModelFilter(monthYear: DateTime.now())));
    BlocProvider.of<SummaryRekapAlpaBloc>(context).add(getSummaryRekapAlpaEvent(
        context, ModelFilter(monthYear: DateTime.now())));
    BlocProvider.of<SummaryRekapSakitBloc>(context).add(
        getSummaryRekapSakitEvent(
            context, ModelFilter(monthYear: DateTime.now())));
    BlocProvider.of<SummaryRekapIzinBloc>(context).add(getSummaryRekapIzinEvent(
        context, ModelFilter(monthYear: DateTime.now())));
    BlocProvider.of<SummaryRekapCutiBloc>(context).add(getSummaryRekapCutiEvent(
        context, ModelFilter(monthYear: DateTime.now())));
    BlocProvider.of<SummaryRekapLemburBloc>(context).add(
        getSummaryRekapLemburEvent(
            context, ModelFilter(monthYear: DateTime.now())));
    BlocProvider.of<SummaryRekapTerlambatBloc>(context).add(
        getSummaryRekapTerlambatEvent(
            context, ModelFilter(monthYear: DateTime.now())));
    BlocProvider.of<SummaryRekapPulangCepatBloc>(context).add(
        getSummaryRekapPulangCepatEvent(
            context, ModelFilter(monthYear: DateTime.now())));
    BlocProvider.of<SummaryRekapTAPBloc>(context).add(getSummaryRekapTAPEvent(
        context, ModelFilter(monthYear: DateTime.now())));
  }
  @override
  void didChangeDependencies() {
    super.didChangeDependencies();
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageRekapModel>(
        future: PengaturanBahasa().rekap(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return Scaffold(
              backgroundColor: CustomStyle.backgroundColor,
              body: Container(
                height: MediaQuery.of(context).size.height - 50,
                child: SingleChildScrollView(
                  child: Stack(
                    children: [
                      Container(
                        width: double.infinity,
                        height: MediaQuery.of(context).size.height / 2.5,
                        child: Image.asset(
                          ValueImage.headerBiruDashboard,
                          fit: BoxFit.cover,
                        ),
                      ),
                      SafeArea(
                        child: Padding(
                          padding: const EdgeInsets.fromLTRB(0, 20, 0, 0),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: <Widget>[
                              Padding(
                                padding:
                                    const EdgeInsets.symmetric(horizontal: 15),
                                child: Row(
                                  children: <Widget>[
                                    Expanded(
                                      child: Text(
                                        snapshot.data!.menuRekap!.title!,
                                        style: TextStyle(
                                            fontSize:
                                                CustomStyle.fontSizeSubTitle,
                                            fontWeight: FontWeight.bold,
                                            color: Colors.white),
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                              SizedBox(
                                height: 18,
                              ),
                              ConstrainedBox(
                                  constraints: BoxConstraints(minHeight: 359),
                                  child: Container(
                                      margin:
                                          EdgeInsets.symmetric(horizontal: 20),
                                      decoration: CustomStyle.boxDecoration,
                                      padding:
                                          EdgeInsets.fromLTRB(16, 20, 16, 20),
                                      child: Column(
                                        children: [
                                          Row(
                                            mainAxisAlignment:
                                                MainAxisAlignment.spaceBetween,
                                            children: [
                                              Text(
                                                snapshot.data!.menuRekap!
                                                    .rekapAbsensi!.header!,
                                                style: TextStyle(
                                                    fontSize: CustomStyle
                                                            .fontSizeNormal +
                                                        1,
                                                    fontWeight: FontWeight.w700,
                                                    color: CustomStyle
                                                        .fontColorBlack),
                                              ),
                                              BlocListener<MonthPickerRekapBloc,
                                                  MonthPickerRekapState>(
                                                listener: (BuildContext context,
                                                    MonthPickerRekapState state) {
                                                  BlocProvider.of<
                                                              SummaryRekapHadirBloc>(
                                                          context)
                                                      .add(getSummaryRekapHadirEvent(
                                                          context,
                                                          ModelFilter(
                                                              monthYear: state
                                                                  .dateTime)));
                                                  BlocProvider.of<
                                                              SummaryRekapAlpaBloc>(
                                                          context)
                                                      .add(getSummaryRekapAlpaEvent(
                                                          context,
                                                          ModelFilter(
                                                              monthYear: state
                                                                  .dateTime)));
                                                  BlocProvider.of<
                                                              SummaryRekapSakitBloc>(
                                                          context)
                                                      .add(getSummaryRekapSakitEvent(
                                                          context,
                                                          ModelFilter(
                                                              monthYear: state
                                                                  .dateTime)));
                                                  BlocProvider.of<
                                                              SummaryRekapIzinBloc>(
                                                          context)
                                                      .add(getSummaryRekapIzinEvent(
                                                          context,
                                                          ModelFilter(
                                                              monthYear: state
                                                                  .dateTime)));
                                                  BlocProvider.of<
                                                              SummaryRekapCutiBloc>(
                                                          context)
                                                      .add(getSummaryRekapCutiEvent(
                                                          context,
                                                          ModelFilter(
                                                              monthYear: state
                                                                  .dateTime)));
                                                  BlocProvider.of<
                                                              SummaryRekapLemburBloc>(
                                                          context)
                                                      .add(getSummaryRekapLemburEvent(
                                                          context,
                                                          ModelFilter(
                                                              monthYear: state
                                                                  .dateTime)));
                                                  BlocProvider.of<
                                                              SummaryRekapTerlambatBloc>(
                                                          context)
                                                      .add(getSummaryRekapTerlambatEvent(
                                                          context,
                                                          ModelFilter(
                                                              monthYear: state
                                                                  .dateTime)));
                                                  BlocProvider.of<
                                                              SummaryRekapPulangCepatBloc>(
                                                          context)
                                                      .add(getSummaryRekapPulangCepatEvent(
                                                          context,
                                                          ModelFilter(
                                                              monthYear: state
                                                                  .dateTime)));
                                                  BlocProvider.of<
                                                              SummaryRekapTAPBloc>(
                                                          context)
                                                      .add(getSummaryRekapTAPEvent(
                                                          context,
                                                          ModelFilter(
                                                              monthYear: state
                                                                  .dateTime)));
                                                },
                                                child:
                                                    TemplateMonthPickerRekap(),
                                              )

                                          ],
                                          ),
                                          SizedBox(
                                            height: 8,
                                          ),
                                          Divider(thickness: 1),
                                          SizedBox(
                                            height: 4,
                                          ),
                                          Row(
                                            children: <Widget>[
                                              // BlocBuilder<SummaryRekapHadirBloc,
                                              //     SummaryRekapHadirState>(
                                              //   builder: (context, state) {
                                              //     if (state
                                              //         is getSummaryRekapHadirSuccessState) {
                                              //       return BlocBuilder<
                                              //               MonthPickerRekapBloc,
                                              //               MonthPickerRekapState>(
                                              //           builder:
                                              //               (context, mps) {
                                              //         return templateKehadiran(
                                              //           snapshot
                                              //               .data!
                                              //               .menuRekap!
                                              //               .rekapAbsensi!
                                              //               .data!
                                              //               .hadir!,
                                              //           "${state.data!.hadir} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.hari}",
                                              //           1.0,
                                              //           state.data!.hadir == '0'
                                              //               ? CustomStyle
                                              //                   .fontColorBlack
                                              //               : Colors.green,
                                              //           valueFontSize: CustomStyle
                                              //                   .fontSizeSmall -
                                              //               1,
                                              //           action: true,
                                              //           onClick: () {
                                              //             BlocProvider.of<
                                              //                         NavigatorBloc>(
                                              //                     context)
                                              //                 .add(
                                              //                     NavigateToHalamanListMonitor(
                                              //                         context, [
                                              //               'H',
                                              //               mps.dateTime
                                              //             ]));
                                              //           },
                                              //         );
                                              //       });
                                              //     } else {
                                              //       return templateShimmerDashboard();
                                              //     }
                                              //   },
                                              // ),
                                              //
                                              BlocBuilder<SummaryRekapHadirBloc, SummaryRekapHadirState>(
                                                builder: (context, state) {
                                                  if (state is getSummaryRekapHadirSuccessState) {
                                                    return BlocBuilder<MonthPickerRekapBloc, MonthPickerRekapState>(
                                                      builder: (context, mps) {
                                                        var monthPickerState = mps;
                                                        return templateKehadiran(
                                                          snapshot.data!.menuRekap!.rekapAbsensi!.data!.hadir!,
                                                          "${state.data!.hadir} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.hari}",
                                                          1.0,
                                                          state.data!.hadir == '0' ? CustomStyle.fontColorBlack : Colors.green,
                                                          valueFontSize: CustomStyle.fontSizeSmall - 1,
                                                          action: true,
                                                          onClick: () {
                                                            BlocProvider.of<NavigatorBloc>(context).add(NavigateToHalamanListMonitor(context, ['H', monthPickerState.dateTime]));
                                                          },
                                                        );
                                                      },
                                                    );
                                                  } else {
                                                    return templateShimmerDashboard();
                                                  }
                                                },
                                              ),
                                              VerticalDividerAbsenku(),
                                              BlocBuilder<SummaryRekapAlpaBloc,
                                                  SummaryRekapAlpaState>(
                                                builder: (context, state) {
                                                  if (state
                                                      is getSummaryRekapAlpaSuccessState) {
                                                    return BlocBuilder<
                                                            MonthPickerRekapBloc,
                                                            MonthPickerRekapState>(
                                                        builder:
                                                            (context, mps) {
                                                      return templateKehadiran(
                                                        snapshot
                                                            .data!
                                                            .menuRekap!
                                                            .rekapAbsensi!
                                                            .data!
                                                            .alpa!,
                                                        "${state.data!.alpha} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.hari}",
                                                        1.0,
                                                        state.data!.alpha == '0'
                                                            ? CustomStyle
                                                                .fontColorBlack
                                                            : Colors.redAccent,
                                                        valueFontSize: CustomStyle
                                                                .fontSizeSmall -
                                                            1,
                                                        action: true,
                                                        onClick: () {
                                                          BlocProvider.of<
                                                                      NavigatorBloc>(
                                                                  context)
                                                              .add(
                                                                  NavigateToHalamanListMonitor(
                                                                      context, [
                                                            'A',
                                                            mps.dateTime
                                                          ]));
                                                        },
                                                      );
                                                    });
                                                  } else {
                                                    return templateShimmerDashboard();
                                                  }
                                                },
                                              ),
                                              VerticalDividerAbsenku(),
                                              BlocBuilder<SummaryRekapSakitBloc,
                                                  SummaryRekapSakitState>(
                                                builder: (context, state) {
                                                  if (state
                                                      is getSummaryRekapSakitSuccessState) {
                                                    return BlocBuilder<
                                                            MonthPickerRekapBloc,
                                                            MonthPickerRekapState>(
                                                        builder:
                                                            (context, mps) {
                                                      return templateKehadiran(
                                                          snapshot
                                                              .data!
                                                              .menuRekap!
                                                              .rekapAbsensi!
                                                              .data!
                                                              .sakit!,
                                                          "${state.data!.sakit} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.hari}",
                                                          1.0,
                                                          state.data!.sakit ==
                                                                  '0'
                                                              ? CustomStyle
                                                                  .fontColorBlack
                                                              : Colors
                                                                  .orangeAccent,
                                                          valueFontSize: CustomStyle
                                                                  .fontSizeSmall -
                                                              1,
                                                          action: true,
                                                          onClick: () {
                                                        BlocProvider.of<
                                                                    NavigatorBloc>(
                                                                context)
                                                            .add(
                                                                NavigateToHalamanListMonitorIzin(
                                                                    context, [
                                                          'S',
                                                          mps.dateTime
                                                        ]));
                                                      });
                                                    });
                                                  } else {
                                                    return templateShimmerDashboard();
                                                  }
                                                },
                                              ),
                                            ],
                                          ),
                                          SizedBox(
                                            height: 4,
                                          ),
                                          Divider(
                                            thickness: 1,
                                          ),
                                          SizedBox(
                                            height: 4,
                                          ),
                                          Row(
                                            children: <Widget>[
                                              BlocBuilder<SummaryRekapIzinBloc,
                                                  SummaryRekapIzinState>(
                                                builder: (context, state) {
                                                  if (state
                                                      is getSummaryRekapIzinSuccessState) {
                                                    return BlocBuilder<
                                                            MonthPickerRekapBloc,
                                                            MonthPickerRekapState>(
                                                        builder:
                                                            (context, mps) {
                                                      return templateKehadiran(
                                                          snapshot
                                                              .data!
                                                              .menuRekap!
                                                              .rekapAbsensi!
                                                              .data!
                                                              .izin!,
                                                          "${state.data!.izin} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.hari}",
                                                          1.0,
                                                          state.data!.izin ==
                                                                  '0'
                                                              ? CustomStyle
                                                                  .fontColorBlack
                                                              : Colors
                                                                  .orangeAccent,
                                                          valueFontSize: CustomStyle
                                                                  .fontSizeSmall -
                                                              1,
                                                          lineIndicator: true,
                                                          action: true,
                                                          onClick: () {
                                                        BlocProvider.of<
                                                                    NavigatorBloc>(
                                                                context)
                                                            .add(
                                                                NavigateToHalamanListMonitorIzin(
                                                                    context, [
                                                          'I',
                                                          mps.dateTime
                                                        ]));
                                                      });
                                                    });
                                                  } else {
                                                    return templateShimmerDashboard();
                                                  }
                                                },
                                              ),
                                              VerticalDividerAbsenku(),
                                              BlocBuilder<SummaryRekapCutiBloc,
                                                  SummaryRekapCutiState>(
                                                builder: (context, state) {
                                                  if (state
                                                      is getSummaryRekapCutiSuccessState) {
                                                    return BlocBuilder<
                                                            MonthPickerRekapBloc,
                                                            MonthPickerRekapState>(
                                                        builder:
                                                            (context, mps) {
                                                      return templateKehadiran(
                                                          snapshot
                                                              .data!
                                                              .menuRekap!
                                                              .rekapAbsensi!
                                                              .data!
                                                              .cuti!,
                                                          "${state.data!.cuti} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.hari}",
                                                          1.0,
                                                          state.data!.cuti ==
                                                                  '0'
                                                              ? CustomStyle
                                                                  .fontColorBlack
                                                              : Colors
                                                                  .orangeAccent,
                                                          valueFontSize: CustomStyle
                                                                  .fontSizeSmall -
                                                              1,
                                                          lineIndicator: true,
                                                          action: true,
                                                          onClick: () {
                                                        BlocProvider.of<
                                                                    NavigatorBloc>(
                                                                context)
                                                            .add(
                                                                NavigateToHalamanListMonitorIzin(
                                                                    context, [
                                                          'C',
                                                          mps.dateTime
                                                        ]));
                                                      });
                                                    });
                                                  } else {
                                                    return templateShimmerDashboard();
                                                  }
                                                },
                                              ),
                                            ],
                                          ),
                                          SizedBox(
                                            height: 2,
                                          ),
                                          Divider(
                                            thickness: 1,
                                          ),
                                          SizedBox(
                                            height: 2,
                                          ),
                                          Row(
                                            children: <Widget>[
                                              BlocBuilder<
                                                  SummaryRekapLemburBloc,
                                                  SummaryRekapLemburState>(
                                                builder: (context, state) {
                                                  if (state
                                                      is getSummaryRekapLemburSuccessState) {
                                                    return BlocBuilder<
                                                            MonthPickerRekapBloc,
                                                            MonthPickerRekapState>(
                                                        builder:
                                                            (context, mps) {
                                                      return templateKehadiran(
                                                          snapshot
                                                              .data!
                                                              .menuRekap!
                                                              .rekapAbsensi!
                                                              .data!
                                                              .lembur!,
                                                          "${state.data!.lembur} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.kali} (${state.data!.menitLembur} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.menit})",
                                                          1.0,
                                                          state.data!.lembur ==
                                                                  '0'
                                                              ? CustomStyle
                                                                  .fontColorBlack
                                                              : CustomStyle
                                                                  .color1,
                                                          valueFontSize: CustomStyle
                                                                  .fontSizeSmall -
                                                              1,
                                                          lineIndicator: true,
                                                          action: true,
                                                          onClick: () {
                                                        BlocProvider.of<
                                                                    NavigatorBloc>(
                                                                context)
                                                            .add(
                                                            NavigateToHalamanListMonitorLembur(
                                                                    context, [
                                                          mps.dateTime
                                                        ]));
                                                      });
                                                    });
                                                  } else {
                                                    return templateShimmerDashboard();
                                                  }
                                                },
                                              ),
                                              VerticalDividerAbsenku(),
                                              BlocBuilder<
                                                  SummaryRekapTerlambatBloc,
                                                  SummaryRekapTerlambatState>(
                                                builder: (context, state) {
                                                  if (state
                                                      is getSummaryRekapTerlambatSuccessState) {
                                                    return BlocBuilder<
                                                            MonthPickerRekapBloc,
                                                            MonthPickerRekapState>(
                                                        builder:
                                                            (context, mps) {
                                                      return templateKehadiran(
                                                        snapshot
                                                            .data!
                                                            .menuRekap!
                                                            .rekapAbsensi!
                                                            .data!
                                                            .terlambat!,
                                                        "${state.data!.terlambat} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.kali} (${state.data!.menitTerlambat} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.menit})",
                                                        1.0,
                                                        state.data!.terlambat ==
                                                                '0'
                                                            ? CustomStyle
                                                                .fontColorBlack
                                                            : Colors.redAccent,
                                                        valueFontSize: CustomStyle
                                                                .fontSizeSmall -
                                                            1,
                                                        lineIndicator: true,
                                                        action: true,
                                                        onClick: () {
                                                          BlocProvider.of<
                                                                      NavigatorBloc>(
                                                                  context)
                                                              .add(
                                                                  NavigateToHalamanListMonitor(
                                                                      context, [
                                                            'T',
                                                            mps.dateTime
                                                          ]));
                                                        },
                                                      );
                                                    });
                                                  } else {
                                                    return templateShimmerDashboard();
                                                  }
                                                },
                                              ),
                                            ],
                                          ),
                                          SizedBox(
                                            height: 2,
                                          ),
                                          Divider(
                                            thickness: 1,
                                          ),
                                          SizedBox(
                                            height: 2,
                                          ),
                                          Row(
                                            children: <Widget>[
                                              BlocBuilder<
                                                  SummaryRekapPulangCepatBloc,
                                                  SummaryRekapPulangCepatState>(
                                                builder: (context, state) {
                                                  if (state
                                                      is getSummaryRekapPulangCepatSuccessState) {
                                                    return BlocBuilder<
                                                            MonthPickerRekapBloc,
                                                            MonthPickerRekapState>(
                                                        builder:
                                                            (context, mps) {
                                                      return templateKehadiran(
                                                        snapshot
                                                            .data!
                                                            .menuRekap!
                                                            .rekapAbsensi!
                                                            .data!
                                                            .pulangCepat!,
                                                        "${state.data!.pulangCepat} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.kali} (${state.data!.menitPulangCepat} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.menit})",
                                                        1.0,
                                                        state.data!.pulangCepat ==
                                                                '0'
                                                            ? CustomStyle
                                                                .fontColorBlack
                                                            : Colors.redAccent,
                                                        valueFontSize: CustomStyle
                                                                .fontSizeSmall -
                                                            1,
                                                        lineIndicator: true,
                                                        action: true,
                                                        onClick: () {
                                                          BlocProvider.of<
                                                                      NavigatorBloc>(
                                                                  context)
                                                              .add(
                                                                  NavigateToHalamanListMonitor(
                                                                      context, [
                                                            'PC',
                                                            mps.dateTime
                                                          ]));
                                                        },
                                                      );
                                                    });
                                                  } else {
                                                    return templateShimmerDashboard();
                                                  }
                                                },
                                              ),
                                              VerticalDividerAbsenku(),
                                              BlocBuilder<SummaryRekapTAPBloc,
                                                  SummaryRekapTAPState>(
                                                builder: (context, state) {
                                                  if (state
                                                      is getSummaryRekapTAPSuccessState) {
                                                    return BlocBuilder<
                                                            MonthPickerRekapBloc,
                                                            MonthPickerRekapState>(
                                                        builder:
                                                            (context, mps) {
                                                      return templateKehadiran(
                                                          snapshot
                                                              .data!
                                                              .menuRekap!
                                                              .rekapAbsensi!
                                                              .data!
                                                              .tidakAbsenPulang!,
                                                          "${state.data!.tidakAbsenPulang} ${snapshot.data!.menuRekap!.rekapAbsensi!.data!.kali}",
                                                          1.0,
                                                          state.data!.tidakAbsenPulang ==
                                                                  '0'
                                                              ? CustomStyle
                                                                  .fontColorBlack
                                                              : Colors
                                                                  .redAccent,
                                                          valueFontSize: CustomStyle
                                                                  .fontSizeSmall -
                                                              1,
                                                          lineIndicator: true,
                                                          action: true,
                                                          onClick: () {
                                                        BlocProvider.of<
                                                                    NavigatorBloc>(
                                                                context)
                                                            .add(
                                                                NavigateToHalamanListMonitor(
                                                                    context, [
                                                          'TAP',
                                                          mps.dateTime
                                                        ]));
                                                      });
                                                    });
                                                  } else {
                                                    return templateShimmerDashboard();
                                                  }
                                                },
                                              ),
                                            ],
                                          )
                                        ],
                                      ))),
                              SizedBox(
                                height: 20,
                              ),
                              TemplateMenu(
                                icon: ValueImage.iconAbsensi,
                                title: snapshot
                                    .data!.menuRekap!.menu!.dataAbsen!.title!,
                                subtitle: snapshot.data!.menuRekap!.menu!
                                    .dataAbsen!.subtitle!,
                                onClick: () =>
                                    BlocProvider.of<NavigatorBloc>(context).add(
                                        NavigateToListRekapAbsensi(context)),
                              ),
                              BlocBuilder<AuthBloc, LoginRespon>(builder:
                                  (BuildContext context,
                                      LoginRespon loginRespon) {
                                return loginRespon.dataLogin!.level != 3
                                    ? TemplateMenu(
                                        icon: ValueImage.iconLembur,
                                        title: snapshot.data!.menuRekap!.menu!
                                            .rekapAbsen!.title!,
                                        subtitle: snapshot.data!.menuRekap!
                                            .menu!.rekapAbsen!.subtitle!,
                                        onClick: () =>
                                            BlocProvider.of<NavigatorBloc>(
                                                    context)
                                                .add(NavigateToRekapKaryawan(
                                                    context)),
                                      )
                                    : Container();
                              }),
                              TemplateMenu(
                                icon: ValueImage.iconIzin,
                                title: snapshot
                                    .data!.menuRekap!.menu!.dataIzin!.title!,
                                subtitle: snapshot
                                    .data!.menuRekap!.menu!.dataIzin!.subtitle!,
                                onClick: () =>
                                    BlocProvider.of<NavigatorBloc>(context)
                                        .add(NavigateToListRekapIzin(context)),
                              ),
                              TemplateMenu(
                                icon: ValueImage.iconLembur,
                                title: snapshot
                                    .data!.menuRekap!.menu!.dataLembur!.title!,
                                subtitle: snapshot.data!.menuRekap!.menu!
                                    .dataLembur!.subtitle!,
                                onClick: () =>
                                    BlocProvider.of<NavigatorBloc>(context).add(
                                        NavigateToListRekapLembur(context)),
                              ),
                              SizedBox(
                                height: 50,
                              ),
                            ],
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            );
          } else {
            return CircularProgressIndicator(strokeWidth: 8);
          }
        });
  }
}
