import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/CardItemBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementDetailBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementItemBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mReimbursementPage.dart';
import 'package:absenkuv3/Repository/Model/mReimbursement.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateForm.dart';
import 'package:absenkuv3/UI/Template/templateTextFieldForm.dart';
import 'package:cached_network_image/cached_network_image.dart';
import 'package:extended_masked_text/extended_masked_text.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'dart:io';

class CardReimbursement extends StatelessWidget {
  final DataReimbursement dataReimbursement;
  final String konteks;
  final PageReimbursementModel redaksional;
  CardReimbursement(this.dataReimbursement, this.konteks, this.redaksional);
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
          NavigateToDetailReimbursement(
              context, [dataReimbursement.idPengajuan, konteks])),
      child: Container(
        decoration: CustomStyle.boxDecoration,
        margin: EdgeInsets.fromLTRB(10, 12, 10, 0),
        padding: EdgeInsets.fromLTRB(16, 14, 16, 14),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            konteks == 'reimbursementKaryawan'
                ? Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            dataReimbursement.namaKaryawan!,
                            style: TextStyle(
                                fontWeight: FontWeight.w700,
                                color: CustomStyle.fontColorBlack,
                                fontSize: CustomStyle.fontSizeSmall + 1),
                          ),
                          SizedBox(
                            height: 6,
                          ),
                          Wrap(
                            spacing: 4,
                            runSpacing: 3,
                            children: [
                              TemplateButton(
                                label: dataReimbursement.namaCabang,
                                color: Colors.grey[300],
                                paddingTopBottom: 0,
                                heightButton: 20,
                                paddingLeftRight: 12,
                                radius: 8,
                                fontSize: 11,
                                contentColor: CustomStyle.fontColorBlack,
                              ),
                              TemplateButton(
                                label: dataReimbursement.namaDepartemen,
                                color: Colors.grey[300],
                                paddingTopBottom: 0,
                                heightButton: 20,
                                paddingLeftRight: 12,
                                radius: 8,
                                fontSize: 11,
                                contentColor: CustomStyle.fontColorBlack,
                              ),
                            ],
                          ),
                        ],
                      ),
                      SizedBox(
                        height: 3,
                      ),
                      Divider(
                        thickness: 1,
                      ),
                      SizedBox(
                        height: 1,
                      ),
                    ],
                  )
                : Container(),
            Row(
              mainAxisAlignment: MainAxisAlignment.spaceBetween,
              children: [
                Text(
                  dataReimbursement.noPengajuan!,
                  style: TextStyle(
                      fontSize: CustomStyle.fontSizeSmall,
                      fontWeight: FontWeight.w700,
                      color: CustomStyle.fontColorBlack),
                ),
                Row(
                  children: [
                    Icon(
                      Icons.calendar_today_rounded,
                      color: CustomStyle.fontColorGrey,
                      size: 20,
                    ),
                    SizedBox(
                      width: 4,
                    ),
                    Text(
                      dataReimbursement.tglPengajuan!,
                      style: TextStyle(
                          fontSize: CustomStyle.fontSizeSmall - 1,
                          color: CustomStyle.fontColorBlack),
                    ),
                  ],
                ),
              ],
            ),
            SizedBox(
              height: 6,
            ),
            Row(
              children: [
                Expanded(
                    child: Text(
                  dataReimbursement.keterangan ?? '',
                  style: TextStyle(
                      fontSize: CustomStyle.fontSizeSmall,
                      fontWeight: FontWeight.w400,
                      color: CustomStyle.fontColorGrey),
                )),
                Text(
                  "${dataReimbursement.jmlPengajuan} ${redaksional.menuReimbursement!.data!.item}",
                  style: TextStyle(
                      fontSize: CustomStyle.fontSizeSmall - 1,
                      fontWeight: FontWeight.w700,
                      color: CustomStyle.color1),
                ),
              ],
            ),
            SizedBox(
              height: 6,
            ),
            Row(
              children: [
                Expanded(
                    child: Text(
                  CurrencyFormatter.IDR(
                      int.parse(dataReimbursement.totalPengajuan!)),
                  style: TextStyle(
                      fontSize: CustomStyle.fontSizeSubTitle,
                      fontWeight: FontWeight.w700,
                      color: CustomStyle.colorLightOrange),
                )),
                dataReimbursement.totalPengajuanDisetujui != '0'
                    ? Column(
                        children: [
                          SizedBox(
                            height: 4,
                          ),
                          Row(
                            children: [
                              Text(
                                CurrencyFormatter.IDR(int.parse(
                                    dataReimbursement
                                        .totalPengajuanDisetujui!)),
                                style: TextStyle(
                                    fontSize: CustomStyle.fontSizeSubTitle,
                                    fontWeight: FontWeight.w700,
                                    color: CustomStyle.colorGreen),
                              ),
                              SizedBox(
                                width: 4,
                              ),
                              Icon(
                                Icons.check_circle,
                                color: CustomStyle.colorGreen,
                                size: 18,
                              ),
                            ],
                          ),
                        ],
                      )
                    : Container(),
              ],
            ),
            SizedBox(
              height: 5,
            ),
            Divider(
              thickness: 1,
            ),
            SizedBox(
              height: 2,
            ),
            Wrap(
              spacing: 8,
              runSpacing: 4,
              children: dataReimbursement.listApproval!
                  .map(
                    (item) => TemplateButton(
                      label: item.statusApproval,
                      color: Color(int.parse(item.warnaStatus!)),
                      heightButton: 24,
                      radius: 4,
                      paddingTopBottom: 0,
                      contentColor: Color(int.parse(item.warnaFont!)),
                      bold: true,
                    ),
                  )
                  .toList(),
            )
          ],
        ),
      ),
    );
  }
}

class TombolPengajuanReimbursement extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () => BlocProvider.of<NavigatorBloc>(context)
          .add(NavigateToPengajuanReimbursement(context)),
      child: Container(
        margin: EdgeInsets.fromLTRB(10, 12, 10, 0),
        padding: EdgeInsets.fromLTRB(10, 12, 10, 12),
        decoration: CustomStyle.boxDecoration,
        child: Row(
          children: [
            Image.asset(
              ValueImage.iconPengajuanReimbursement,
              height: 64,
            ),
            SizedBox(
              width: 10,
            ),
            Expanded(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    "Pengajuan Reimbursement",
                    style: TextStyle(
                        fontSize: CustomStyle.fontSizeNormal,
                        fontWeight: FontWeight.w700,
                        color: CustomStyle.fontColorBlack),
                  ),
                  SizedBox(
                    height: 4,
                  ),
                  Text(
                    "Fitur untuk melakukan pengajuan reimbursement",
                    style: TextStyle(
                        fontSize: CustomStyle.fontSizeSmall - 1,
                        color: CustomStyle.fontColorGrey),
                  ),
                ],
              ),
            ),
            SizedBox(
              width: 10,
            ),
            Icon(
              Icons.chevron_right,
              color: CustomStyle.fontColorGrey,
              size: 32,
            )
          ],
        ),
      ),
    );
  }
}

class CardItemReimbursement extends StatelessWidget {
  final DataItem dataItem;
  final String? idPengajuan;
  final PageReimbursementModel redaksional;

  CardItemReimbursement(this.dataItem, this.idPengajuan, this.redaksional);

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: CustomStyle.boxDecoration,
      margin: EdgeInsets.fromLTRB(10, 12, 10, 0),
      padding: EdgeInsets.fromLTRB(16, 14, 16, 14),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            children: [
              dataItem.file != '-' || dataItem.editedPhotoPath != null
                  ? GestureDetector(
                      onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
                          NavigateToDetailImageClicked(context, dataItem.file)),
                      child: dataItem.editedPhotoPath != null
                          ? Image.file(File(dataItem.editedPhotoPath!),
                              height: 72, width: 72)
                          : CachedNetworkImage(
                              imageUrl: dataItem.file!,
                              placeholder: (context, url) => Container(
                                height: 12,
                                width: 12,
                                child: Center(
                                  child: CircularProgressIndicator(
                                    strokeWidth: 8,
                                  ),
                                ),
                              ),
                              errorWidget: (context, url, error) =>
                                  Icon(Icons.error),
                              height: 72,
                              width: 72,
                            ),
                    )
                  : Icon(Icons.image_not_supported,
                      color: Colors.grey[500], size: 72),
              SizedBox(
                width: 8,
              ),
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Row(
                      children: [
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(
                                redaksional.menuReimbursement!.data!.jenis!,
                                style: TextStyle(
                                    fontSize: CustomStyle.fontSizeSmall,
                                    color: CustomStyle.fontColorGrey),
                              ),
                              SizedBox(
                                height: 1,
                              ),
                              Text(
                                dataItem.jenis!,
                                style: TextStyle(
                                    fontSize: CustomStyle.fontSizeSmall,
                                    color: CustomStyle.fontColorBlack),
                              ),
                            ],
                          ),
                        ),
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(
                              redaksional.menuReimbursement!.data!.tanggalNote!,
                              style: TextStyle(
                                  fontSize: CustomStyle.fontSizeSmall,
                                  color: CustomStyle.fontColorGrey),
                            ),
                            SizedBox(
                              height: 1,
                            ),
                            Text(
                              dataItem.tglNota!,
                              style: TextStyle(
                                  fontSize: CustomStyle.fontSizeSmall - 1,
                                  color: CustomStyle.fontColorBlack),
                            ),
                          ],
                        ),
                        SizedBox(
                          width: 8,
                        ),
                        dataItem.aksi!
                            ? PopupMenuButton<String>(
                                onSelected: (value) =>
                                    doAction(context, value, dataItem.idItem),
                                itemBuilder: (BuildContext context) {
                                  return actionMenu();
                                },
                                child: Icon(
                                  Icons.more_vert_sharp,
                                  color: CustomStyle.fontColorGrey,
                                ),
                              )
                            : Container()
                      ],
                    ),
                    SizedBox(
                      height: 4,
                    ),
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          redaksional.menuReimbursement!.data!.keterangan!,
                          style: TextStyle(
                              fontSize: CustomStyle.fontSizeSmall,
                              color: CustomStyle.fontColorGrey),
                        ),
                        SizedBox(
                          height: 1,
                        ),
                        Text(
                          dataItem.keterangan!,
                          style: TextStyle(
                              fontSize: CustomStyle.fontSizeSmall,
                              color: CustomStyle.fontColorBlack),
                        ),
                      ],
                    ),
                    SizedBox(
                      height: 8,
                    ),
                    Wrap(
                      spacing: 8,
                      runSpacing: 4,
                      children: dataItem.listApproval!
                          .map(
                            (item) => TemplateButton(
                              onClick: () => item.iconInfo!
                                  ? openDialog(context, item.title, "Info",
                                      dataItem.idItem, item.idStatus,
                                      informasiKeterangan:
                                          item.informasiKeterangan)
                                  : null,
                              icon: item.iconInfo! ? Icons.info : null,
                              label: item.statusApproval,
                              color: Color(int.parse(item.warnaStatus!)),
                              heightButton: 24,
                              radius: 4,
                              paddingTopBottom: 0,
                              contentColor: Color(int.parse(item.warnaFont!)),
                              bold: true,
                            ),
                          )
                          .toList(),
                    )
                  ],
                ),
              )
            ],
          ),
          SizedBox(
            height: 2,
          ),
          Divider(
            thickness: 1,
          ),
          SizedBox(
            height: 2,
          ),
          Row(
            children: [
              Expanded(
                  flex: 3,
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        CurrencyFormatter.IDR(dataItem.nominal),
                        style: TextStyle(
                            fontSize: CustomStyle.fontSizeSmall + 1,
                            fontWeight: FontWeight.w700,
                            color: CustomStyle.colorLightOrange),
                      ),
                      dataItem.nominalDisetujui != 0
                          ? Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                SizedBox(
                                  height: 4,
                                ),
                                Row(
                                  children: [
                                    Text(
                                      CurrencyFormatter.IDR(
                                          dataItem.nominalDisetujui),
                                      style: TextStyle(
                                          fontSize:
                                              CustomStyle.fontSizeSmall + 1,
                                          fontWeight: FontWeight.w700,
                                          color: CustomStyle.colorGreen),
                                    ),
                                    SizedBox(
                                      width: 4,
                                    ),
                                    Icon(
                                      Icons.check_circle,
                                      color: CustomStyle.colorGreen,
                                      size: 18,
                                    ),
                                  ],
                                ),
                              ],
                            )
                          : Container(),
                    ],
                  )),
              dataItem.aksi! || dataItem.tombolAksiRevisi!
                  ? BlocBuilder<CardItemReimbursementBloc, CardItemState>(
                      builder: (BuildContext context, CardItemState state) {
                      return ConstrainedBox(
                        constraints: BoxConstraints(maxWidth: 150),
                        child: TemplateButton(
                          label: state.status,
                          onClick: () {
                            if (dataItem.tombolAksiRevisi!)
                              BlocProvider.of<NavigatorBloc>(context).add(
                                  NavigateToTambahItemPengajuanReimbursement(
                                      context, dataItem));
                          },
                          color: Color(colorMapping(state.status)),
                          icon: dataItem.tombolAksiRevisi!
                              ? Icons.chevron_right
                              : null,
                          heightButton: 24,
                          expand: true,
                          radius: 8,
                          paddingTopBottom: 0,
                          contentColor: Color(int.parse('0XFFFFFFFF')),
                          bold: true,
                        ),
                      );
                    })
                  : Container(),
            ],
          )
        ],
      ),
    );
  }

  actionMenu() {
    List<String> buttonAksi;
    if (dataItem.aksi!)
      buttonAksi = [redaksional.menuReimbursement!.button!.btnSetujui!, redaksional.menuReimbursement!.button!.btnTolak!, redaksional.menuReimbursement!.button!.btnRevisi!];
    else
      buttonAksi = ['Detail'];
    return buttonAksi.map((String choice) {
      return PopupMenuItem<String>(
        value: choice,
        child: Text(choice),
      );
    }).toList();
  }

  void doAction(BuildContext context, String value, String? id) async {
    if (value == redaksional.menuReimbursement!.button!.btnBatalkan)
      BlocProvider.of<CardItemReimbursementBloc>(context)
          .add(GantiStatusEvent(context, redaksional.menuReimbursement!.data!.dibatalkan!));
    else if (value == redaksional.menuReimbursement!.button!.btnSetujui) {
      LoginRespon data = await sharedPreferences().getUserData();
      openDialog(context, '${redaksional.menuReimbursement!.data!.catatan} ${redaksional.menuReimbursement!.data!.setujui}', redaksional.menuReimbursement!.data!.setujui!, id, '5',
          levelUser: data.dataLogin!.level!);
      // if(data.dataLogin!.level==6){//FINANCE BISA UBAH NOMINAL
      //   openDialog(context, '', "Disetujui", id, '5');
      // }
      // else {
      //   BlocProvider.of<CardItemReimbursementBloc>(context)
      //       .add(GantiStatusEvent(context, value));
      //   BlocProvider.of<ReimbursementDetailBloc>(context).add(ApprovalReimbursementEvent(ApprovalReimbursementModel(id, '5', nominal: '0')));
      // }
    } else if (value == redaksional.menuReimbursement!.button!.btnTolak)
      openDialog(context, '${redaksional.menuReimbursement!.data!.catatan} ${redaksional.menuReimbursement!.data!.ditolak}', redaksional.menuReimbursement!.data!.ditolak!, id, '3');
    else if (value == redaksional.menuReimbursement!.button!.btnRevisi)
      openDialog(context, '${redaksional.menuReimbursement!.data!.catatan} ${redaksional.menuReimbursement!.data!.direvisi}', redaksional.menuReimbursement!.data!.direvisi!, id, '4');
    else if (value == 'Detail') debugPrint('detail');
  }

  void openDialog(BuildContext _context, String? title, String value,
      String? id, String? status,
      {String? informasiKeterangan, int levelUser = 0}) {
    TextEditingController keterangan = new TextEditingController();
    if (informasiKeterangan != null) keterangan.text = informasiKeterangan;
    TextEditingController nominal = MoneyMaskedTextController(
        thousandSeparator: '.',
        leftSymbol: '${redaksional.menuReimbursement!.data!.idr} ',
        precision: 0,
        decimalSeparator: '');
    if (status == '5') nominal.text = dataItem.nominal.toString();

    showDialog(
        context: _context,
        builder: (BuildContext context) {
          return AlertDialog(
            shape: RoundedRectangleBorder(
                borderRadius:
                    BorderRadius.all(Radius.circular(CustomStyle.boxRadius))),
            content: Column(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                title != ''
                    ? Column(
                        children: [
                          Center(
                            child: Text(
                              title!,
                              style: TextStyle(
                                  fontSize: CustomStyle.fontSizeNormal,
                                  fontWeight: FontWeight.w600),
                            ),
                          ),
                          SizedBox(
                            height: 14,
                          ),
                        ],
                      )
                    : Container(
                        height: 6,
                      ),
                (status == '5' && levelUser == 6)
                    ? Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Container(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Text(
                                  redaksional.menuReimbursement!.data!.nominalPlafon!,
                                  style: TextStyle(
                                      color: CustomStyle.fontColorGrey,
                                      fontWeight: FontWeight.bold,
                                      fontSize: 14),
                                ),
                                SizedBox(
                                  height: 7,
                                ),
                                TemplateButton(
                                  label: CurrencyFormatter.IDR(
                                      dataItem.maxNominalPlafon),
                                  color: CustomStyle.colorLightOrange,
                                  expand: true,
                                  bold: true,
                                ),
                                SizedBox(
                                  height: 12,
                                ),
                              ],
                            ),
                          ),
                          Container(
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Text(
                                  redaksional.menuReimbursement!.data!.nominalPengajuan!,
                                  style: TextStyle(
                                      color: CustomStyle.fontColorGrey,
                                      fontWeight: FontWeight.bold,
                                      fontSize: 14),
                                ),
                                SizedBox(
                                  height: 7,
                                ),
                                TemplateButton(
                                  label:
                                      CurrencyFormatter.IDR(dataItem.nominal),
                                  color: Colors.grey[500],
                                  expand: true,
                                  bold: true,
                                ),
                                SizedBox(
                                  height: 12,
                                ),
                              ],
                            ),
                          ),
                          dataItem.nominalDisetujui != 0
                              ? Container(
                                  child: Column(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Text(
                                        redaksional.menuReimbursement!.data!.nominalDisetujui!,
                                        style: TextStyle(
                                            color: CustomStyle.fontColorGrey,
                                            fontWeight: FontWeight.bold,
                                            fontSize: 14),
                                      ),
                                      SizedBox(
                                        height: 7,
                                      ),
                                      TemplateButton(
                                        label: CurrencyFormatter.IDR(
                                            dataItem.nominalDisetujui),
                                        color: Color(0XFF74C077),
                                        expand: true,
                                        bold: true,
                                      ),
                                      SizedBox(
                                        height: 12,
                                      ),
                                    ],
                                  ),
                                )
                              : Container(),
                          value == 'Info'
                              ? Container()
                              : TemplateForm(
                                  formHeight: 56,
                                  adaValidasi: true,
                                  controller: nominal,
                                  color: Colors.grey[600],
                                  titleText: redaksional.menuReimbursement!.data!.nominalDisetujui,
                                  radius: CustomStyle.formRadius,
                                  hintText: redaksional.menuReimbursement!.data!.nominalDisetujui,
                                  keyboardNumber: true,
                                  numberOnly: true,
                                )
                        ],
                      )
                    : Container(),
                (status == '3' || status == '4' || status == '5') &&
                        value != 'Info' &&
                        levelUser != 6
                    ? TemplateTextFieldForm(
                        // formHeight: 56,
                        adaValidasi: true,
                        minLine: 3,
                        maxLine: 3,
                        controller: keterangan,
                        color: Colors.grey[600],
                        radius: CustomStyle.formRadius,
                        hintText: status == '5'
                            ? redaksional.menuReimbursement!.data!.catatanUntukAtasan
                            : redaksional.menuReimbursement!.data!.keterangan,
                      )
                    : (status == '3' || status == '4' || status == '5') &&
                            value == 'Info'
                        ? Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(
                                keterangan.text,
                                style: TextStyle(
                                    fontSize: CustomStyle.fontSizeNormal,
                                    color: CustomStyle.fontColorBlack),
                              ),
                            ],
                          )
                        : Container(),
                value == 'Info'
                    ? Align(
                        alignment: Alignment.centerRight,
                        child: TemplateButton(
                          onClick: () => BlocProvider.of<NavigatorBloc>(context)
                              .add(NavigatePop(context)),
                          label: redaksional.menuReimbursement!.button!.btnClose,
                          color: Colors.transparent,
                          contentColor: CustomStyle.color1,
                          fontSize: CustomStyle.fontSizeNormal,
                          bold: true,
                        ),
                      )
                    : Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          TemplateButton(
                            onClick: () =>
                                BlocProvider.of<NavigatorBloc>(context)
                                    .add(NavigatePop(context)),
                            label: redaksional.menuReimbursement!.button!.btnCancel,
                            color: Colors.transparent,
                            contentColor: CustomStyle.color1,
                            fontSize: CustomStyle.fontSizeNormal,
                            bold: true,
                          ),
                          TemplateButton(
                            onClick: () {
                              BlocProvider.of<CardItemReimbursementBloc>(
                                      _context)
                                  .add(GantiStatusEvent(_context, value));
                              BlocProvider.of<ReimbursementDetailBloc>(_context)
                                  .add(ApprovalReimbursementEvent(
                                      ApprovalReimbursementModel(id, status,
                                          nominal: nominal.text
                                              .replaceAll(RegExp('[^0-9]'), ''),
                                          keterangan: keterangan.text)));
                              BlocProvider.of<NavigatorBloc>(context)
                                  .add(NavigatePop(context));
                            },
                            label: redaksional.menuReimbursement!.button!.btnSubmit,
                            color: Colors.transparent,
                            contentColor: CustomStyle.color1,
                            fontSize: CustomStyle.fontSizeNormal,
                            bold: true,
                          )
                        ],
                      )
              ],
            ),
          );
        });
  }
}

class HeaderDetailReimbursement extends StatefulWidget {
  final DataReimbursement? dataReimbursement;
  HeaderDetailReimbursement(this.dataReimbursement);
  @override
  _HeaderDetailReimbursementState createState() =>
      _HeaderDetailReimbursementState();
}

class _HeaderDetailReimbursementState extends State<HeaderDetailReimbursement> {
  bool toggle = true;
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () {
        setState(() {
          toggle ? toggle = false : toggle = true;
        });
      },
      child: Container(
        decoration: BoxDecoration(
          boxShadow: [
            BoxShadow(
              color: Colors.grey.withOpacity(0.2),
              spreadRadius: 1.6,
              blurRadius: 4,
              offset: Offset(0, 1), // changes position of shadow
            ),
          ],
          color: Colors.white,
        ),
        padding: const EdgeInsets.fromLTRB(16, 18, 16, 16),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              children: [
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Text(
                        widget.dataReimbursement!.namaKaryawan!,
                        style: TextStyle(
                            fontWeight: FontWeight.w700,
                            color: CustomStyle.fontColorBlack,
                            fontSize: CustomStyle.fontSizeSmall + 1),
                      ),
                      SizedBox(
                        height: 6,
                      ),
                      Wrap(
                        spacing: 4,
                        runSpacing: 3,
                        children: [
                          TemplateButton(
                            label: widget.dataReimbursement!.namaCabang,
                            color: Colors.grey[300],
                            paddingTopBottom: 0,
                            heightButton: 20,
                            paddingLeftRight: 12,
                            radius: 8,
                            fontSize: 11,
                            contentColor: CustomStyle.fontColorBlack,
                          ),
                          TemplateButton(
                            label: widget.dataReimbursement!.namaDepartemen,
                            color: Colors.grey[300],
                            paddingTopBottom: 0,
                            heightButton: 20,
                            paddingLeftRight: 12,
                            radius: 8,
                            fontSize: 11,
                            contentColor: CustomStyle.fontColorBlack,
                          ),
                        ],
                      ),
                    ],
                  ),
                ),
                Icon(
                  toggle ? Icons.keyboard_arrow_up : Icons.keyboard_arrow_down,
                  color: CustomStyle.fontColorGrey,
                  size: 28,
                )
              ],
            ),
            toggle
                ? Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      SizedBox(
                        height: 3,
                      ),
                      Divider(
                        thickness: 1,
                      ),
                      SizedBox(
                        height: 1,
                      ),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text(
                            widget.dataReimbursement!.noPengajuan!,
                            style: TextStyle(
                                fontSize: CustomStyle.fontSizeSmall,
                                fontWeight: FontWeight.w700,
                                color: CustomStyle.fontColorBlack),
                          ),
                          Row(
                            children: [
                              Icon(
                                Icons.calendar_today_rounded,
                                color: CustomStyle.fontColorGrey,
                                size: 20,
                              ),
                              SizedBox(
                                width: 2,
                              ),
                              Text(
                                widget.dataReimbursement!.tglPengajuan!,
                                style: TextStyle(
                                    fontSize: CustomStyle.fontSizeSmall - 1,
                                    color: CustomStyle.fontColorBlack),
                              ),
                            ],
                          ),
                        ],
                      ),
                      SizedBox(
                        height: 6,
                      ),
                      Row(
                        children: [
                          Expanded(
                              child: Text(
                            CurrencyFormatter.IDR(int.parse(
                                widget.dataReimbursement!.totalPengajuan!)),
                            style: TextStyle(
                                fontSize: CustomStyle.fontSizeSubTitle,
                                fontWeight: FontWeight.w700,
                                color: CustomStyle.colorLightOrange),
                          )),
                          // Expanded(child: Text(widget.dataReimbursement!.keterangan!, style: TextStyle(fontSize: CustomStyle.fontSizeSubTitle, fontWeight: FontWeight.w700, color: CustomStyle.colorLightOrange),)),
                          // Expanded(child: Text("${widget.dataReimbursement!.keterangan}", style: TextStyle(fontSize: CustomStyle.fontSizeSmall-1, fontWeight: FontWeight.w500),)),
                          Text(
                            "${widget.dataReimbursement!.jmlPengajuan} Item",
                            style: TextStyle(
                                fontSize: CustomStyle.fontSizeSmall - 1,
                                fontWeight: FontWeight.w700,
                                color: CustomStyle.color1),
                          ),
                        ],
                      ),
                      SizedBox(height: 6),
                      Text(
                        "${widget.dataReimbursement!.keterangan}",
                        style: TextStyle(
                            fontSize: CustomStyle.fontSizeSmall - 1,
                            fontWeight: FontWeight.w500),
                      ),
                      // Text(CurrencyFormatter.IDR(int.parse(widget.dataReimbursement!.totalPengajuan!)), style: TextStyle(fontSize: CustomStyle.fontSizeSubTitle, fontWeight: FontWeight.w700, color: CustomStyle.colorLightOrange),),
                      widget.dataReimbursement!.totalPengajuanDisetujui != '0'
                          ? Column(
                              children: [
                                SizedBox(
                                  height: 4,
                                ),
                                Row(
                                  children: [
                                    Text(
                                      CurrencyFormatter.IDR(int.parse(widget
                                          .dataReimbursement!
                                          .totalPengajuanDisetujui!)),
                                      style: TextStyle(
                                          fontSize:
                                              CustomStyle.fontSizeSubTitle,
                                          fontWeight: FontWeight.w700,
                                          color: CustomStyle.colorGreen),
                                    ),
                                    SizedBox(
                                      width: 4,
                                    ),
                                    Icon(
                                      Icons.check_circle,
                                      color: CustomStyle.colorGreen,
                                      size: 18,
                                    ),
                                  ],
                                ),
                              ],
                            )
                          : Container(),
                      SizedBox(
                        height: 5,
                      ),
                      Divider(
                        thickness: 1,
                      ),
                      SizedBox(
                        height: 2,
                      ),
                      Wrap(
                        spacing: 8,
                        runSpacing: 4,
                        children: widget.dataReimbursement!.listApproval!
                            .map(
                              (item) => TemplateButton(
                                label: item.statusApproval,
                                color: Color(int.parse(item.warnaStatus!)),
                                heightButton: 24,
                                radius: 4,
                                paddingTopBottom: 0,
                                contentColor: Color(int.parse(item.warnaFont!)),
                                bold: true,
                              ),
                            )
                            .toList(),
                      )
                    ],
                  )
                : Container(),
          ],
        ),
      ),
    );
  }
}

// ignore: must_be_immutable
class CardItemReimbursementTemp extends StatelessWidget {
  ListItemTemp listItemTemp;
  final GlobalKey<ScaffoldState> scaffoldKey;
  final PageReimbursementModel redaksional;

  CardItemReimbursementTemp(this.scaffoldKey, this.listItemTemp, this.redaksional);

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: CustomStyle.boxDecoration,
      margin: EdgeInsets.fromLTRB(10, 12, 10, 0),
      padding: EdgeInsets.fromLTRB(16, 14, 16, 14),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Row(
            children: [
              listItemTemp.file != '-'
                  ? GestureDetector(
                      onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
                          NavigateToDetailImageClicked(
                              context, listItemTemp.file)),
                      child: Image.network(
                        listItemTemp.file!,
                        height: 72,
                        width: 72,
                      ),
                    )
                  : Icon(Icons.image_not_supported,
                      color: Colors.grey[500], size: 72),
              SizedBox(
                width: 8,
              ),
              Expanded(
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Row(
                      children: [
                        Expanded(
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(
                                redaksional.menuReimbursement!.data!.jenis!,
                                style: TextStyle(
                                    fontSize: CustomStyle.fontSizeSmall,
                                    color: CustomStyle.fontColorGrey),
                              ),
                              SizedBox(
                                height: 1,
                              ),
                              Text(
                                listItemTemp.jenisPlafon!,
                                style: TextStyle(
                                    fontSize: CustomStyle.fontSizeSmall,
                                    color: CustomStyle.fontColorBlack),
                              ),
                            ],
                          ),
                        ),
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(
                              redaksional.menuReimbursement!.data!.tanggalNote!,
                              style: TextStyle(
                                  fontSize: CustomStyle.fontSizeSmall,
                                  color: CustomStyle.fontColorGrey),
                            ),
                            SizedBox(
                              height: 1,
                            ),
                            Text(
                              listItemTemp.tglBukti!,
                              style: TextStyle(
                                  fontSize: CustomStyle.fontSizeSmall - 1,
                                  color: CustomStyle.fontColorBlack),
                            ),
                          ],
                        ),
                        SizedBox(
                          width: 6,
                        ),
                        PopupMenuButton<String>(
                          onSelected: (value) => doAction(context, value),
                          itemBuilder: (BuildContext context) {
                            return actionMenu();
                          },
                          child: Icon(
                            Icons.more_vert_sharp,
                            color: CustomStyle.fontColorGrey,
                          ),
                        )
                      ],
                    ),
                    SizedBox(
                      height: 4,
                    ),
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          redaksional.menuReimbursement!.data!.keterangan!,
                          style: TextStyle(
                              fontSize: CustomStyle.fontSizeSmall,
                              color: CustomStyle.fontColorGrey),
                        ),
                        SizedBox(
                          height: 1,
                        ),
                        Text(
                          listItemTemp.keterangan!,
                          style: TextStyle(
                              fontSize: CustomStyle.fontSizeSmall,
                              color: CustomStyle.fontColorBlack),
                        ),
                      ],
                    ),
                  ],
                ),
              )
            ],
          ),
          SizedBox(
            height: 2,
          ),
          Divider(
            thickness: 1,
          ),
          SizedBox(
            height: 2,
          ),
          Row(
            children: [
              Expanded(
                  child: Text(
                CurrencyFormatter.IDR(listItemTemp.nominal),
                style: TextStyle(
                    fontSize: CustomStyle.fontSizeNormal + 1,
                    fontWeight: FontWeight.w700,
                    color: CustomStyle.colorLightOrange),
              )),
            ],
          )
        ],
      ),
    );
  }

  actionMenu() {
    return {redaksional.menuReimbursement!.button!.btnEdit!, redaksional.menuReimbursement!.button!.btnHapus!}.map((String choice) {
      return PopupMenuItem<String>(
        value: choice,
        child: Text(choice),
      );
    }).toList();
  }

  void doAction(BuildContext context, String value) {
    if (value == redaksional.menuReimbursement!.button!.btnHapus)
      BlocProvider.of<ReimbursementItemBloc>(context).add(
          HapusReimbursementItemEvent(context, scaffoldKey, listItemTemp.id));
    else if (value == redaksional.menuReimbursement!.button!.btnEdit)
      BlocProvider.of<NavigatorBloc>(context)
          .add(NavigateToEditItemPengajuanReimbursement(context, listItemTemp));
  }
}

int colorMapping(namaStatus) {
  if (namaStatus == 'On Progress')
    return 0xff1575d6;
  else if (namaStatus == 'Disetujui')
    return 0XFF74C077;
  else if (namaStatus == 'Ditolak')
    return 0XFFFF6666;
  else if (namaStatus == 'Direvisi')
    return 0xffFCB544;
  else if (namaStatus == 'Dibatalkan')
    return 0XFFE0E0E0;
  else if (namaStatus == 'Lakukan Revisi')
    return 0XFFbe3ef0;
  else
    return 0xff23d59a;
}
