import 'package:absenkuv3/Bloc/FilterBottomSheetBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementKaryawanBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mReimbursementPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/FilterBottomSheet.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import 'komponenReimbursement.dart';

class HalamanReimbursementKaryawan extends StatefulWidget {
  @override
  _HalamanReimbursementKaryawanState createState() => _HalamanReimbursementKaryawanState();
}

class _HalamanReimbursementKaryawanState extends State<HalamanReimbursementKaryawan> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  ModelFilter? modelFilter;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    BlocProvider.of<ReimbursementKaryawanBloc>(context).add(GetListReimbursementEvent(context, modelFilter));
    _scrollController.addListener(()=>BlocProvider.of<ReimbursementKaryawanBloc>(context).add(LoadMoreEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageReimbursementModel>(
        future: PengaturanBahasa().reimbursement(),
        builder: (context, snapshot){
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
              body: Stack(
                children: [
                  BlocBuilder<ReimbursementKaryawanBloc, ReimbursementKaryawanState>(
                      builder: (BuildContext context, ReimbursementKaryawanState state){
                        if(state is GetListReimbursementSuccessState || state is LoadMoreProgressState)
                          return Stack(
                            children: <Widget>[
                              ListView.builder(
                                  physics: AlwaysScrollableScrollPhysics(),
                                  controller: _scrollController,
                                  itemCount: state.data!.length,
                                  itemBuilder: (BuildContext context, index) {
                                    return CardReimbursement(state.data![index], 'reimbursementKaryawan', snapshot.data!);
                                  }
                              ),
                              state is LoadMoreProgressState? Positioned(
                                  bottom :16,
                                  child: Container(
                                      width: MediaQuery.of(context).size.width,
                                      child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                            ],
                          );
                        else if(state is ReimbursementProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                        else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
                      }),
                  Positioned(
                    bottom: 16,
                    right: 14,
                    child: BlocListener<FilterBottomSheetBloc, FilterBottomSheetState>(
                        listener: (BuildContext context, FilterBottomSheetState state){
                          if(state is setFilterSuccess){
                            modelFilter = state.modelFilter;
                            BlocProvider.of<ReimbursementKaryawanBloc>(context).add(GetListReimbursementEvent(context, modelFilter));
                          }
                        },
                        child: FilterBottomSheet(adaFilterStatus: true,)
                    ),
                  )
                ],
              ),
            );
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );
  }
}
