import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Page/PageReimbursementBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/ReimbursementItemBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mReimbursementPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import '../../Template/templateForm.dart';
import 'komponenReimbursement.dart';

class HalamanPengajuanReimbursement extends StatefulWidget {
  @override
  _HalamanPengajuanReimbursementState createState() =>
      _HalamanPengajuanReimbursementState();
}

class _HalamanPengajuanReimbursementState
    extends State<HalamanPengajuanReimbursement> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<ReimbursementItemBloc>(context)
        .add(GetListReimbursementItemEvent(context));
    BlocProvider.of<PageReimbursementBloc>(context)
        .add(GetDataPageReimbursement(context));
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<PageReimbursementBloc, PageReimbursementState>(
        builder: (BuildContext context, PageReimbursementState snapshot) {
          if(snapshot is PageReimbursementGetSuccess){
            return Scaffold(
              key: scaffoldKey,
              body: WillPopScope(
                onWillPop: keluar,
                child: BlocBuilder<ReimbursementItemBloc, ReimbursementItemState>(
                    builder: (BuildContext context, ReimbursementItemState state) {
                      if (state is GetListReimbursementItemSuccessState ||
                          state is LoadMoreProgressState)
                        return Stack(
                          children: [
                            Stack(
                              children: <Widget>[
                                ListView.builder(
                                    physics: AlwaysScrollableScrollPhysics(),
                                    itemCount: state.data!.listItemTemp!.length,
                                    itemBuilder: (BuildContext context, index) {
                                      return CardItemReimbursementTemp(
                                          scaffoldKey, state.data!.listItemTemp![index], snapshot.pageReimbursementModel!);
                                    }),
                                state is LoadMoreProgressState
                                    ? Positioned(
                                    bottom: 16,
                                    child: Container(
                                        width: MediaQuery.of(context).size.width,
                                        child: Center(
                                            child: CircularProgressIndicator(
                                              strokeWidth: 8,
                                            ))))
                                    : Container(),
                              ],
                            ),
                            Positioned(
                              bottom: 0,
                              child: Container(
                                padding: EdgeInsets.fromLTRB(14, 18, 14, 12),
                                width: MediaQuery.of(context).size.width,
                                decoration: BoxDecoration(
                                    boxShadow: [
                                      BoxShadow(
                                        color: Colors.grey.withOpacity(0.2),
                                        spreadRadius: 1.6,
                                        blurRadius: 4,
                                        offset: Offset(0, 1), // changes position of shadow
                                      ),
                                    ],
                                    color: Colors.white,
                                    borderRadius: new BorderRadius.only(
                                      topLeft: Radius.circular(24),
                                      topRight: Radius.circular(24),
                                    )),
                                child: Column(
                                  children: [
                                    Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        Text(
                                          snapshot.pageReimbursementModel!.menuReimbursement!.data!.totalPengajuan!,
                                          style: TextStyle(
                                              fontSize: CustomStyle.fontSizeNormal,
                                              color: CustomStyle.fontColorBlack,
                                              fontWeight: FontWeight.w600),
                                        ),
                                        Expanded(
                                            child: Text(
                                              CurrencyFormatter.IDR(state.data!.totalPengajuan),
                                              style: TextStyle(
                                                  fontSize: CustomStyle.fontSizeTitle,
                                                  color: CustomStyle.fontColorBlack,
                                                  fontWeight: FontWeight.w700),
                                              textAlign: TextAlign.right,
                                            )),
                                      ],
                                    ),
                                    SizedBox(
                                      height: 12,
                                    ),
                                    Row(
                                      children: [
                                        // Expanded(
                                        //     child: TemplateButton(
                                        //   onClick: () =>
                                        //       BlocProvider.of<NavigatorBloc>(context)
                                        //           .add(NavigatePop(context)),
                                        //   label: "Kembali",
                                        //   color: Colors.grey[500],
                                        //   expand: true,
                                        //   icon: Icons.chevron_left,
                                        //   radius: 14,
                                        //   iconSize: 18,
                                        //   paddingTopBottom: 8,
                                        // )),
                                        // SizedBox(
                                        //   width: 6,
                                        // ),
                                        Expanded(
                                            child: TemplateButton(
                                              onClick: () => openDialog(context, snapshot.pageReimbursementModel!),
                                              label: snapshot.pageReimbursementModel!.menuReimbursement!.button!.btnAjukan,
                                              color: CustomStyle.color1,
                                              expand: true,
                                              icon: Icons.chevron_right,
                                              radius: 14,
                                              iconSize: 18,
                                              paddingTopBottom: 8,
                                            )),
                                      ],
                                    )
                                  ],
                                ),
                              ),
                            )
                          ],
                        );
                      else if (state is ReimbursementProgressState)
                        return Center(
                          child: CircularProgressIndicator(
                            strokeWidth: 8,
                          ),
                        );
                      else
                        return Center(
                          child: Image.asset(
                            ValueImage.noData,
                            height: 250,
                          ),
                        );
                    }),
              ),
            );
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );
    // return FutureBuilder<PageReimbursementModel>(
    //     future: PengaturanBahasa().reimbursement(),
    //     builder: (context, snapshot){
    //       if(snapshot.connectionState == ConnectionState.done){
    //         return
    //       }else{
    //         return CircularProgressIndicator(strokeWidth: 8);
    //       }
    //     }
    // );
  }

  openDialog(BuildContext _context, PageReimbursementModel redaksional) {
    final GlobalKey<FormState> formKey = GlobalKey<FormState>();
    TextEditingController keterangan = new TextEditingController();
    showDialog(
        context: _context,
        builder: (BuildContext context) {
          return AlertDialog(
            shape: RoundedRectangleBorder(
                borderRadius:
                    BorderRadius.all(Radius.circular(CustomStyle.boxRadius))),
            content: SingleChildScrollView(
              reverse: true,
              child: Column(
                children: <Widget>[
                  Form(
                    key: formKey,
                    child: TemplateForm(
                      contentPadding: EdgeInsets.fromLTRB(20.0, 12, 20.0, 12),
                      formHeight: 76,
                      adaValidasi: true,
                      minLine: 3,
                      maxLine: 3,
                      controller: keterangan,
                      color: Colors.grey[600],
                      titleText: redaksional.menuReimbursement!.data!.kegiatan,
                      titleText2: "*",
                      colorTitle2: Colors.red,
                      radius: CustomStyle.formRadius,
                      hintText: "",
                    ),
                  ),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      TemplateButton(
                        onClick: () => BlocProvider.of<NavigatorBloc>(context)
                            .add(NavigatePop(context)),
                        label: redaksional.menuReimbursement!.button!.btnCancel,
                        color: Colors.transparent,
                        contentColor: CustomStyle.color1,
                        fontSize: CustomStyle.fontSizeNormal,
                        bold: true,
                      ),
                      TemplateButton(
                        onClick: () {
                          BlocProvider.of<ReimbursementItemBloc>(_context).add(
                              PengajuanReimbursementEvent(_context, scaffoldKey,
                                  formKey, keterangan.text));
                        },
                        label: redaksional.menuReimbursement!.button!.btnSubmit,
                        color: Colors.transparent,
                        contentColor: CustomStyle.color1,
                        fontSize: CustomStyle.fontSizeNormal,
                        bold: true,
                      )
                    ],
                  )
                ],
              ),
            ),
          );
        });
  }

  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateRemoveToMainReimbursement(context));
    return false;
  }
}
