import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/RekapReimbursementKaryawanBloc.dart' as karyawan;
import 'package:absenkuv3/Bloc/Reimbursement/RekapReimbursementSayaBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mReimbursementPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'halamanRekapReimbursementKaryawan.dart';
import 'halamanRekapReimbursementSaya.dart';

class ParentTabRekapReimbursement extends StatefulWidget {
  @override
  _ParentTabRekapReimbursementState createState() =>
      _ParentTabRekapReimbursementState();
}

class _ParentTabRekapReimbursementState
    extends State<ParentTabRekapReimbursement> {
  int tabLength = 3;

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageReimbursementModel>(
        future: PengaturanBahasa().reimbursement(),
        builder: (context, snapshot){
          if(snapshot.connectionState == ConnectionState.done){
            return BlocBuilder<AuthBloc, LoginRespon>(
                builder: (BuildContext context, LoginRespon loginRespon) {
                  return DefaultTabController(
                      length: tabLength,
                      child: Scaffold(
                        appBar: AppBar(
                          centerTitle: true,
                          flexibleSpace: Image(
                            image: AssetImage(ValueImage.headerBiruDashboard),
                            fit: BoxFit.cover,
                          ),
                          backgroundColor: Colors.transparent,
                          title: Text(
                            snapshot.data!.menuReimbursement!.rekapTitle!,
                            style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                          ),
                          bottom: loginRespon.dataLogin!.level != 3
                              ? TabBar(
                            labelPadding: EdgeInsets.all(0),
                            indicatorSize: TabBarIndicatorSize.tab,
                            indicatorWeight: 4,
                            isScrollable: true,
                            tabs: [
                              Container(
                                width: MediaQuery.of(context).size.width / tabLength,
                                child: Tab(
                                  text: "${snapshot.data!.menuReimbursement!.tabDraf} ",
                                ),
                              ),
                              Container(
                                width: MediaQuery.of(context).size.width / tabLength,
                                child: Tab(
                                  text: "${snapshot.data!.menuReimbursement!.tabPengajuan}",
                                ),
                              ),
                              Container(
                                width: MediaQuery.of(context).size.width / tabLength,
                                child: Tab(
                                  text: "${snapshot.data!.menuReimbursement!.tabPengajuanKaryawan}",
                                ),
                              ),
                            ],
                          )
                              : null,
                        ),
                        body: TabBarView(
                          physics: NeverScrollableScrollPhysics(),
                          children: [
                            BlocProvider<RekapReimbursementSayaBloc>(
                              create: (BuildContext context) {
                                return RekapReimbursementSayaBloc(
                                    ReimbursementProgressState());
                              },
                              child: HalamanRekapReimbursementSaya(),
                            ),
                            BlocProvider<RekapReimbursementSayaBloc>(
                              create: (BuildContext context) {
                                return RekapReimbursementSayaBloc(
                                    ReimbursementProgressState());
                              },
                              child: HalamanRekapReimbursementSaya(),
                            ),
                            BlocProvider<karyawan.RekapReimbursementKaryawanBloc>(
                              create: (BuildContext context) {
                                return karyawan.RekapReimbursementKaryawanBloc(
                                    karyawan.ReimbursementProgressState());
                              },
                              child: HalamanRekapReimbursementKaryawan(),
                            ),
                          ],
                        ),
                      ));
                });
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );
  }
}
