import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Page/PageReimbursementBloc.dart';
import 'package:absenkuv3/Bloc/Reimbursement/CekakunReimbursementBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mReimbursementPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class ParentTabReimbursement extends StatefulWidget {
  @override
  _ParentTabReimbursementState createState() => _ParentTabReimbursementState();
}

class _ParentTabReimbursementState extends State<ParentTabReimbursement> {
  // int tabLength = 2;
  // List<Widget> listTab = [];

  // List<Widget> listTabView = [
  //   MultiBlocProvider(providers: [
  //     BlocProvider<ReimbursementSayaBloc>(
  //       create: (context) {
  //         return ReimbursementSayaBloc(ReimbursementProgressState());
  //       },
  //     ),
  //     BlocProvider<reimbursementItemBloc.ReimbursementItemBloc>(
  //       create: (context) {
  //         return reimbursementItemBloc.ReimbursementItemBloc(
  //             reimbursementItemBloc.ReimbursementProgressState());
  //       },
  //     ),
  //   ], child: HalamanPengajuanReimbursement()),
  //   BlocProvider<ReimbursementSayaBloc>(
  //     create: (BuildContext context) {
  //       return ReimbursementSayaBloc(ReimbursementProgressState());
  //     },
  //     child: HalamanReimbursementSaya(),
  //   )
  // ];

  @override
  void initState() {
    super.initState();

    BlocProvider.of<CekAkunReimbursementBloc>(context)
        .add(CekAkunAkunReimbursementEvent(context));
    BlocProvider.of<PageReimbursementBloc>(context)
        .add(GetDataPageReimbursement(context));
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<PageReimbursementBloc, PageReimbursementState>(
        builder: (BuildContext context, PageReimbursementState snapshot) {
          if(snapshot is PageReimbursementGetSuccess){
            return BlocBuilder<CekAkunReimbursementBloc, CekakunReimbursementState>(
                builder: (BuildContext context, CekakunReimbursementState state) {
                  if (state is LoadingCekAkunReimbursementState) {
                    return Scaffold(
                      appBar: AppBar(
                        centerTitle: true,
                        flexibleSpace: Image(
                          image: AssetImage(ValueImage.headerBiruDashboard),
                          fit: BoxFit.cover,
                        ),
                        backgroundColor: Colors.transparent,
                        title: Text(
                          snapshot.pageReimbursementModel!.menuReimbursement!.title!,
                          style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                        ),
                      ),
                      body: Container(
                        height: double.infinity,
                        width: double.infinity,
                        child: Center(
                            child: CircularProgressIndicator(
                              strokeWidth: 8,
                            )),
                      ),
                    );
                  } else if (state is CekAkunAkunReimbursementState) {
                    return DefaultTabController(
                        length: state.countTabView!,
                        child: Scaffold(
                          appBar: AppBar(
                              actions: [
                                GestureDetector(
                                  onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
                                      NavigateToTambahItemPengajuanReimbursement(
                                          context, null)),

                                  // BlocProvider.of<NavigatorBloc>(context)
                                  //     .add(NavigateToPengajuanReimbursement(context)),
                                  child: Container(
                                      margin: EdgeInsets.only(right: 14),
                                      child: Icon(
                                        Icons.add,
                                        size: 26,
                                      )),
                                ),
                              ],
                              centerTitle: true,
                              flexibleSpace: Image(
                                image: AssetImage(ValueImage.headerBiruDashboard),
                                fit: BoxFit.cover,
                              ),
                              backgroundColor: Colors.transparent,
                              title: Text(
                                snapshot.pageReimbursementModel!.menuReimbursement!.title!,
                                style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                              ),
                              bottom: TabBar(
                                labelPadding:
                                state.countTabView! < 4 ? EdgeInsets.all(0) : null,
                                indicatorSize: TabBarIndicatorSize.tab,
                                indicatorWeight: 4,
                                isScrollable: true,
                                tabs: state.listTab,
                              )),
                          body: WillPopScope(
                            onWillPop: keluar,
                            child: TabBarView(
                                physics: NeverScrollableScrollPhysics(),
                                children: state.listTabView),
                          ),
                        ));
                  } else {
                    return Container(
                      // height: double.infinity,
                      // width: double.infinity,
                      // child: Center(child: Text(snapshot.data!.menuReimbursement!.locale == 'id' ? "Data kosong" : "Empty Data")),
                    );
                  }
                });
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );

    //   FutureBuilder<PageReimbursementModel>(
    //     future: PengaturanBahasa().reimbursement(),
    //     builder: (context, s){
    //       if(snapshot.connectionState == ConnectionState.done){
    //         // BlocProvider.of<CekAkunReimbursementBloc>(context)
    //         //     .add(CekAkunAkunReimbursementEvent(context, snapshot.data));
    //         return
    //       }else{
    //         return CircularProgressIndicator(strokeWidth: 8);
    //       }
    //     }
    // );
  }

  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateRemoveToDashboard(context));
    return false;
  }
}
