import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Pkwt/DataCallbackPkwtBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mPkwtPage.dart';
import 'package:absenkuv3/Repository/Model/mPkwt.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/main.dart';
import 'package:dotted_border/dotted_border.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

typedef void DataCallbackCardPkwt(List val);

class CardPkwt extends StatefulWidget {
  DataPkwt dataPkwt;
  GlobalKey<ScaffoldState> scaffoldKey;
  DataCallbackCardPkwt? dataCallback;
  CardPkwt(this.dataPkwt, this.scaffoldKey, {this.dataCallback});
  @override
  State<CardPkwt> createState() => _CardPkwtState();
}

class _CardPkwtState extends State<CardPkwt> {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
        onTap: () {
          Navigator.pushNamed(context, '/detail_pkwt_saya', arguments: [
            widget.dataPkwt.idPkwt
          ]).then((value) => {
                widget.dataCallback!([value])
              });
        },
        child: Container(
          height: 70,
          decoration: BoxDecoration(
            color: Colors.grey,
            borderRadius:
                BorderRadius.all(Radius.circular(CustomStyle.cardRadius)),
          ),
          margin: EdgeInsets.only(top: 12, left: 12, right: 12),
          padding: EdgeInsets.only(left: 5),
          child: Container(
            decoration: CustomStyle.boxDecoration2,
            child: Center(
              child: Container(
                // height: 60,
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.start,
                  children: [
                    Container(
                        padding: EdgeInsets.only(left: 10, right: 15),
                        child: Image.asset(
                          ValueImage.iconDocPkwt,
                          width: 50,
                          height: 50,
                        )),
                    Container(
                      child: Row(
                        children: [
                          Container(
                            padding: EdgeInsets.only(left: 10),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                Text(
                                  widget.dataPkwt.noPkwt.toString(),
                                  style: TextStyle(fontWeight: FontWeight.bold),
                                ),
                                SizedBox(
                                  height: 2,
                                ),
                                Text(
                                  widget.dataPkwt.tglPkwt.toString(),
                                  style: TextStyle(color: Colors.grey),
                                ),
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),
                    Expanded(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.end,
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          Container(
                            margin: EdgeInsets.only(right: 10),
                            decoration: BoxDecoration(
                              color: Color(
                                  int.parse(widget.dataPkwt.warnaStatus!)),
                              borderRadius:
                                  BorderRadius.all(Radius.circular(3)),
                            ),
                            child: Padding(
                              padding: const EdgeInsets.all(
                                  8.0), // Sesuaikan dengan padding yang diinginkan
                              child: Text(widget.dataPkwt.status.toString(),
                                  style: TextStyle(
                                      color: Color(int.parse(
                                          widget.dataPkwt.warnaFont!)))
                                  // TextStyle(
                                  //     color: Color(
                                  //         int.parse(widget.dataPkwt.warnaFont!)),fontWeight: FontWeight.bold),
                                  ),
                            ),
                          )
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ),
        ));
  }
}

class VDivider extends StatelessWidget {
  const VDivider({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 60,
      // margin: EdgeInsets.symmetric(horizontal: 12),
      decoration: BoxDecoration(
        border: Border(
          right: BorderSide(
            color: Theme.of(context).dividerColor,
            width: 2,
          ),
        ),
      ),
    );
  }
}

class TemplateColumn extends StatelessWidget {
  String? title;
  String? value;

  TemplateColumn({super.key, this.title, this.value});

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          title!,
          style: TextStyle(
              fontSize: 12,
              fontWeight: FontWeight.w400,
              color: CustomStyle.fontColorGrey),
        ),
        SizedBox(
          height: 8,
        ),
        Text(
          value!,
          style: TextStyle(
              fontSize: 14,
              fontWeight: FontWeight.w600,
              color: CustomStyle.fontColorBlack),
        ),
      ],
    );
  }
}

class CustomDocPkwt extends StatelessWidget {
  String? nmKaryawan;
  String? tglPkwt;
  MenuPkwt? redaksional;
  BuildContext? context;
  void Function(BuildContext)? tapHandle;

  CustomDocPkwt({
    super.key,
    this.nmKaryawan,
    this.context,
    this.tglPkwt,
    this.redaksional,
    this.tapHandle,
  });

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
        onTap: () {
          _onTapHandle(context);
        },
        child:
            // Container(
            //   decoration: BoxDecoration(
            //     color: Colors.grey,
            //     borderRadius:
            //         BorderRadius.all(Radius.circular(CustomStyle.cardRadius)),
            //   ),
            //   margin: EdgeInsets.only(top: 12),
            //   padding: EdgeInsets.all(5), // Add padding to the whole container
            //   child: Container(
            //     decoration: CustomStyle.boxDecoration2,
            //     child: Row(
            //       crossAxisAlignment: CrossAxisAlignment.center,
            //       children: [
            //         Container(
            //           padding: EdgeInsets.all(5),
            //           child: Image.asset(
            //             ValueImage.iconDocPkwt,
            //             width: 50,
            //             height: 50,
            //           ),
            //         ),
            //         Expanded(
            //           child: Column(
            //             // crossAxisAlignment: CrossAxisAlignment.start,
            //             children: [
            //               Text(
            //                 'PERJANJIAN KERJA WAKTU TERTENTU',
            //                 style: TextStyle(fontWeight: FontWeight.bold),
            //               ),
            //             ],
            //           ),
            //         ),
            //         // Container(
            //         //   margin: EdgeInsets.only(right: 5),
            //         //   child: Image.asset(
            //         //     ValueImage.iconArrowIn,
            //         //     width: 30,
            //         //     height: 30,
            //         //     color: Colors.grey,
            //         //   ),
            //         // ),
            //       ],
            //     ),
            //   ),
            // ),
            Container(
          margin: EdgeInsets.only(top: 12),
          padding: EdgeInsets.all(3), // Add padding to the whole container
          child: DottedBorder(
            borderType: BorderType.RRect,
            radius: Radius.circular(CustomStyle.cardRadius),
            dashPattern: [6, 3], // Adjust dash length and spacing
            color: Colors.grey, // Border color
            strokeWidth: 1.5,
            child: Container(
              decoration: CustomStyle.boxDecoration2,
              padding: EdgeInsets.all(5),
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  Container(
                    padding: EdgeInsets.all(5),
                    child: Image.asset(
                      ValueImage.iconDocPkwt,
                      width: 50,
                      height: 50,
                    ),
                  ),
                  Expanded(
                    child: Column(
                      children: [
                        Text(
                          redaksional!.data!.docPkwtTitle.toString(),
                          style: TextStyle(fontWeight: FontWeight.bold),
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          ),
        ));
  }

  void _onTapHandle(BuildContext context) {
    tapHandle?.call(context);
  }
}

// class CustomDocPkwt extends StatelessWidget {
//   String? nmKaryawan;
//   String? tglPkwt;
//   BuildContext? context;
//   void Function(BuildContext)? tapHandle;

//   CustomDocPkwt(
//       {super.key, this.nmKaryawan, this.context, this.tglPkwt, this.tapHandle});

//   @override
//   Widget build(BuildContext context) {
//     return GestureDetector(
//         onTap: () {
//           _onTapHandle(context);
//         },
//         child: Container(
//             decoration: BoxDecoration(
//               color: Colors.grey,
//               borderRadius:
//                   BorderRadius.all(Radius.circular(CustomStyle.cardRadius)),
//             ),
//             margin: EdgeInsets.only(top: 12),
//             padding: EdgeInsets.only(left: 5),
//             child: Container(
//               decoration: CustomStyle.boxDecoration2,
//               child: Column(
//                 mainAxisAlignment: MainAxisAlignment.start,
//                 children: [
//                   SizedBox(
//                     height: 5,
//                   ),
//                   Container(
//                     padding: EdgeInsets.only(left: 5),
//                     child: Container(
//                       // decoration: CustomStyle.boxDecoration2,
//                       child: Row(
//                         mainAxisAlignment: MainAxisAlignment.start,
//                         children: [
//                           Container(
//                               padding: EdgeInsets.only(right: 5, left: 10),
//                               child: Image.asset(
//                                 ValueImage.iconDocPkwt,
//                                 width: 50,
//                                 height: 50,
//                               )),
//                           SizedBox(
//                             height: 65,
//                           ),
//                           Container(
//                             child: Column(
//                               crossAxisAlignment: CrossAxisAlignment.start,
//                               mainAxisAlignment: MainAxisAlignment.start,
//                               children: [
//                                 Text(
//                                   'PERJANJIAN KERJA WAKTU TERTENTU',
//                                   style: TextStyle(
//                                       fontWeight: FontWeight.bold),
//                                 ),
//                               ],
//                             ),
//                           ),
//                           Expanded(
//                             child: Column(
//                               crossAxisAlignment: CrossAxisAlignment.end,
//                               mainAxisAlignment: MainAxisAlignment.center,
//                               children: [
//                                 Container(
//                                   margin: EdgeInsets.only(right: 5),
//                                   child: Image.asset(
//                                     ValueImage.iconArrowIn,
//                                     width: 30,
//                                     height: 30,
//                                     color: Colors.grey,
//                                   ),
//                                 )
//                               ],
//                             ),
//                           ),
//                         ],
//                       ),
//                     ),
//                   ),
//                 ],
//               ),
//             )));
//   }

//   void _onTapHandle(BuildContext context) {
//     tapHandle?.call(context);
//   }
// }

class QuictypeCustomPkwt {
  String? message;
  bool doublePop;
  bool isDismissible;
  BuildContext? context;
  void Function()? closeCustom;

  QuictypeCustomPkwt.show(
    this.message,
    this.context, {
    this.doublePop = true,
    this.isDismissible = true,
    this.closeCustom,
  }) {
    print("context : $context");
    Future.delayed(Duration(milliseconds: 600)).then((value) {
      showDialog(
        context: context!,
        barrierDismissible: isDismissible,
        builder: (BuildContext context) {
          return WillPopScope(
            onWillPop: _onWillPop,
            child: AlertDialog(
              title: Text('PKWT'),
              content: Text(message!),
              actions: [
                TextButton(
                  onPressed: () {
                    Navigator.of(context).pop();
                  },
                  child: Text('TUTUP'),
                ),
              ],
            ),
          );
        },
      );
    });
  }

  Future<bool> _onWillPop() async {
    bool shouldPop = true;
    if (shouldPop) {
      BlocProvider.of<NavigatorBloc>(context!).add(NavigatePop(context));
      BlocProvider.of<NavigatorBloc>(context!).add(NavigatePop(context));
      BlocProvider.of<NavigatorBloc>(context!).add(NavigatePop(context));
      // BlocProvider.of<NavigatorBloc>(context!)
      // .add(NavigateToPkwtReplace(context!));
    }

    return shouldPop;
  }
}

class CustomDialogPkwt extends StatefulWidget {
  final String lottieAsset;
  final List<Widget> additionalWidgets;
  final Function()? onTap;

  const CustomDialogPkwt({
    Key? key,
    required this.lottieAsset,
    this.additionalWidgets = const [],
    this.onTap,
  }) : super(key: key);

  @override
  State<CustomDialogPkwt> createState() => _CustomDialogPkwtState();
}

class _CustomDialogPkwtState extends State<CustomDialogPkwt> {
  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      child: AlertDialog(
        backgroundColor: Colors.transparent,
        shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.circular(16.0),
        ),
        contentPadding: EdgeInsets.all(20.0),
        content: Container(
          width: MediaQuery.of(context).size.width * 2,
          decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(16.0),
            color: Colors.blue,
          ),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            crossAxisAlignment: CrossAxisAlignment.center,
            children: [
              // Lottie.asset(
              //   widget.lottieAsset,
              //   width: 150,
              //   height: 150,
              //   fit: BoxFit.fill,
              //   reverse: false,
              //   repeat: true,
              // ),
              Container(
                color: Colors.white,
                width: double.infinity,
                child: Column(
                  children: [
                    Divider(),
                    Column(
                      children: widget.additionalWidgets,
                    ),
                    GestureDetector(
                      onTap: widget.onTap ?? () {},
                      child: Container(
                        padding: EdgeInsets.only(
                          top: 5,
                          bottom: 5,
                          left: 10,
                          right: 10,
                        ),
                        margin: EdgeInsets.all(5),
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.circular(16.0),
                          color: Colors.blue,
                        ),
                        child: Text('tututp'),
                      ),
                    )
                  ],
                ),
              ),
            ],
          ),
        ),
      ),
      onWillPop: _onWillPop,
    );
  }

  Future<bool> _onWillPop() async {
    return true;
  }
}

class LottieConfig {
  final String asset;
  final double? width;
  final double? height;
  final BoxFit? fit;
  final bool? reverse;
  final bool? repeat;

  LottieConfig({
    required this.asset,
    this.width,
    this.height,
    this.fit,
    this.reverse,
    this.repeat,
  });
}

class LabelTitleHeader {
  final String title;
  double? fontSize;
  Color? color;

  LabelTitleHeader({required this.title, this.fontSize, this.color});
}

class LabelContent {
  final String title;
  double? fontSize;
  Color? color;

  LabelContent({required this.title, this.fontSize, this.color});
}

class LabelTitleButton {
  final String title;
  double? fontSize;
  Color? color;
  Color? buttonBackgroundColor;

  LabelTitleButton(
      {required this.title,
      this.fontSize,
      this.color,
      this.buttonBackgroundColor});
}

class CustomPopUpPkwt {
  final Function()? onTap;
  void Function(BuildContext)? finalNavigation;
  int? navigatePop;
  BuildContext? context;
  Color? headerBackgroundColor;
  Color? contentBackgroundColor;
  LabelTitleButton labelTextButton;
  LabelContent labelContent;
  LottieConfig lottieConfig;
  LabelTitleHeader labelTitleHeader;
  CustomPopUpPkwt.show(this.context,
      {this.onTap,
      this.headerBackgroundColor,
      this.contentBackgroundColor,
      required this.labelContent,
      required this.navigatePop,
      required this.finalNavigation,
      required this.labelTextButton,
      required this.lottieConfig,
      required this.labelTitleHeader}) {
    print("context : $context");
    Future.delayed(Duration(milliseconds: 200)).then((value) => showDialog(
          context: GlobalVariable.navState.currentContext!,
          builder: (BuildContext context) {
            return WillPopScope(
              child: AlertDialog(
                backgroundColor: Colors.transparent,
                shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.circular(10.0),
                ),
                contentPadding: EdgeInsets.all(20.0),
                content: Container(
                  width: MediaQuery.of(context).size.width,
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(16.0),
                    color: headerBackgroundColor ?? Colors.blue,
                  ),
                  child: Column(
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      // Container(
                      //   child: Lottie.asset(
                      //     lottieConfig.asset,
                      //     width: lottieConfig.width ?? 150,
                      //     height: lottieConfig.height ?? 150,
                      //     fit: lottieConfig.fit ?? BoxFit.fill,
                      //     reverse: lottieConfig.reverse ?? false,
                      //     repeat: lottieConfig.repeat ?? true,
                      //   ),
                      // ),
                      Container(
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.only(
                              bottomLeft: Radius.circular(16),
                              bottomRight: Radius.circular(16)),
                          color: contentBackgroundColor ?? Colors.white,
                        ),
                        width: double.infinity,
                        child: Column(
                          children: [
                            Column(
                              children: [
                                Container(
                                  margin: EdgeInsets.all(10),
                                  child: Text(
                                    labelTitleHeader.title,
                                    // style: TextStyle(
                                    //     fontSize:
                                    //         labelTitleHeader.fontSize ?? 12,
                                    //     color: labelTitleHeader.color ??
                                    //         Colors.black),
                                  ),
                                ),
                                // Container(
                                //   margin: EdgeInsets.all(10),
                                //   child: Text(
                                //     labelContent.title,
                                //     style: TextStyle(
                                //         color:
                                //             labelContent.color ?? Colors.black,
                                //         fontSize: labelContent.fontSize ?? 15),
                                //     textAlign: TextAlign.center,
                                //   ),
                                // ),
                              ],
                            ),
                            GestureDetector(
                              onTap: () {
                                _onTapHandler(context);
                              },
                              child: Container(
                                padding: EdgeInsets.only(
                                  top: 10,
                                  bottom: 10,
                                  left: 15,
                                  right: 15,
                                ),
                                margin: EdgeInsets.all(10),
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(16.0),
                                  color:
                                      labelTextButton.buttonBackgroundColor ??
                                          Colors.blue,
                                ),
                                child: Text(
                                  labelTextButton.title,
                                  // style: TextStyle(
                                  //     fontSize: labelTextButton.fontSize ?? 18,
                                  //     color: labelTextButton.color ??
                                  //         Colors.white),
                                ),
                              ),
                            )
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              ),
              onWillPop: _onWillPop,
            );
          },
        ));
  }

  void _onTapHandler(BuildContext context) {
    for (int i = 0; i < (navigatePop ?? 0); i++) {
      BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
    }
    finalNavigation?.call(context);
  }

  Future<bool> _onWillPop() async {
    for (int i = 0; i < (navigatePop ?? 0); i++) {
      BlocProvider.of<NavigatorBloc>(context!).add(NavigatePop(context!));
    }
    finalNavigation?.call(context!);
    return true;
  }
}

class TemplateButton extends StatelessWidget {
  var label;
  var color;
  var contentColor;
  var onClick;
  var icon;
  var borderColor;
  var gradient;
  bool bold;
  bool enabled;
  bool expand;
  bool textAlignCenter;
  bool expandText;
  double paddingTopBottom;
  double paddingLeftRight;
  double fontSize;
  double? widthButton;
  double? heightButton;
  double iconSize;
  double radius;
  TemplateButton(
      {this.label,
      this.color = Colors.blue,
      this.onClick,
      this.contentColor = Colors.white,
      this.icon,
      this.fontSize = 12,
      this.paddingTopBottom = 10,
      this.expand = false,
      this.borderColor,
      this.paddingLeftRight = 16,
      this.widthButton,
      this.heightButton,
      this.enabled = true,
      this.iconSize = 16,
      this.bold = false,
      this.gradient,
      this.radius = 18.0,
      this.textAlignCenter = false,
      this.expandText = false});
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: enabled == true ? onClick : null,
      child: Container(
        height: heightButton,
        width: widthButton,
        padding: EdgeInsets.fromLTRB(paddingLeftRight, paddingTopBottom,
            paddingLeftRight, paddingTopBottom),
        decoration: BoxDecoration(
            gradient: gradient,
            borderRadius: BorderRadius.all(Radius.circular(radius)),
            border: Border.all(
              width: 1,
              color: enabled == true
                  ? borderColor != null
                      ? borderColor
                      : color == Colors.white
                          ? contentColor
                          : color
                  : Colors.grey[350]!,
            ),
            color: enabled == true ? color : Colors.grey[350]),
        child: Row(
          mainAxisSize: !expand ? MainAxisSize.min : MainAxisSize.max,
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: <Widget>[
            icon != null
                ? Row(
                    children: <Widget>[
                      Icon(
                        icon,
                        color: contentColor,
                        size: iconSize,
                      ),
                      SizedBox(
                        width: 8,
                      ),
                    ],
                  )
                : Container(),
            expandText
                ? Expanded(
                    child: Text(
                    label,
                    // style: TextStyle(
                    //     color: enabled == true ? contentColor : Colors.white,
                    //     fontSize: fontSize,
                    //     fontWeight: bold ? FontWeight.bold : FontWeight.normal),
                    textAlign: textAlignCenter ? TextAlign.center : null,
                  ))
                : Text(
                    label,
                    // style: TextStyle(
                    //     color: enabled == true ? contentColor : Colors.white,
                    //     fontSize: fontSize,
                    //     fontWeight: bold ? FontWeight.bold : FontWeight.normal),
                    textAlign: textAlignCenter ? TextAlign.center : null,
                  ),
          ],
        ),
      ),
    );
  }
}
