import 'package:absenkuv3/Repository/Model/PageModel/mPkwtPage.dart';
import 'package:flutter/material.dart';

class TolakBottomSheet extends StatefulWidget {
  final textTolak;
  final VoidCallback onSubmit;
  final MenuPkwt? redakasional;

  TolakBottomSheet({required this.textTolak, required this.onSubmit,required this.redakasional});

  @override
  State<TolakBottomSheet> createState() => _TolakBottomSheetState();
}

class _TolakBottomSheetState extends State<TolakBottomSheet> {
  @override
  Widget build(BuildContext context) {
    return Container(
      height: MediaQuery.of(context).size.height / 2,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Expanded(
            child: SingleChildScrollView(
              child: Column(
                children: [
                  Container(
                      width: double.infinity,
                      margin: EdgeInsets.only(right: 20, left: 20),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Center(
                                child: Container(
                                  width: 50,
                                  height: 5,
                                  margin: EdgeInsets.all(10),
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(10.0),
                                    color: Colors.grey,
                                    border: Border.all(color: Colors.grey),
                                  ),
                                ),
                              ),
                              SizedBox(
                                height: 20,
                              ),
                              Container(
                                margin: EdgeInsets.all(8),
                                child: Text(
                                  widget.redakasional!.data!.penolakanPKWT.toString(),
                                  style: TextStyle(
                                      fontSize: 16,
                                      fontWeight: FontWeight.bold),
                                ),
                              )
                            ],
                          ),
                          Divider(),
                          Container(
                            margin: EdgeInsets.all(10),
                            child: RichText(
                                text: TextSpan(
                                    text: widget.redakasional!.data!.ketMandatoryPenolakan,
                                    style: TextStyle(color: Colors.grey),
                                    children: const <TextSpan>[
                                  TextSpan(
                                      text: '*',
                                      style: TextStyle(
                                          fontWeight: FontWeight.bold,
                                          color: Colors.red)),
                                ])),
                          ),
                          TextField(
                            controller: widget.textTolak,
                            keyboardType: TextInputType.multiline,
                            maxLines: 5,
                            decoration: InputDecoration(
                                hintText: widget.redakasional!.data!.hintPenolakan,
                                // hintStyle: GoogleFonts.workSans(),
                                focusedBorder: OutlineInputBorder(
                                    borderSide: BorderSide(
                                        width: 1, color: Colors.redAccent)),
                                border: OutlineInputBorder(
                                    borderSide: BorderSide(
                                        width: 1, color: Colors.indigo))),
                          ),
                        ],
                      ))
                ],
              ),
            ),
          ),
          Container(
              width: double.infinity,
              padding: EdgeInsets.all(1.0),
              margin: EdgeInsets.only(bottom: 20),
              child: Column(
                children: [
                  Divider(),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: GestureDetector(
                          onTap: () {
                            widget.textTolak.clear();
                            Navigator.of(context).pop();
                            // widget.onClear();
                          },
                          child: Container(
                            margin: EdgeInsets.all(5),
                            decoration: BoxDecoration(
                              color: Colors.transparent,
                              borderRadius: BorderRadius.circular(30),
                              border: Border.all(color: Colors.indigo),
                            ),
                            padding: EdgeInsets.all(13),
                            alignment: Alignment.center,
                            child: Text(
                              widget.redakasional!.button!.btnBatal.toString(),
                              style: TextStyle(
                                  color: Colors.indigo[900],
                                  fontWeight: FontWeight.bold),
                            ),
                          ),
                        ),
                      ),
                      Expanded(
                        child: GestureDetector(
                          onTap: () async {
                            widget.onSubmit();
                          },
                          child: Container(
                            margin: EdgeInsets.all(5),
                            decoration: BoxDecoration(
                              color: Colors.indigo[900],
                              borderRadius: BorderRadius.circular(30),
                            ),
                            padding: EdgeInsets.all(15),
                            alignment: Alignment.center,
                            child: Text(
                              'SUBMIT',
                              style: TextStyle(
                                  color: Colors.white,
                                  fontWeight: FontWeight.bold),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                ],
              )),
        ],
      ),
    );
  }
}
