import 'package:absenkuv3/Repository/Model/PageModel/mPkwtPage.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:signature/signature.dart';
class SignatureBottomSheet extends StatefulWidget {
  final SignatureController controller;
  final VoidCallback onClear;
  final VoidCallback onSubmit;
  final MenuPkwt? redakasional;

  SignatureBottomSheet({
    required this.controller,
    required this.onClear,
    required this.onSubmit,
    required this.redakasional
  });

  @override
  _SignatureBottomSheetState createState() => _SignatureBottomSheetState();
}

class _SignatureBottomSheetState extends State<SignatureBottomSheet> {
  @override
  Widget build(BuildContext context) {
    double screenHeight = MediaQuery.of(context).size.height;
    double halfScreenHeight = screenHeight * 0.5;
    double screenWidth = MediaQuery.of(context).size.width;
    double signatureWidthPercentage = 0.8;
    double signatureHeightPercentage = 0.3;
    double signatureWidth = screenWidth * signatureWidthPercentage;
    double signatureHeight = screenHeight * signatureHeightPercentage;
    return Container(
      height: MediaQuery.of(context).size.height - 250.0,
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Expanded(
            child: SingleChildScrollView(
              child: Column(
                children: [
                  Container(
                      width: double.infinity,
                      margin: EdgeInsets.only(right: 20, left: 20),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Center(
                                child: Container(
                                  width: 50,
                                  height: 5,
                                  margin: EdgeInsets.all(10),
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(10.0),
                                    color: Colors.grey,
                                    border: Border.all(color: Colors.grey),
                                  ),
                                ),
                              ),
                              SizedBox(
                                height: 20,
                              ),
                              Container(
                                margin: EdgeInsets.all(8),
                                child: Text(
                                  widget.redakasional!.data!.persetujuanPKWT.toString(),
                                  style: TextStyle(
                                      fontSize: 16,
                                      fontWeight: FontWeight.bold),
                                ),
                              )
                            ],
                          ),
                          Divider(),
                          Container(
                            height: 60,
                            decoration: BoxDecoration(
                              color: Color.fromARGB(234, 86, 203, 242),
                              borderRadius: BorderRadius.all(
                                  Radius.circular(CustomStyle.cardRadius)),
                            ),
                            margin: EdgeInsets.only(
                                top: 12, left: 12, right: 12, bottom: 12),
                            padding: EdgeInsets.only(left: 5),
                            child: Container(
                              child: Center(
                                child: Container(
                                  child: Row(
                                    mainAxisAlignment:
                                        MainAxisAlignment.spaceBetween,
                                    children: [
                                      Container(
                                        padding: EdgeInsets.only(
                                            left: 15, right: 15),
                                        child: Icon(
                                          Icons.info_outline_rounded,
                                          size: 25,
                                          color: Colors.indigo,
                                        ),
                                      ),
                                      Expanded(
                                          child: Container(
                                        padding: EdgeInsets.only(left: 10),
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          mainAxisAlignment:
                                              MainAxisAlignment.center,
                                          children: [
                                            Text(
                                              widget.redakasional!.data!.infoPKWT.toString(),
                                              style: TextStyle(
                                                  color: Colors.indigo),
                                            )
                                          ],
                                        ),
                                      )),
                                    ],
                                  ),
                                ),
                              ),
                            ),
                          ),
                          Container(
                            margin: EdgeInsets.all(5),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.end,
                              children: [
                                GestureDetector(
                                  onTap: () {
                                    widget.controller.clear();
                                  },
                                  child: Row(
                                    children: [
                                      Icon(
                                        Icons.refresh_rounded,
                                        color: Colors.indigo,
                                        size: 15,
                                      ),
                                      Text(
                                        widget.redakasional!.button!.btnTddUlang.toString(),
                                        style: TextStyle(color: Colors.indigo),
                                      )
                                    ],
                                  ),
                                )
                              ],
                            ),
                          ),
                          Container(
                              padding: EdgeInsets.only(left: 4),
                              margin: EdgeInsets.all(4),
                              child: RichText(
                                maxLines: 2,
                                
                                  text: TextSpan(
                                      text:
                                          widget.redakasional!.data!.ketMandatoryTTD,
                                      style: TextStyle(color: Colors.grey),
                                      children: const <TextSpan>[
                                    TextSpan(
                                        text: ' *',
                                        style: TextStyle(
                                            fontWeight: FontWeight.bold,
                                            color: Colors.red)),
                                  ]))),
                          Container(
                            decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(10.0),
                                border:
                                    Border.all(color: Colors.indigo.shade900),
                                color: const Color(0xffdefcf8)),
                            child: Signature(
                                controller: widget.controller,
                                width: signatureWidth,
                                height: signatureHeight,
                                backgroundColor: Color(0xffdefcf8)),
                          )
                        ],
                      ))
                  // Container(
                  //   decoration: BoxDecoration(
                  //     borderRadius: BorderRadius.circular(10.0),
                  //     border: Border.all(color: Colors.indigo.shade900),
                  //   ),
                  //   child: Signature(
                  //     controller: widget.controller,
                  //     width: signatureWidth,
                  //     height: signatureHeight,
                  //     backgroundColor: Colors.transparent,
                  //   ),
                  // ),
                ],
              ),
            ),
          ),
          Container(
              width: double.infinity,
              padding: EdgeInsets.all(1.0),
              margin: EdgeInsets.only(bottom: 20),
              child: Column(
                children: [
                  Divider(),
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Expanded(
                        child: GestureDetector(
                          onTap: () {
                            widget.controller.clear();
                            widget.onClear();
                          },
                          child: Container(
                            margin: EdgeInsets.all(5),
                            decoration: BoxDecoration(
                              color: Colors.transparent,
                              borderRadius: BorderRadius.circular(30),
                              border: Border.all(color: Colors.indigo),
                            ),
                            padding: EdgeInsets.all(13),
                            alignment: Alignment.center,
                            child: Text(
                              widget.redakasional!.button!.btnBatal.toString(),
                              style: TextStyle(color: Colors.indigo[900],fontWeight: FontWeight.bold),
                            ),
                          ),
                        ),
                      ),
                      Expanded(
                        child: GestureDetector(
                          onTap: () async {
                            widget.onSubmit();
                          },
                          child: Container(
                            margin: EdgeInsets.all(5),
                            decoration: BoxDecoration(
                              color: Colors.indigo[900],
                              borderRadius: BorderRadius.circular(30),
                            ),
                            padding: EdgeInsets.all(15),
                            alignment: Alignment.center,
                            child: Text(
                              'SUBMIT',
                              style: TextStyle(color: Colors.white,fontWeight: FontWeight.bold),
                            ),
                          ),
                        ),
                      ),
                    ],
                  ),
                ],
              )),
        ],
      ),
    );
  }
}
