import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mPengumuman.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:flutter_html/flutter_html.dart';

class CardPengumuman extends StatefulWidget {
  final DataPengumuman dataPengumuman;
  final GlobalKey<ScaffoldState> scaffoldKey;
  CardPengumuman(this.dataPengumuman, this.scaffoldKey);

  @override
  _CardPengumumanState createState() => _CardPengumumanState();
}

class _CardPengumumanState extends State<CardPengumuman> {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
          NavigateToDetailPengumuman(
              context, [widget.dataPengumuman.idPengumuman,'komponen'])),
      child: Container(
        decoration: CustomStyle.boxDecoration,
        padding: EdgeInsets.all(14),
        margin: EdgeInsets.only(top: 12, left: 12, right: 12),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              children: [
                Icon(
                  Icons.new_releases_outlined,
                  size: 32,
                  color: CustomStyle.color1,
                ),
                SizedBox(
                  width: 8,
                ),
                Expanded(
                    child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      widget.dataPengumuman.judul!,
                      style: TextStyle(
                          fontSize: CustomStyle.fontSizeSmall + 1,
                          fontWeight: FontWeight.w600,
                          color: CustomStyle.fontColorBlack),
                    ),
                    SizedBox(
                      height: 2,
                    ),
                    Text(
                      '${widget.dataPengumuman.tanggalCreated}, ${widget.dataPengumuman.waktuCreated}',
                      style: TextStyle(
                          fontSize: CustomStyle.fontSizeSmall - 1,
                          color: CustomStyle.fontColorGrey,
                          fontWeight: FontWeight.w600),
                    ),
                  ],
                )),
                SizedBox(
                  width: 12,
                ),
                PopupMenuButton<String>(
                  onSelected: (value) {
                    if (value == 'Detail')
                      BlocProvider.of<NavigatorBloc>(context).add(
                          NavigateToDetailPengumuman(
                              context, widget.dataPengumuman.idPengumuman));
                  },
                  itemBuilder: (BuildContext context) {
                    return actionMenu();
                  },
                  child: Icon(
                    Icons.more_vert_sharp,
                    color: CustomStyle.fontColorGrey,
                  ),
                )
              ],
            ),
            SizedBox(
              height: 6,
            ),
            Divider(
              thickness: 1,
            ),
            Html(
              data: widget.dataPengumuman.content!.length > 140
                  ? widget.dataPengumuman.content!.substring(0, 140) + '..'
                  : widget.dataPengumuman.content,
              style: {
                "p": Style(
                  padding: HtmlPaddings.zero,
                  margin: Margins.zero,
                ),
              },
            )
          ],
        ),
      ),
    );
  }

  actionMenu() {
    return {'Detail'}.map((String choice) {
      return PopupMenuItem<String>(
        value: choice,
        child: Text(choice),
      );
    }).toList();
  }
}

class TemplateRow extends StatelessWidget {
  final String title;
  final String subTitle;
  final Color color;
  final String imageUrl;
  TemplateRow(this.title, this.subTitle, this.imageUrl, this.color);

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        Expanded(
          flex: 4,
          child: Text(
            title,
            style: TextStyle(
                fontWeight: FontWeight.w600,
                color: color,
                fontSize: CustomStyle.fontSizeSmall - 1),
          ),
        ),
        SizedBox(
          width: 12,
        ),
        Expanded(
          flex: 7,
          child: Text(
            subTitle,
            style: TextStyle(
                color: CustomStyle.fontColorBlack,
                fontSize: CustomStyle.fontSizeSmall - 1),
          ),
        ),
        SizedBox(
          width: 12,
        ),
        Expanded(
          flex: 1,
          // ignore: unnecessary_null_comparison
          child: imageUrl != null
              ? GestureDetector(
                  onTap: () => BlocProvider.of<NavigatorBloc>(context)
                      .add(NavigateToDetailImageClicked(context, imageUrl)),
                  child: Icon(
                    Icons.image,
                    color: Colors.grey[500],
                    size: 22,
                  ))
              : Container(),
        ),
      ],
    );
  }
}
