import 'package:absenkuv3/Bloc/Pengumuman/PengumumanBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/UI/templateDateRangePicker.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

import 'KomponenPengumuman.dart';



class HalamanListPengumuman extends StatefulWidget {
  @override
  _HalamanListPengumumanState createState() => _HalamanListPengumumanState();
}

class _HalamanListPengumumanState extends State<HalamanListPengumuman> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    BlocProvider.of<PengumumanBloc>(context).add(getListPengumumanEvent(context, null));
    _scrollController.addListener(()=>BlocProvider.of<PengumumanBloc>(context).add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          BlocBuilder<PengumumanBloc, PengumumanState>(
              builder: (BuildContext context, PengumumanState state){
                if(state is getListPengumumanSuccessState || state is LoadMoreProgressState)
                  return Stack(
                    children: <Widget>[
                      ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          controller: _scrollController,
                          itemCount: state.data!.length,
                          itemBuilder: (BuildContext context, index) {
                            return CardPengumuman(state.data![index],scaffoldKey);
                          }
                      ),
                      state is LoadMoreProgressState? Positioned(
                          bottom :16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                    ],
                  );
                else if(state is PengumumanProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
              }),
          Positioned(
            bottom: 16,
            right: 14,
            child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
              listener: (BuildContext context, DateRangePickerState dateRangePickerState){
                if(dateRangePickerState is DateAvailable) BlocProvider.of<PengumumanBloc>(context).add(getListPengumumanEvent(context, ModelFilter(dateRange: dateRangePickerState.date)));
              },
              child: TemplateDateRangePicker(),
            ),
          ),
        ],
      ),
    );
  }
}


