import 'dart:async';

import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/Patroli/SelectedJadwalPatroliBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mPatroliPage.dart';
import 'package:absenkuv3/UI/Modul/Patroli/ListJadwalPatroli.dart';
import 'package:absenkuv3/UI/Modul/Patroli/WidgetQrPatroli.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:absenkuv3/Bloc/Patroli/CekValidasiWaktuBloc.dart';
import 'package:absenkuv3/Repository/Model/mChekpoint.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';

class CustomBottomSheet extends StatefulWidget {
  CustomBottomSheet(this.redaksional);
  MenuPatroli? redaksional;
  @override
  _CustomBottomSheetState createState() => _CustomBottomSheetState();
}

class _CustomBottomSheetState extends State<CustomBottomSheet> {
  DateTime utc = DateTime.now().toUtc();

  @override
  void initState() {
    BlocProvider.of<CekValidasiWaktuBloc>(context)
        .add(ChekValidasiWaktu(utc.millisecondsSinceEpoch.toString()));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    double screenHeight = MediaQuery.of(context).size.height;
    double halfScreenHeight = screenHeight * 0.5;

    return Container(
      child: Padding(
        padding: EdgeInsets.all(13.0),
        child: Column(
          mainAxisSize: MainAxisSize.min,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: <Widget>[
            Container(
              height: halfScreenHeight,
              width: MediaQuery.of(context).size.width,
              padding: EdgeInsets.only(top: 16, left: 16, right: 16),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    widget.redaksional!.data!.pilihJadwal.toString(),
                    style: TextStyle(fontSize: 14, fontWeight: FontWeight.bold),
                  ),
                  Divider(),
                  Expanded(
                    child: ListJadwalPatroli(
                      onValuesChanged: (List<JadwalChekpoint> selectedValues) {
                        BlocProvider.of<SelectedJadwalPatroliBloc>(context).add(
                            UpdateSelectedJadwal(selectedValues.isNotEmpty
                                ? selectedValues.first
                                : null));
                      },
                    ),
                  ),
                  BlocBuilder<CekValidasiWaktuBloc, CekValidasiWaktuState>(
                    builder: (context, state) {
                      return BlocBuilder<SelectedJadwalPatroliBloc,
                          JadwalChekpoint?>(
                        builder: (context, selectedJadwalChekpoint) {
                          return IgnorePointer(
                            ignoring: selectedJadwalChekpoint == null,
                            child: GestureDetector(
                              onTap: () async {
                                var userData =
                                    await sharedPreferences().getUserData();
                                BlocProvider.of<CekValidasiWaktuBloc>(context)
                                    .add(ChekValidasiWaktu(
                                        utc.millisecondsSinceEpoch.toString()));
                                if (selectedJadwalChekpoint != null) {
                                  if (state is ChekValidasiSuccess ||
                                      state is ChekValidasiProgress) {
                                    Navigator.pop(context);
                                    if (userData.dataLogin!.qrcodeFlag == 0) {
                                      // Navigator.of(context)
                                      //     .push(MaterialPageRoute(
                                      //   builder: (context) => QRViewExample(
                                      //     jadwalChekpoint:
                                      //         selectedJadwalChekpoint,
                                      //     redaksional: widget.redaksional,
                                      //   ),
                                      // ));
                                      Navigator.of(context)
                                          .push(MaterialPageRoute(
                                        builder: (context) => BarcodeScannerV1(
                                          jadwalChekpoint:
                                          selectedJadwalChekpoint,
                                          redaksional: widget.redaksional,
                                        ),
                                      ));
                                    } else if (userData.dataLogin!.qrcodeFlag ==
                                        1) {
                                      Navigator.of(context)
                                          .push(MaterialPageRoute(
                                        builder: (context) => BarcodeScannerV1(
                                          jadwalChekpoint:
                                              selectedJadwalChekpoint,
                                          redaksional: widget.redaksional,
                                        ),
                                      ));
                                    } else {
                                      Navigator.of(context)
                                          .push(MaterialPageRoute(
                                        builder: (context) => BarcodeScannerV1(
                                          jadwalChekpoint:
                                          selectedJadwalChekpoint,
                                          redaksional: widget.redaksional,
                                        ),
                                      ));
                                      // Navigator.of(context)
                                      //     .push(MaterialPageRoute(
                                      //   builder: (context) => QRViewExample(
                                      //     jadwalChekpoint:
                                      //         selectedJadwalChekpoint,
                                      //     redaksional: widget.redaksional,
                                      //   ),
                                      // ));
                                    }
                                  } else if (state is CekValidasiNovalid) {
                                  } else {
                                    showDialog(
                                        context: context,
                                        builder: (BuildContext context) {
                                          return AlertDialog(
                                            shape: RoundedRectangleBorder(
                                                borderRadius: BorderRadius.all(
                                                    Radius.circular(CustomStyle
                                                        .boxRadius))),
                                            content: Column(
                                              mainAxisSize: MainAxisSize.min,
                                              children: [
                                                Container(
                                                  width: 70,
                                                  height: 70,
                                                  margin: EdgeInsets.only(
                                                      bottom: 15),
                                                  child: Icon(
                                                    Icons
                                                        .warning_amber_outlined,
                                                    color: Colors
                                                        .orange, // Warna ikon
                                                    size: 80, // Ukuran ikon
                                                  ),
                                                ),
                                                Center(
                                                  child: Text(
                                                    widget.redaksional!.data!
                                                        .peringatanWaktu
                                                        .toString(),
                                                    textAlign: TextAlign.center,
                                                    style: TextStyle(
                                                        fontSize: CustomStyle
                                                            .fontSizeNormal,
                                                        fontWeight:
                                                            FontWeight.w600),
                                                  ),
                                                ),
                                              ],
                                            ),
                                          );
                                        });
                                    // Handle dialog for invalid validation
                                  }
                                } else {
                                  // Handle dialog for no selection
                                }
                              },
                              child: Container(
                                decoration: BoxDecoration(
                                  color: selectedJadwalChekpoint != null
                                      ? Colors.green
                                      : Colors.grey,
                                  borderRadius: BorderRadius.circular(15),
                                ),
                                padding: EdgeInsets.all(16),
                                alignment: Alignment.center,
                                child: Text(
                                  'SUBMIT',
                                  style: TextStyle(color: Colors.white),
                                ),
                              ),
                            ),
                          );
                        },
                      );
                    },
                  ),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}
