import 'package:absenkuv3/Bloc/Akun/NotifikasiAkunBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mNotifikasiPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Notif/CardNotifikasiAkun.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';


class HalamanNotifikasiAkun extends StatefulWidget {

  @override
  State<HalamanNotifikasiAkun> createState() => _HalamanNotifikasiAkunState();
}

class _HalamanNotifikasiAkunState extends State<HalamanNotifikasiAkun> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<NotifikasiAkunBloc>(context).add(getNotifikasiAkunEvent(context));
    _scrollController.addListener(() => BlocProvider.of<NotifikasiAkunBloc>(context).add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }

  Future<bool> keluar() async {
    Navigator.pop(context);
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateToRepaceHalamanAkun(context));
    return false;
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: Scaffold(
        key: scaffoldKey,
        appBar: AppBar(centerTitle: true,
          iconTheme: IconThemeData(color: CustomStyle.color15),
          flexibleSpace: Image(
            image: AssetImage(ValueImage.headerBiruDashboard),
            fit: BoxFit.cover,
          ),
          backgroundColor: Colors.transparent,
          title: FutureBuilder<PageNotifikasiModel>(
            future: PengaturanBahasa().notifikasi(),
            builder: (context, snapshot) {
              return Text(
                snapshot.data == null ? 'Data Submission History' : snapshot.data!.notifikasi!.historyPengajuanData!,
                // 'History Pengajuan Data',
                style: TextStyle(fontSize: CustomStyle.fontSizeTitle,color: CustomStyle.color15),
              );
            }
          ),
        ),
        body: Stack(
          children: [
            BlocBuilder<NotifikasiAkunBloc, NotifikasiAkunState>(
              builder: (context, state) {
                if(state is NotifikasiAkunProgressState){
                  return Container(
                    height: double.infinity,
                    width: double.infinity,
                    child: Center(
                        child: CircularProgressIndicator(
                          strokeWidth: 8,
                        )),
                  );
                }else if(state is NotifikasiAkunErrorState){
                  return Container(
                    height: double.infinity,
                    width: double.infinity,
                    child: Center(
                        child: CircularProgressIndicator(
                          strokeWidth: 8,
                        )),
                  );
                }else if(state is getNotifikasiAkunSuccessState || state is LoadMoreProgressState){
                  if(state.listNotifikasiAkun == null){
                    return Container(
                      height: double.infinity,
                      width: double.infinity,
                      decoration: CustomStyle.boxDecoration,
                      child: Center(child: Image.asset(ValueImage.noData, height: 250))
                    );
                  }else{
                    return Stack(
                      children: [
                        ListView.builder(
                            physics: AlwaysScrollableScrollPhysics(),
                            controller: _scrollController,
                            itemCount: state.listNotifikasiAkun!.length,
                            itemBuilder: (BuildContext ctx, index){
                              return CardNotifikasiAkun(state.listNotifikasiAkun![index],scaffoldKey);
                            }
                        ),
                        state is LoadMoreProgressState
                            ? Positioned(
                            bottom: 16,
                            child: Container(
                                width: MediaQuery.of(context).size.width,
                                child: Center(
                                    child: CircularProgressIndicator(
                                      strokeWidth: 8,
                                    ))))
                            : Container(),
                      ],
                    );
                  }
                }else{
                  return Container(
                    height: double.infinity,
                    width: double.infinity,
                    child: Center(
                        child: CircularProgressIndicator(
                          strokeWidth: 8,
                        )),
                  );
                }
              }
            ),
          ],
        )
      ),
    );
  }
}
