import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// ignore: must_be_immutable
class CardNotifikasiAkun extends StatefulWidget {
  DataNotifikasiAkun data;
  GlobalKey<ScaffoldState> scaffoldKey;
  CardNotifikasiAkun(this.data, this.scaffoldKey);

  @override
  _CardNotifikasiAkunState createState() => _CardNotifikasiAkunState();
}

class _CardNotifikasiAkunState extends State<CardNotifikasiAkun> {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: (){
        if (widget.data.route == 'detail_data_diri') {
        BlocProvider.of<NavigatorBloc>(context)
            .add(NavigateToHalamanDetailDataDiri(context, widget.data));
      } else if (widget.data.route == 'detail_data_keluarga') {
        BlocProvider.of<NavigatorBloc>(context)
            .add(NavigateToHalamanDetailDataKeluarga(context, widget.data));
      } else if (widget.data.route == 'detail_data_pendidikan') {
        BlocProvider.of<NavigatorBloc>(context)
            .add(NavigateToHalamanDetailDataPendidikan(context, widget.data));
      } else if (widget.data.route == 'detail_data_pengalaman_kerja') {
        BlocProvider.of<NavigatorBloc>(context).add(
            NavigateToHalamanDetailDataPengalamanKerja(context, widget.data));
      } else if (widget.data.route == 'detail_data_kelengkapan_file') {
        BlocProvider.of<NavigatorBloc>(context).add(
            NavigateToHalamanDetailDataKelengkapanFile(context, widget.data));
      }
      },
      child: Container(
        margin: EdgeInsets.only(top: 12, left: 9, right: 9),
        child: Container(
          child: Stack(
            children: [
              Container(
                margin: EdgeInsets.only(left: 12, right: 12),
                width: MediaQuery.of(context).size.width,
                decoration: BoxDecoration(
                    boxShadow: [
                      BoxShadow(
                        color: Colors.grey.withOpacity(0.2),
                        spreadRadius: 1.6,
                        blurRadius: 4,
                        offset: Offset(0, 1), // changes position of shadow
                      ),
                    ],
                    color: widget.data.flagBaca == "0"
                        ? Colors.blue.shade50
                        : Colors.white,
                    borderRadius: new BorderRadius.all(
                      Radius.circular(18),
                    )),
                child: Container(
                  margin: EdgeInsets.only(top: 44),
                  padding: EdgeInsets.only(bottom: 16),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Padding(
                        padding: EdgeInsets.only(left: 6, right: 6, top: 4),
                        child: Divider(
                          thickness: 1,
                        ),
                      ),
                      Padding(
                          padding: EdgeInsets.only(
                              left: 25, right: 25, top: 7, bottom: 2),
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text(
                                widget.data.messageNotifikasi!,
                                style: TextStyle(
                                    fontWeight: FontWeight.w400,
                                    color: CustomStyle.fontColorGrey,
                                    fontSize: CustomStyle.fontSizeSmall - 1),
                              ),
                            ],
                          ))
                    ],
                  ),
                ),
              ),
              Container(
                margin: EdgeInsets.only(left: 24, right: 24, top: 6),
                height: 44,
                width: MediaQuery.of(context).size.width,
                child: Row(
                  children: [
                    SizedBox(width: 7),
                    // Image.asset(
                    //     widget.data.action == "1"
                    //         ? ValueImage.iconTambah
                    //         : widget.data.action == "2"
                    //             ? ValueImage.iconEdit
                    //             : ValueImage.iconDelete,
                    //     height: 35),
                    Image.asset(getMenuIcon(widget.data.menu), height: 35),
                    SizedBox(width: 13),
                    Expanded(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          Text(
                            '${widget.data.statusAction} ${widget.data.statusPengajuan}',
                            style: TextStyle(
                                fontWeight: FontWeight.w600,
                                color: CustomStyle.fontColorBlack,
                                fontSize: CustomStyle.fontSizeSmall + 1),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }

  String getMenuIcon(String? menu) {
    switch (menu) {
      case "data_diri":
        return ValueImage.iconDataDiri;
      case "data_keluarga":
        return ValueImage.iconDataKeluarga;
      case "data_pendidikan":
        return ValueImage.iconDataPendidikan;
      case "pengalaman_kerja":
        return ValueImage.iconDataPengalamanKerja;
      case "sertifikat":
        return ValueImage.iconDataFile;
      case "kelengkapan":
        return ValueImage.iconDataFile;
      default:
        return ValueImage.iconTambah; // fallback icon kalau tidak cocok
    }
  }

  actionMenu() {
    List<String> buttonAksi = ['Detail'];
    return buttonAksi.map((String choice) {
      return PopupMenuItem<String>(
        value: choice,
        child: Text(choice),
      );
    }).toList();
  }

  void doAction(BuildContext context, String value, String route) {
    if (value == 'Detail') {
      print("route : $route");
      print("id : ${widget.data.id}");
      if (route == 'detail_data_diri') {
        BlocProvider.of<NavigatorBloc>(context)
            .add(NavigateToHalamanDetailDataDiri(context, widget.data));
      } else if (route == 'detail_data_keluarga') {
        BlocProvider.of<NavigatorBloc>(context)
            .add(NavigateToHalamanDetailDataKeluarga(context, widget.data));
      } else if (route == 'detail_data_pendidikan') {
        BlocProvider.of<NavigatorBloc>(context)
            .add(NavigateToHalamanDetailDataPendidikan(context, widget.data));
      } else if (route == 'detail_data_pengalaman_kerja') {
        BlocProvider.of<NavigatorBloc>(context).add(
            NavigateToHalamanDetailDataPengalamanKerja(context, widget.data));
      } else if (route == 'detail_data_kelengkapan_file') {
        BlocProvider.of<NavigatorBloc>(context).add(
            NavigateToHalamanDetailDataKelengkapanFile(context, widget.data));
      }
    }
  }
}
