import 'dart:io';

import 'package:absenkuv3/Bloc/SplashScreenBloc.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Setting/security_service.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanSplashScreen extends StatefulWidget {
  @override
  _HalamanSplashScreenState createState() => _HalamanSplashScreenState();
}

class _HalamanSplashScreenState extends State<HalamanSplashScreen> {
  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: Scaffold(
          body: Stack(
            children: [
              Container(
        width: double.infinity,
        height: double.infinity,
        child: Image.asset(
              ValueImage.bgSplashScreen,
              fit: BoxFit.fitHeight,
        ),
      ),
              // Center(child: Image.asset(ValueImage.logoSplashScreen, height: 180,),)
            ],
          )),
    );
  }

  @override
  void initState() {
    // BlocProvider.of<SplashScreenBloc>(context).add(InitStateEvent(context));
    cekSource();
    super.initState();
  }
  void cekSource() async {
    if(Platform.isAndroid && ServerInfo.cekSource ){
      String source = await SecurityService.isCheckSource();
      BlocProvider.of<SplashScreenBloc>(context).add(InitStateEvent(context, source));
    }else{
      BlocProvider.of<SplashScreenBloc>(context).add(InitStateEvent(context, "com.android.vending"));
    }
  }

  Future<bool> keluar() async{
    SystemNavigator.pop();
    return false;
  }
}
