import 'package:absenkuv3/Bloc/Lembur/RekapLemburSayaBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mLemburPage.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Lembur/KomponenLembur.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/UI/templateDateRangePicker.dart';
import 'package:absenkuv3/UI/Template/FilterToggle/UI/templateFilterTogle.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';



class HalamanListRekapLemburSaya extends StatefulWidget {
  final PageLemburModel redaksional;
  HalamanListRekapLemburSaya(this.redaksional);

  @override
  _HalamanListRekapLemburSayaState createState() => _HalamanListRekapLemburSayaState();
}

class _HalamanListRekapLemburSayaState extends State<HalamanListRekapLemburSaya> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    BlocProvider.of<RekapLemburSayaBloc>(context).add(getListLemburEvent(context, null));
    _scrollController.addListener(()=>BlocProvider.of<RekapLemburSayaBloc>(context).add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: Stack(
        children: [
          BlocBuilder<RekapLemburSayaBloc, RekapLemburSayaState>(
              builder: (BuildContext context, RekapLemburSayaState state){
                if(state is getListLemburSuccessState || state is LoadMoreProgressState)
                  return Stack(
                    children: <Widget>[
                      ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          controller: _scrollController,
                          itemCount: state.data!.length,
                          itemBuilder: (BuildContext context, index) {
                            return CardLembur(state.data![index],'rekapSaya' ,scaffoldKey, widget.redaksional);
                          }
                      ),
                      state is LoadMoreProgressState? Positioned(
                          bottom :16,
                          child: Container(
                              width: MediaQuery.of(context).size.width,
                              child: Center(child: CircularProgressIndicator(strokeWidth: 8,)))):Container(),
                    ],
                  );
                else if(state is LemburProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
              }),
          Positioned(
            bottom: 16,
            right: 14,
            child: BlocListener<DateRangePickerBloc, DateRangePickerState>(
              listener: (BuildContext context, DateRangePickerState dateRangePickerState){
                if(dateRangePickerState is DateAvailable) BlocProvider.of<RekapLemburSayaBloc>(context).add(getListLemburEvent(context, ModelFilter(dateRange: dateRangePickerState.date)));
              },
              child: TemplateFilterToggle(),
            ),
          ),
        ],
      ),
    );
  }
}


