import 'package:absenkuv3/Bloc/CustomBloc.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiTeam/PengajuanKpiBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mGetDataKpi.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mListKpiTeam.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mPengajuanKpi.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class CardListKpi extends StatefulWidget {
  CardListKpi(this.data, this.cardnavigate);

  String cardnavigate;
  DataKpi data;

  @override
  State<CardListKpi> createState() => _CardListKpiState();
}

class _CardListKpiState extends State<CardListKpi> {
  // String? _selectedOption;
  String? _selectedOption;
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
        onTap: () {
          if (widget.data.status == '0' && widget.data.dataLampau == false) {
            BlocProvider.of<PengajuanKpiBloc>(context).add(PengajuanKpi(
                ModelPengajuanKpi(
                    widget.data.idKaryawan,
                    widget.data.bulan,
                    widget.data.tahun,
                    widget.data.idCompany), // Use selectedStartDate here
                context));
          } else if (widget.data.status == '0' &&
              widget.data.dataLampau == true) {
            showDialog(
              context: context,
              builder: (BuildContext ctx) {
                return AlertDialog(
                  contentPadding: EdgeInsets.zero,
                  shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.all(Radius.circular(10)),
                  ),
                  content: Column(
                    mainAxisSize: MainAxisSize.min,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        decoration: BoxDecoration(
                          borderRadius: BorderRadius.only(
                              topLeft: Radius.circular(10),
                              topRight: Radius.circular(10)),
                          color: Colors.indigo,
                        ),
                        height: 60,
                        width: MediaQuery.of(context).size.width,
                        child: Center(
                          child: Text("Set Planning",
                              style: TextStyle(
                                  color: Colors.white,
                                  fontWeight: FontWeight.bold)),
                        ),
                      ),
                      SizedBox(height: 10),
                      Container(
                        margin:
                            EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                        child: Text(
                            'Apakah Anda ingin menggunakan data bulan sebelumnya?'),
                      ),
                      StatefulBuilder(
                        builder: (BuildContext context, setState) {
                          return Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: [
                              Radio<String>(
                                value: '1',
                                groupValue: _selectedOption,
                                onChanged: (value) {
                                  setState(() {
                                    _selectedOption = value;
                                  });
                                },
                              ),
                              Text('Ya'),
                              SizedBox(width: 20),
                              Radio<String>(
                                value: '0',
                                groupValue: _selectedOption,
                                onChanged: (value) {
                                  setState(() {
                                    _selectedOption = value;
                                  });
                                },
                              ),
                              Text('Tidak'),
                            ],
                          );
                        },
                      ),
                    ],
                  ),
                  actions: [
                    TextButton(
                      onPressed: () {
                        Navigator.of(context).pop();
                      },
                      child: Text('Batal'),
                    ),
                    TextButton(
                      onPressed: () {
                        if (_selectedOption == '1') {
                          BlocProvider.of<PengajuanKpiBloc>(context).add(
                              PengajuanKpiWithDataLampau(
                                  ModelPengajuanKpi(
                                      widget.data.idKaryawan,
                                      widget.data.bulan,
                                      widget.data.tahun,
                                      widget.data
                                          .idCompany), // Use selectedStartDate here
                                  context));
                          Navigator.of(context).pop();
                        } else if (_selectedOption == '0') {
                          BlocProvider.of<PengajuanKpiBloc>(context).add(
                              PengajuanKpi(
                                  ModelPengajuanKpi(
                                      widget.data.idKaryawan,
                                      widget.data.bulan,
                                      widget.data.tahun,
                                      widget.data
                                          .idCompany), // Use selectedStartDate here
                                  context));
                          Navigator.of(context).pop();
                        }else{
                          showSnackBarDelayed(
                              scaffoldKey,
                              'Pilih Ya atau Tidak terlebih dahulu',
                              context);
                        }
                        // print(_selectedOption);
                      },
                      child: Text('Lanjutkan'),
                    ),
                  ],
                );
              },
            );

            // showDialog(
            //   context: context,
            //   builder: (BuildContext ctx) {
            //     return AlertDialog(
            //       contentPadding: EdgeInsets.zero,
            //       shape: RoundedRectangleBorder(
            //         borderRadius: BorderRadius.only(
            //             topLeft: Radius.circular(10),
            //             topRight: Radius.circular(10),
            //             bottomLeft: Radius.circular(10),
            //             bottomRight: Radius.circular(10)),
            //       ),
            //       content: Column(
            //         mainAxisSize: MainAxisSize.min,
            //         crossAxisAlignment: CrossAxisAlignment.start,
            //         children: [
            //           Container(
            //             decoration: BoxDecoration(
            //               borderRadius: BorderRadius.only(
            //                   topLeft: Radius.circular(10),
            //                   topRight: Radius.circular(10)),
            //               color: Colors.indigo,
            //             ),
            //             height: 60,
            //             width: MediaQuery.of(context).size.width,
            //             child: Center(
            //               child: Text("Set Planning",
            //                   style: TextStyle(
            //                       color: Colors.white,
            //                       fontWeight: FontWeight.bold)),
            //             ),
            //           ),
            //           SizedBox(
            //             height: 10,
            //           ),
            //           Container(
            //             margin:
            //                 EdgeInsets.symmetric(vertical: 10, horizontal: 10),
            //             child: Container(
            //               margin: EdgeInsets.only(left: 10),
            //               child: Text(
            //                   'Apakah Anda ingin menggunakan data bulan sebelumnya?'),
            //             ),
            //           ),
            //           Row(
            //             mainAxisAlignment: MainAxisAlignment.start,
            //             children: [
            //               Radio<String>(
            //                 value: 'Ya',
            //                 groupValue: _selectedOption,
            //                 onChanged: (value) {
            //                   setState(() {
            //                     _selectedOption = value;
            //                   });
            //                 },
            //               ),
            //               Text('Ya'),
            //               SizedBox(width: 20), // Space between radio buttons
            //               Radio<String>(
            //                 value: 'Tidak',
            //                 groupValue: _selectedOption,
            //                 onChanged: (value) {
            //                   setState(() {
            //                     _selectedOption = value;
            //                   });
            //                 },
            //               ),
            //               Text('Tidak'),
            //             ],
            //           ),
            //         ],
            //       ),
            //       // title: Text('Set Planning'),
            //       // content:
            //       //     Text('Apakah anda ingin menggunakan data bulan sebelumnya?'),
            //       // actions: <Widget>[
            //       //   TextButton(
            //       //     child: Text('CANCEL'),
            //       //     onPressed: () {
            //       //       Navigator.of(context).pop(); // Tutup dialog
            //       //     },
            //       //   ),
            //       //   TextButton(
            //       //     child: Text('TIDAK'),
            //       //     onPressed: () {
            //       //       BlocProvider.of<PengajuanKpiBloc>(context).add(
            //       //           PengajuanKpi(
            //       //               ModelPengajuanKpi(
            //       //                   widget.data.idKaryawan,
            //       //                   widget.data.bulan,
            //       //                   widget.data.tahun,
            //       //                   widget.data
            //       //                       .idCompany), // Use selectedStartDate here
            //       //               context));
            //       //       Navigator.of(context).pop(); // Tutup dialog
            //       //     },
            //       //   ),
            //       //   TextButton(
            //       //     child: Text('YA'),
            //       //     onPressed: () {
            //       //       BlocProvider.of<PengajuanKpiBloc>(context).add(
            //       //           PengajuanKpiWithDataLampau(
            //       //               ModelPengajuanKpi(
            //       //                   widget.data.idKaryawan,
            //       //                   widget.data.bulan,
            //       //                   widget.data.tahun,
            //       //                   widget.data
            //       //                       .idCompany), // Use selectedStartDate here
            //       //               context));
            //       //       Navigator.of(context).pop(); // Tutup dialog setelah menghapus
            //       //     },
            //       //   ),
            //       // ],
            //       actions: [
            //         TextButton(
            //           onPressed: () {
            //             print(_selectedOption);
            //           },
            //           child: Text('OK'),
            //         ),
            //       ],
            //     );
            //   },
            // );
          } else {
            BlocProvider.of<NavigatorBloc>(context)
                .add(NavigateToHalamanPengajuanKpiTeam(context, [
              widget.data.idKaryawan,
              widget.data.idCompany,
              widget.data.bulan,
              widget.data.tahun
            ]));
          }
          // BlocProvider.of<NavigatorBloc>(context)
          //     .add(NavigateToHalamanPengajuanKpiTeam(context, [
          //   widget.data.idKaryawan,
          //   widget.data.idCompany,
          //   widget.data.bulan,
          //   widget.data.tahun
          // ]));
          // BlocProvider.of<PengajuanKpiBloc>(context).add(PengajuanKpi(
          //     ModelPengajuanKpi(
          //         widget.data.idKaryawan,
          //         widget.data.bulan,
          //         widget.data.tahun,
          //         widget.data.idCompany), // Use selectedStartDate here
          //     context));
        },
        child: Container(
          decoration: BoxDecoration(
              // color: Color(int.parse(widget.dataLembur.warna!)),
              color: Colors.blue,
              borderRadius:
                  BorderRadius.all(Radius.circular(CustomStyle.cardRadius))),
          margin: EdgeInsets.only(top: 12, left: 12, right: 12),
          padding: EdgeInsets.only(left: 5),
          child: Column(
            children: [
              Container(
                decoration: CustomStyle.boxDecoration2,
                child: Column(
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        const SizedBox(
                          width: 12,
                        ),
                        Expanded(
                          flex: 1,
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              Text(widget.data.tahun.toString(),
                                  style: TextStyle(
                                      fontSize: 14,
                                      color: CustomStyle.fontColorGrey,
                                      fontWeight: FontWeight.w400)),
                              SizedBox(
                                height: 6,
                              ),
                              Text(
                                '${getMonthName(int.parse(widget.data.bulan.toString()))}',
                                style: TextStyle(
                                    fontSize: 16, fontWeight: FontWeight.w600),
                              ),
                            ],
                          ),
                        ),
                        VDivider(),
                        Expanded(
                          flex: 8,
                          child: Container(
                            width: MediaQuery.of(context).size.width,
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Expanded(
                                    child: Container(
                                  child: Text(widget.data.nama.toString()),
                                )),
                                // widget.cardnavigate == 'pengajuan'
                                //     ? Container()
                                //     :
                                Container(
                                  decoration: BoxDecoration(
                                    color: Color(
                                            widget.cardnavigate == 'pengajuan'
                                                ? 0XFF2F318B
                                                : int.parse(
                                                    widget.data.jenisColor!))
                                        .withOpacity(0.2),
                                    borderRadius: BorderRadius.all(
                                        Radius.circular(
                                            CustomStyle.cardRadius)),
                                  ),
                                  margin: EdgeInsets.all(10),
                                  padding: EdgeInsets.all(
                                      5), // Ganti padding menjadi all untuk menjaga keseimbangan
                                  child: Center(
                                    // Center sudah benar
                                    child: Text(
                                      widget.cardnavigate == 'pengajuan'
                                          ? 'Publish'
                                          : widget.data.jenis.toString(),
                                      textAlign: TextAlign
                                          .center, // Tambahkan ini untuk memastikan teks di pusat
                                      style: TextStyle(
                                        color: Color(
                                            widget.cardnavigate == 'pengajuan'
                                                ? 0XFF2F318B
                                                : int.parse(
                                                    widget.data.jenisColor!)),
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
              ),
            ],
          ),
        ));
  }
}

class CardListKpiTeam extends StatefulWidget {
  CardListKpiTeam(this.data, this.cardnavigate);

  String cardnavigate;
  DataKpiTeam data;

  @override
  State<CardListKpiTeam> createState() => _CardListKpiTeamState();
}

class _CardListKpiTeamState extends State<CardListKpiTeam> {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
        onTap: () {
          if (widget.cardnavigate == 'draft') {
            BlocProvider.of<NavigatorBloc>(context)
                .add(NavigateToHalamanPengajuanKpiTeam(context, [
              widget.data.idKaryawan,
              widget.data.idCompany,
              widget.data.bulan,
              widget.data.tahun
            ]));
          } else if (widget.cardnavigate == 'approval') {
            BlocProvider.of<NavigatorBloc>(context)
                .add(NavigateToHalamanPengajuanKpiApprovalTeam(context, [
              widget.data.idKaryawan,
              widget.data.idCompany,
              widget.data.bulan,
              widget.data.tahun,
              widget.data.namaLengkap
            ]));
          } else if (widget.cardnavigate == 'pengajuan') {
            BlocProvider.of<NavigatorBloc>(context)
                .add(NavigateToHalamanDetailPengajuanKpiSaya(context, [
              widget.data.idKaryawan,
              widget.data.idCompany,
              widget.data.bulan,
              widget.data.tahun,
              widget.data.namaLengkap
            ]));
          } else if (widget.cardnavigate == 'approved') {
            BlocProvider.of<NavigatorBloc>(context)
                .add(NavigateToHalamanDetailApprovedKpi(context, [
              widget.data.idKaryawan,
              widget.data.idCompany,
              widget.data.bulan,
              widget.data.tahun,
              widget.data.namaLengkap,
              widget.data.status
            ]));
          }
        },
        child: Container(
          decoration: BoxDecoration(
              // color: Color(int.parse(widget.dataLembur.warna!)),
              color: Colors.blue,
              borderRadius:
                  BorderRadius.all(Radius.circular(CustomStyle.cardRadius))),
          margin: EdgeInsets.only(top: 12, left: 12, right: 12),
          padding: EdgeInsets.only(left: 5),
          child: Column(
            children: [
              Container(
                decoration: CustomStyle.boxDecoration2,
                child: Column(
                  children: [
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        const SizedBox(
                          width: 12,
                        ),
                        Expanded(
                          flex: 1,
                          child: Column(
                            crossAxisAlignment: CrossAxisAlignment.center,
                            children: [
                              Text(widget.data.tahun.toString(),
                                  style: TextStyle(
                                      fontSize: 14,
                                      color: CustomStyle.fontColorGrey,
                                      fontWeight: FontWeight.w400)),
                              SizedBox(
                                height: 6,
                              ),
                              Text(
                                '${getMonthName(widget.data.bulan!)}',
                                style: TextStyle(
                                    fontSize: 16, fontWeight: FontWeight.w600),
                              ),
                            ],
                          ),
                        ),
                        VDivider(),
                        Expanded(
                          flex: 8,
                          child: Container(
                            width: MediaQuery.of(context).size.width,
                            child: Row(
                              crossAxisAlignment: CrossAxisAlignment.center,
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Expanded(
                                    child: Container(
                                  child:
                                      Text(widget.data.namaLengkap.toString()),
                                )),
                                // widget.cardnavigate == 'pengajuan'
                                //     ? Container()
                                //     :
                                Container(
                                  decoration: BoxDecoration(
                                    color: Color(
                                            widget.cardnavigate == 'pengajuan'
                                                ? 0XFF2F318B
                                                : int.parse(
                                                    widget.data.jenisColor!))
                                        .withOpacity(0.2),
                                    borderRadius: BorderRadius.all(
                                        Radius.circular(
                                            CustomStyle.cardRadius)),
                                  ),
                                  margin: EdgeInsets.all(10),
                                  padding: EdgeInsets.all(
                                      5), // Ganti padding menjadi all untuk menjaga keseimbangan
                                  child: Center(
                                    // Center sudah benar
                                    child: Text(
                                      widget.cardnavigate == 'pengajuan'
                                          ? 'Publish'
                                          : widget.data.jenis.toString(),
                                      textAlign: TextAlign
                                          .center, // Tambahkan ini untuk memastikan teks di pusat
                                      style: TextStyle(
                                        color: Color(
                                            widget.cardnavigate == 'pengajuan'
                                                ? 0XFF2F318B
                                                : int.parse(
                                                    widget.data.jenisColor!)),
                                      ),
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
              ),
            ],
          ),
        ));
  }
}

class VDivider extends StatelessWidget {
  const VDivider({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 60,
      margin: EdgeInsets.symmetric(horizontal: 12),
      decoration: BoxDecoration(
        border: Border(
          right: BorderSide(
            color: Theme.of(context).dividerColor,
            width: 2,
          ),
        ),
      ),
    );
  }
}

String getMonthName(int monthNumber) {
  const List<String> monthNames = [
    'Jan',
    'Feb',
    'Mar',
    'Apr',
    'May',
    'Jun',
    'Jul',
    'Aug',
    'Sep',
    'Oct',
    'Nov',
    'Dec'
  ];

  if (monthNumber < 1 || monthNumber > 12) {
    return 'Bulan tidak valid';
  }

  return monthNames[monthNumber - 1];
}
