// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables

import 'package:absenkuv3/Bloc/Kpi/KpiTeam/GetDataPengajuanKpiTeamBloc.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiTeam/PublishkpiTeamBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiTeam/komponen/KomponenKpiPengajuanTeam.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiTeam/komponen/KomponenKpiTeam.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanPengajuanKpiTeam extends StatefulWidget {
  HalamanPengajuanKpiTeam(this.data);

  var data;

  @override
  State<HalamanPengajuanKpiTeam> createState() =>
      _HalamanPengajuanKpiTeamState();
}

class _HalamanPengajuanKpiTeamState extends State<HalamanPengajuanKpiTeam> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();

  @override
  void initState() {
    BlocProvider.of<GetDataPengajuanKpiTeamBloc>(context).add(
        GetDataPegajuanKpiTeam(context, widget.data![0], widget.data![1],
            widget.data![2], widget.data![3]));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        flexibleSpace: Image(
          image: AssetImage(ValueImage.headerBiruDashboard),
          fit: BoxFit.cover,
        ),
        backgroundColor: Colors.transparent,
        centerTitle: true,
        title: Text(
          'KPI',
          style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
        ),
      ),
      body: Stack(
        children: [
          BlocBuilder<GetDataPengajuanKpiTeamBloc,
              GetDataPengajuanKpiTeamState>(
            builder:
                (BuildContext ctkteam, GetDataPengajuanKpiTeamState state) {
              if (state is GetDataPengajuanKpiTeamSuccessState) {
                return Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Container(
                      padding:
                          EdgeInsets.symmetric(vertical: 15, horizontal: 15),
                      margin: EdgeInsets.only(left: 5),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text("Periode KPI"),
                              SizedBox(
                                height: 3,
                              ),
                              Text(
                                "${getMonthName(widget.data[2])} ${widget.data[3]}",
                                style: TextStyle(fontWeight: FontWeight.bold,fontSize: 16),
                              ),
                            ],
                          ),
                          SizedBox(
                            height: 3,
                          ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Text("Nama Karyawan"),
                              SizedBox(
                                height: 3,
                              ),
                              Text(state.data!.namaLengkap.toString(),
                                  style:
                                      TextStyle(fontWeight: FontWeight.bold,fontSize: 16)),
                            ],
                          )
                        ],
                      ),
                    ),
                    
                    Container(
                      margin: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                      padding:
                          EdgeInsets.symmetric(horizontal: 15, vertical: 15),
                      decoration: BoxDecoration(
                          color: Color(0xfff0f3fa),
                          borderRadius: BorderRadius.circular(10)),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text("Total bobot yang harus diisi"),
                          Text(state.data!.masterBobot.toString(),
                              style: TextStyle(fontWeight: FontWeight.bold)),
                        ],
                      ),
                    ),
                    Container(
                      margin: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                      padding:
                          EdgeInsets.symmetric(horizontal: 15, vertical: 15),
                      decoration: BoxDecoration(
                          color: Color(0xfff0f3fa),
                          borderRadius: BorderRadius.circular(10)),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text("Total bobot yang sudah diisi"),
                          Text(state.data!.bobot.toString(),
                              style: TextStyle(fontWeight: FontWeight.bold)),
                        ],
                      ),
                    ),
                    Divider(
                      thickness: 15,
                    ),
                    Expanded(
                      child: ListView.builder(
                        padding: EdgeInsets.only(
                            top: 10,
                            bottom:
                                70), // Add padding to avoid overlap with the button
                        physics: AlwaysScrollableScrollPhysics(),
                        itemCount: state.data!.list!.length,
                        itemBuilder: (BuildContext ctk, index) {
                          return KomponenCardListPengajuanKpiTeam(
                            state.data!.list![index],
                            ParsingModelKaryawan(
                              karyawan: widget.data![0],
                              id_company: widget.data![1],
                              bulan: widget.data![2],
                              tahun: widget.data![3],
                            ),
                            scaffoldKey,
                            context,
                          );
                        },
                      ),
                    ),
                  ],
                );
              } else if (state is DataPengajuanKpiTeamProgressState) {
                return Center(
                  child: CircularProgressIndicator(
                    strokeWidth: 8,
                  ),
                );
              } else {
                return Center(
                  child: Image.asset(
                    ValueImage.noData,
                    height: 250,
                  ),
                );
              }
            },
          ),
          Positioned(
            bottom: 0,
            child: Container(
              width: MediaQuery.of(context).size.width,
              padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
              child: ElevatedButton(
                style: ElevatedButton.styleFrom(
                    backgroundColor: CustomStyle.color1,
                    foregroundColor: Colors.white,
                    minimumSize: Size(double.infinity, 50),
                    shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(10))),
                onPressed: () {
                  BlocProvider.of<PublishKpiTeamBloc>(context).add(
                    PublishKpiTeam(
                        ParsingModelKaryawan(
                            karyawan: widget.data[0],
                            id_company: widget.data[1],
                            bulan: widget.data[2],
                            tahun: widget.data[3]),
                        context),
                  );
                },
                child: const Text("Publish ke Team"),
              ),
            ),
          ),
        
        ],
      ),
    );
  }
}
