import 'package:absenkuv3/Bloc/Kpi/KpiSaya/GetDataPengajuanKpiSayaBloc.dart';
import 'package:absenkuv3/Bloc/Kpi/KpiTeam/GetDataPengajuanKpiTeamBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/NotifBloc.dart';
import 'package:absenkuv3/Repository/Model/Kpi/KpiTeam/mDataPengajuanKpi.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Kpi/KpiSaya/komponen/KomponenPengajuanSaya.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanPengajuanKpiSaya extends StatefulWidget {
  var data;

  HalamanPengajuanKpiSaya(this.data);

  @override
  State<HalamanPengajuanKpiSaya> createState() =>
      _HalamanPengajuanKpiSayaState();
}

class _HalamanPengajuanKpiSayaState extends State<HalamanPengajuanKpiSaya> {
  bool refresh = false;
  @override
  void initState() {
    BlocProvider.of<GetDataPengajuanKpiSayaBloc>(context).add(
        GetDataPegajuanKpiSaya(context, widget.data![0], widget.data![1],
            widget.data![2], widget.data![3]));
    BlocProvider.of<NotifBloc>(context).add(BacaNotifNotifKpi(
      widget.data[0],
      widget.data[1],
      widget.data[2],
      widget.data[3],
      '6',
    ));
    super.initState();
  }

  Future<bool> keluar2() async {
    // Ensure there are sufficient elements
    if (widget.data.length > 5) {
      print("Data at index 5: ${widget.data[5]}");
      if (widget.data[5] == 'notif') {
        Navigator.pop(context, refresh);
      } else {
        BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
      }
    } else {
      BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
    }
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
        onWillPop: keluar2,
        child: BlocListener<NotifBloc, NotifState>(
          listener: (context, stateNotifBloc) {
            if (stateNotifBloc is SuccessBacaNotifState) {
              refresh = true;
            }
          },
          child: Scaffold(
              appBar: AppBar(
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
                centerTitle: true,
                title: Text(
                  'Actual KPI',
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                ),
              ),
              body: BlocBuilder<GetDataPengajuanKpiSayaBloc,
                      GetDataPengajuanKpiSayaState>(
                  builder:
                      (BuildContext ctk, GetDataPengajuanKpiSayaState state) {
                if (state is GetDataPengajuanKpiSayaSuccessState) {
                  return KomponenPengajuanSaya(
                      state.data!,
                      ParsingModelKaryawan(
                        id_karyawan: widget.data[0],
                        id_company: widget.data[1],
                        bulan: widget.data[2],
                        tahun: widget.data[3],
                        karyawan: widget.data[4],
                      ));
                } else if (state is DataPengajuanKpiSayaProgressState)
                  return Center(
                    child: CircularProgressIndicator(
                      strokeWidth: 8,
                    ),
                  );
                else
                  return Center(
                    child: Image.asset(
                      ValueImage.noData,
                      height: 250,
                    ),
                  );
              })),
        ));
  }
}
