// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables

import 'package:absenkuv3/Repository/Model/Kpi/KpiApproval/mDataNilaiIndividu.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
// import 'package:google_fonts/google_fonts.dart';

class KomponenTabelNilai extends StatelessWidget {
  final InformasiSkor data;
  const KomponenTabelNilai(this.data);

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(16.0),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Table(
            children: [
              TableRow(
                decoration: BoxDecoration(
                  color: CustomStyle.color1,
                  borderRadius: BorderRadius.only(
                    topLeft: Radius.circular(10),
                    topRight: Radius.circular(10),
                  ),
                ),
                children: [
                  TableCell(
                    child: Center(
                      child: Container(
                        margin: EdgeInsets.all(13),
                        child: Text(
                          'PERSONAL SCORE',
                          // style: TextStyle(color: Colors.white),
                          style: TextStyle(
                              // fontSize: 10,
                              fontWeight: FontWeight.bold,
                              color: Colors.white),
                        ),
                      ),
                    ),
                  ),
                ],
              ),
            ],
          ),
          Table(
            border: TableBorder.all(
              color: Colors.grey,
              width: 0.5,
              borderRadius: BorderRadius.only(),
            ),
            columnWidths: {
              1: FixedColumnWidth(70),
              2: FixedColumnWidth(70),
              3: FixedColumnWidth(70),
            },
            children: [
              TableRow(children: [
                TableCell(
                  child: Container(
                    color: Color(0xffF2F2F7), // Warna background
                    width: 50,
                    height: 50,
                    child: Center(
                      child: Text(
                        'KETERANGAN',
                        style: TextStyle(fontWeight: FontWeight.bold),
                        textAlign:
                            TextAlign.center, // Menyelaraskan teks di tengah
                      ),
                    ),
                  ),
                ),
                TableCell(
                  child: Container(
                    color: Color(0xffF2F2F7), // Warna background
                    width: 50,
                    height: 50,
                    child: Center(
                      child: Text(
                        'AKTUAL',
                        style: TextStyle(fontWeight: FontWeight.bold),
                        textAlign:
                            TextAlign.center, // Menyelaraskan teks di tengah
                      ),
                    ),
                  ),
                ),
                TableCell(
                  child: Container(
                    color: Color(0xffF2F2F7), // Warna background
                    width: 50,
                    height: 50,
                    child: Center(
                      child: Text(
                        'BOBOT',
                        style: TextStyle(fontWeight: FontWeight.bold),
                        textAlign:
                            TextAlign.center, // Menyelaraskan teks di tengah
                      ),
                    ),
                  ),
                ),
                TableCell(
                  child: Container(
                    color: Color(0xffF2F2F7), // Warna background
                    width: 50,
                    height: 50,
                    child: Center(
                      child: Text(
                        'SKOR',
                        style: TextStyle(fontWeight: FontWeight.bold),
                        textAlign:
                            TextAlign.center, // Menyelaraskan teks di tengah
                      ),
                    ),
                  ),
                ),
              ])
            ],
          ),
          KomponenTabel(
            title: data.aspekKinerjaNm.toString(),
            aktual: data.apsekKinerjaAktual.toString(),
            bobot: data.aspekKinerjaBobot.toString(),
            value: data.aspekKinerjaSkor.toString(),
          ),
          KomponenTabel(
            title: data.aspekKepribadianNm.toString(),
            aktual: data.aspekKepribadianAktual.toString(),
            bobot: data.aspekKepribadianBobot.toString(),
            value: data.aspekKepribadianSkor.toString(),
          ),
          KomponenTabel(
            title: data.aspekKedisiplinanNm.toString(),
            aktual: data.aspekKedisiplinanAktual.toString(),
            bobot: data.aspekKedisiplinanBobot.toString(),
            value: data.aspekKedisiplinanSkor.toString(),
          ),
          Table(
            border: TableBorder.all(
              color: Colors.grey,
              width: 0.5,
              borderRadius: BorderRadius.only(),
            ),
            columnWidths: {
              1: FixedColumnWidth(70),
            },
            children: [
              TableRow(children: [
                TableCell(
                    child: Container(
                  margin: EdgeInsets.all(15),
                  child: Center(
                    child: Text(
                      "TOTAL SKOR",
                      style: TextStyle(fontWeight: FontWeight.w600),
                    ),
                  ),
                )),
                TableCell(
                    child: Center(
                  child: Container(
                    margin: EdgeInsets.all(15),
                    child: Text(
                      data.totalNilai.toString(),
                      style: TextStyle(fontWeight: FontWeight.w600),
                    ),
                  ),
                )),
              ])
            ],
          ),
          Table(
            border: TableBorder.all(
              color: Colors.grey,
              width: 0.5,
              borderRadius: BorderRadius.only(),
            ),
            children: [
              TableRow(children: [
                TableCell(
                    child: Center(
                  child: Container(
                    margin: EdgeInsets.all(15),
                    child: Text(
                      'Predikat ${data.predikat} = ${data.remark}',
                      style: TextStyle(fontWeight: FontWeight.w600),
                    ),
                  ),
                )),
              ])
            ],
          )
        ],
      ),
    );
  }
}

class KomponenTabel extends StatelessWidget {
  String title;
  String value;
  String aktual;
  String bobot;
  KomponenTabel({required this.title, required this.value,required this.aktual,required this.bobot});

  @override
  Widget build(BuildContext context) {
    return Table(
      border: TableBorder.all(
        color: Colors.grey,
        width: 0.5,
        borderRadius: BorderRadius.only(),
      ),
      columnWidths: {
        1: FixedColumnWidth(70),
        2: FixedColumnWidth(70),
        3: FixedColumnWidth(70),
      },
      children: [
        TableRow(children: [
          TableCell(
              child: Container(
            margin: EdgeInsets.all(15),
            child: Text(
              title,
              style: TextStyle(),
            ),
          )),
          TableCell(
              child: Container(
            margin: EdgeInsets.all(15),
            child: Center(
              child: Text(
                aktual,
                style: TextStyle(),
              ),
            ),
          )),
          TableCell(
            child: Container(
            margin: EdgeInsets.all(15),
            child: Center(
              child: Text(
                bobot,
                style: TextStyle(),
              ),
            ),
          )),
          TableCell(
              child: Center(
            child: Container(
              margin: EdgeInsets.all(15),
              child: Center(
                child: Text(
                  value,
                  style: TextStyle(),
                ),
              ),
            ),
          )),
        ])
      ],
    );
  }
}

class KomponenGrade extends StatelessWidget {
  List<InformasiGrade> data;
  KomponenGrade({required this.data});

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(16.0),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          // Column(
          //     children: data.map((e) => Text(e.batasAtas.toString())).toList())
          // Table(
          //   children: [
          //     TableRow(
          //         children: data
          //             .map((e) => TableCell(child: Text(e.grade.toString())))
          //             .toList())
          //   ],
          // )
          Table(
            border: TableBorder.all(
              color: Colors.grey,
              width: 0.5,
              borderRadius: BorderRadius.only(
                topLeft: Radius.circular(10),
                topRight: Radius.circular(10),
              ),
            ),
            columnWidths: {
              0: FixedColumnWidth(100),
              1: FixedColumnWidth(80),
            },
            defaultVerticalAlignment: TableCellVerticalAlignment.middle,
            children: [
              TableRow(
                decoration: BoxDecoration(
                  color: CustomStyle.color1,
                  boxShadow: [
                    BoxShadow(
                      color: Colors.grey.withOpacity(0.3),
                      spreadRadius: 2,
                      blurRadius: 5,
                      offset: Offset(0, 3),
                    )
                  ],
                  borderRadius: BorderRadius.only(
                    topLeft: Radius.circular(10),
                    topRight: Radius.circular(10),
                  ),
                ),
                children: [
                  TableCell(
                      child: Center(
                    child: Container(
                      margin: EdgeInsets.all(10),
                      child: Text(
                        'POIN',
                        style: TextStyle(
                            // fontSize: 10,
                            fontWeight: FontWeight.w600,
                            color: Colors.white),
                      ),
                    ),
                  )),
                  TableCell(
                    child: Center(
                      child: Container(
                        margin: EdgeInsets.all(13),
                        child: Text(
                          'GRADE',
                          style: TextStyle(
                              // fontSize: 10,
                              fontWeight: FontWeight.w600,
                              color: Colors.white),
                        ),
                      ),
                    ),
                  ),
                  TableCell(
                      child: Center(
                    child: Container(
                      margin: EdgeInsets.all(13),
                      child: Text(
                        'REMARK',
                        style: TextStyle(
                            // fontSize: 10,
                            fontWeight: FontWeight.w600,
                            color: Colors.white),
                      ),
                    ),
                  )),
                ],
              ),
              ...berRows(context, data),
            ],
          ),
        ],
      ),
    );
  }

  List<TableRow> berRows(BuildContext context, ber) {
    List<TableRow> rows = [];
    for (InformasiGrade skorData in ber ?? []) {
      TableRow row = TableRow(
        children: [
          TableCell(
            child: Container(
              color: Color(0xffF2F2F7),
              width: 40,
              height: 40,
              // margin: EdgeInsets.all(13),
              child: Center(
                  child: Text(
                      '${skorData.batasBawah} - ${skorData.batasAtas}' ?? '')),
            ),
            // ),
          ),
          TableCell(
            child: Container(
              color: Color(0xffF2F2F7),
              width: 40,
              height: 40,
              child: Center(
                child: Text(
                  skorData.grade.toString(),
                  style: TextStyle(color: Colors.black),
                ),
              ),
            ),
          ),
          TableCell(
            child: Container(
              color: Color(0xffF2F2F7),
              width: 40,
              height: 40,
              child: Center(
                child: Text(
                  '${skorData.keterangan}',
                  style: TextStyle(color: Colors.black),
                ),
              ),
            ),
          ),
        ],
      );
      rows.add(row);
    }
    return rows;
  }
}

class KomponenCatatan extends StatelessWidget {
  final InformasiCtt data;
  KomponenCatatan(this.data);

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(16.0),
      child: Container(
        decoration: BoxDecoration(
            borderRadius: BorderRadius.circular(20), color: Color(0xffF2F2F7)),
        width: MediaQuery.of(context).size.width,
        padding: EdgeInsets.all(10),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text('Catatan Exiting Role'),
            SizedBox(
              height: 5,
            ),
            Text(
              data.cttExitingRole.toString(),
              style: TextStyle(fontWeight: FontWeight.bold),
            ),
            SizedBox(
              height: 5,
            ),
            Text('Catatan Carrer Development'),
            SizedBox(
              height: 5,
            ),
            Text(
              data.cttCareerDevelopment.toString(),
              style: TextStyle(fontWeight: FontWeight.bold),
            ),
            SizedBox(
              height: 5,
            ),
            Text('Catatan Diterima'),
            SizedBox(
              height: 5,
            ),
            Text(
              data.cttDiterima.toString(),
              style: TextStyle(fontWeight: FontWeight.bold),
            ),
          ],
        ),
      ),
    );
  }
}

class KomponenInformasi extends StatelessWidget {
  final InformasiKomponen? data;
  KomponenInformasi(this.data);

  @override
  Widget build(BuildContext context) {
    return Padding(
        padding: const EdgeInsets.all(16.0),
        child: data?.button == false
            ? Container(
                decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(10),
                    border: Border.all(color: Colors.orange),
                    color: Color(0xffFFF8DB)),
                width: MediaQuery.of(context).size.width,
                padding: EdgeInsets.all(10),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    data?.perfomance != 0
                        ? Container(
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Text("Aspek Kinerja"),
                                Text(
                                    "${data?.perfomance.toString()} perspektif belum dinilai",
                                    style:
                                        TextStyle(fontWeight: FontWeight.bold)),
                              ],
                            ),
                          )
                        : Container(),
                    data?.perfomance != 0 && data?.kepribadian != 0
                        ? SizedBox(
                            height: 10,
                          )
                        : Container(),
                    data?.kepribadian != 0
                        ? Container(
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.spaceBetween,
                              children: [
                                Text("Kompetensi"),
                                Text(
                                    "${data?.kepribadian.toString()} kompetensi belum dinilai",
                                    style:
                                        TextStyle(fontWeight: FontWeight.bold)),
                              ],
                            ),
                          )
                        : Container()
                  ],
                ),
              )
            : Container());
  }
}

class KomponenPeriode extends StatelessWidget {
  final InformasiKomponen data;
  KomponenPeriode(this.data);

  @override
  Widget build(BuildContext context) {
    return Padding(
        padding: const EdgeInsets.all(16.0),
        child: Container(
          decoration: BoxDecoration(
              borderRadius: BorderRadius.circular(10), color: Colors.red),
          width: MediaQuery.of(context).size.width,
          padding: EdgeInsets.all(10),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text(
                data.ketPeriode.toString(),
                style: TextStyle(color: Colors.white),
              ),
            ],
          ),
        ));
  }
}
