import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/Koordinator/KoordinatorListBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class ParentTabKlienKoordinator extends StatefulWidget {
  @override
  State<ParentTabKlienKoordinator> createState() =>
      _ParentTabKlienKoordinatorState();
}

class _ParentTabKlienKoordinatorState extends State<ParentTabKlienKoordinator> {
  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context)
        .add(NavigateRemoveToDashboard(context));
    return false;
  }

  @override
  void initState() {
    BlocProvider.of<KoordinatorListBloc>(context)
        .add(getListKoordinatorListEvent(context, ModelFilter()));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<AuthBloc, LoginRespon>(
        builder: (BuildContext context, LoginRespon loginRespon) {
      return WillPopScope(
        onWillPop: keluar,
        child: Scaffold(
          appBar: AppBar(
            centerTitle: true,
            flexibleSpace: Image(
              image: AssetImage(ValueImage.headerBiruDashboard),
              fit: BoxFit.cover,
            ),
            backgroundColor: Colors.transparent,
            title: Text(
              'Klien Koordinator',
              style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
            ),
          ),
          body: Column(
            children: [
              SizedBox(height: 15),
              Align(
                alignment: Alignment.centerLeft,
                child: Padding(
                  padding: EdgeInsets.only(left: 17.0),
                  child: Text(
                    'Daftar Client',
                    style: TextStyle(
                      fontSize: 16,
                      fontWeight: FontWeight.w600,
                      color: Colors.black87,
                    ),
                  ),
                ),
              ),
              SizedBox(height: 15),
              BlocBuilder<KoordinatorListBloc, KoordinatorListState>(
                builder: (contextA, state) {
                  if (state is KoordinatorProgressState) {
                    return Container(
                      height: MediaQuery.of(context).size.height-180,
                      width: MediaQuery.of(context).size.width,
                      child: Center(
                        child: CircularProgressIndicator(
                          strokeWidth: 8,
                        ),
                      ),
                    );
                  } else if (state is koordinatorListSuccessState) {
                    return Expanded(
                      child: ListView.builder(
                          itemCount: state.data!.length,
                          itemBuilder: (contextA, index) {
                            final klien = state.data![index];
                            return Padding(
                              padding: const EdgeInsets.symmetric(
                                  horizontal: 16, vertical: 6),
                              child: ClientCard(
                                title: klien.nama!,
                                idKlien: klien.idKlien!,
                                jumlah: klien.jumlah!,
                                contextKoordinator: contextA,
                              ),
                            );
                          }),
                    );
                  } else if (state is KoordinatorErrorState) {
                    return Center(
                      child: Text('Error'),
                    );
                  } else {
                    return Center(
                      child: Image.asset(
                        ValueImage.noData,
                        height: 250,
                      ),
                    );
                  }
                },
              ),
            ],
          ),
        ),
      );
    });
  }
}

class ClientCard extends StatelessWidget {
  final String title;
  final String idKlien;
  final int jumlah;
  final BuildContext contextKoordinator;

  const ClientCard({
    super.key,
    required this.title,
    required this.idKlien,
    required this.jumlah,
    required this.contextKoordinator,
  });

  @override
  Widget build(BuildContext context) {
    return InkWell(
      onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
          NavigateToDashboardKlienKoordinator(
              context, [title, idKlien, contextKoordinator,'parent'])),
      child: Container(
        padding: const EdgeInsets.symmetric(horizontal: 20, vertical: 20),
        decoration: BoxDecoration(
          color: Colors.white,
          borderRadius: BorderRadius.circular(12),
          boxShadow: [
            BoxShadow(
              color: Colors.black.withOpacity(0.04),
              blurRadius: 6,
              offset: Offset(0, 4),
            ),
          ],
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Text(
              title,
              style: TextStyle(
              fontSize: CustomStyle.fontSizeSmall+1, fontWeight: FontWeight.bold),
            ),
            Row(
              children: [
                SizedBox(
                  width: 5,
                ),
                jumlah > 0
                    ? Container(
                        child: Center(
                          child: Text(
                            jumlah.toString(),
                            style: TextStyle(color: Colors.white),
                          ),
                        ),
                        decoration: new BoxDecoration(
                          color: Colors.red,
                          shape: BoxShape.circle,
                        ),
                        height: MediaQuery.of(context).size.width * 0.05,
                        width: MediaQuery.of(context).size.width * 0.05,
                      )
                    : Container(),
                Icon(Icons.arrow_forward_ios_rounded,
                    size: 18, color: CustomStyle.color1),
              ],
            ),
          ],
        ),
      ),
    );
  }
}
