// ignore_for_file: camel_case_types, prefer_typing_uninitialized_variables, must_be_immutable
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/MonitorAbsen/mMonitorAbsen.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mMonitorAbsenPage.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

class CardMonitorIzinAbsenKlien extends StatefulWidget {
  DataMonitorAbsen dataMonitorAbsen;
  PageMonitorAbsenModel redaksional;
  String idKlien;
  CardMonitorIzinAbsenKlien(
      this.dataMonitorAbsen, this.redaksional, this.idKlien);
  @override
  State<CardMonitorIzinAbsenKlien> createState() =>
      _CardMonitorIzinAbsenKlienState();
}

class _CardMonitorIzinAbsenKlienState extends State<CardMonitorIzinAbsenKlien> {
  @override
  Widget build(BuildContext context) {
    final menu = widget.redaksional.menuMonitorAbsensi!.data;
    return GestureDetector(
        onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
                NavigateToDetailIzinKlien(context, [
              widget.dataMonitorAbsen.idIzin,
              'izinPegawai',
              true,
              'komponen',
              widget.idKlien
            ])),
        child: Container(
          decoration: CustomStyle.boxDecoration2,
          margin: EdgeInsets.all(5),
          child: Padding(
            padding: EdgeInsets.all(10),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: <Widget>[
                Row(
                  children: [
                    Container(
                      padding: EdgeInsets.symmetric(horizontal: 8),
                      child: Row(
                        children: [
                          Column(
                            children: [
                              Text(
                                widget.dataMonitorAbsen.jumlahIzin.toString(),
                                style: TextStyle(
                                    fontSize: 16, fontWeight: FontWeight.w600),
                              ),
                              Text(
                                menu!.hari.toString(),
                                style: TextStyle(
                                    fontSize: 12,
                                    fontWeight: FontWeight.w400,
                                    color: CustomStyle.fontColorGrey),
                              )
                            ],
                          ),
                          VDivider(),
                        ],
                      ),
                    ),
                    Expanded(
                        child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          widget.dataMonitorAbsen.namaKaryawan.toString(),
                          style: TextStyle(
                              fontSize: 13, fontWeight: FontWeight.w600),
                        ),
                        SizedBox(
                          height: 4,
                        ),
                        Row(
                          children: [
                            TemplateButton(
                              label: widget.dataMonitorAbsen.jenisIzin!,
                              color: Color(int.parse(
                                  widget.dataMonitorAbsen.warnaBgIzin!)),
                              contentColor: Color(int.parse(
                                  widget.dataMonitorAbsen.warnaFontIzin!)),
                              fontSize: 10,
                              radius: 2,
                              paddingTopBottom: 4,
                              heightButton: 30,
                              bold: true,
                              paddingLeftRight: 4,
                            ),
                            SizedBox(
                              width: 8,
                            ),
                            Text(widget.dataMonitorAbsen.ketIzin!,
                                style: TextStyle(
                                    fontSize: 12,
                                    fontWeight: FontWeight.w400,
                                    color: Colors.grey)),
                          ],
                        )
                      ],
                    ))
                  ],
                ),
                Divider(
                  thickness: 2,
                ),
                SizedBox(
                  height: 8,
                ),
                Row(
                  children: [
                    Text(
                      "${menu.tanggalPengajuan} :",
                      style: TextStyle(
                          fontSize: 12,
                          color: CustomStyle.fontColorGrey,
                          fontWeight: FontWeight.w400),
                    ),
                    Text(
                      widget.dataMonitorAbsen.tglPengajuan!,
                      style:
                          TextStyle(fontSize: 12, fontWeight: FontWeight.w600),
                    ),
                  ],
                ),
                Row(
                  children: [
                    Text(
                      "${menu.periode} : ",
                      style: TextStyle(
                          fontSize: 12,
                          color: CustomStyle.fontColorGrey,
                          fontWeight: FontWeight.w400),
                    ),
                    Text(
                      widget.dataMonitorAbsen.tglIzin!,
                      style:
                          TextStyle(fontSize: 12, fontWeight: FontWeight.w600),
                    ),
                  ],
                ),
              ],
            ),
          ),
        ));
  }
}

class VDivider extends StatelessWidget {
  const VDivider({
    super.key,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 50,
      margin: EdgeInsets.symmetric(horizontal: 12),
      decoration: BoxDecoration(
        border: Border(
          right: BorderSide(
            color: Theme.of(context).dividerColor,
            width: 2,
          ),
        ),
      ),
    );
  }
}

class CardMonitorIzinAbsenKlienV2 extends StatefulWidget {
  DataMonitorAbsen dataMonitorAbsen;
  PageMonitorAbsenModel redaksional;
  CardMonitorIzinAbsenKlienV2(this.dataMonitorAbsen, this.redaksional);
  @override
  State<CardMonitorIzinAbsenKlienV2> createState() =>
      _CardMonitorIzinAbsenKlienStateV2();
}

class _CardMonitorIzinAbsenKlienStateV2
    extends State<CardMonitorIzinAbsenKlienV2> {
  @override
  Widget build(BuildContext context) {
    String tgl = widget.dataMonitorAbsen.tglAbsensi!;
    DateTime dateTime = DateTime.parse(tgl);
    return GestureDetector(
        onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
            NavigateToDetailIzin(context,
                [widget.dataMonitorAbsen.idIzin, 'izin', true, 'komponen'])),
        child: Container(
          decoration: BoxDecoration(
              color: Color(int.parse(widget.dataMonitorAbsen.warnaBgIzin!)),
              borderRadius:
                  BorderRadius.all(Radius.circular(CustomStyle.cardRadius))),
          margin: EdgeInsets.only(top: 12, left: 12, right: 12),
          padding: EdgeInsets.only(left: 5),
          child: Container(
            decoration: CustomStyle.boxDecoration2,
            child: Padding(
              padding: EdgeInsets.all(10),
              child: Column(
                children: <Widget>[
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      Container(
                        padding: EdgeInsets.symmetric(horizontal: 8),
                        child: Row(
                          children: [
                            Column(
                              children: [
                                Text(DateFormat('dd').format(dateTime),
                                    style: TextStyle(
                                        fontSize: 16,
                                        fontWeight: FontWeight.w600)),
                                SizedBox(
                                  height: 6,
                                ),
                                Text(
                                  DateFormat.MMM(widget.redaksional
                                          .menuMonitorAbsensi!.locale)
                                      .format(dateTime),
                                  style: TextStyle(
                                      fontSize: 14,
                                      color: CustomStyle.fontColorGrey,
                                      fontWeight: FontWeight.w400),
                                ),
                              ],
                            ),
                            Container(
                              height: 30,
                              margin: EdgeInsets.symmetric(horizontal: 10),
                              decoration: BoxDecoration(
                                border: Border(
                                  right: BorderSide(
                                    color: Theme.of(context).dividerColor,
                                    width: 2,
                                  ),
                                ),
                              ),
                            )
                          ],
                        ),
                      ),
                      Expanded(
                          child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Row(
                            children: [
                              Flexible(
                                  child: Container(
                                padding: EdgeInsets.symmetric(
                                    horizontal: 10, vertical: 5),
                                decoration: BoxDecoration(
                                  borderRadius: BorderRadius.circular(8),
                                  color: Color(int.parse(
                                      widget.dataMonitorAbsen.warnaBgIzin!)),
                                ),
                                child: Text(widget.dataMonitorAbsen.jenisIzin!,
                                    style: TextStyle(
                                        color: Color(int.parse(widget
                                            .dataMonitorAbsen
                                            .warnaFontIzin!)))),
                              )),
                              SizedBox(
                                width: 8,
                              ),
                              Flexible(
                                child: Text(widget.dataMonitorAbsen.ketIzin!,
                                    style: TextStyle(
                                        fontSize: 12,
                                        fontWeight: FontWeight.w400,
                                        color: Colors.grey)),
                              )
                            ],
                          )
                        ],
                      )),
                      Icon(
                        Icons.arrow_forward_ios,
                        color: CustomStyle.color1,
                        size: 21,
                      ),
                    ],
                  ),
                ],
              ),
            ),
          ),
        ));
  }
}
