// ignore_for_file: must_be_immutable

import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mIzinPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/KlienKoordinator/Izin/HalamanListIzinPegawai.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class ParentTabIzinKlien extends StatefulWidget {
  var idKlien;
  ParentTabIzinKlien({required this.idKlien});
  @override
  State<ParentTabIzinKlien> createState() => _ParentTabIzinKlienState();
}

class _ParentTabIzinKlienState extends State<ParentTabIzinKlien> {
  final int tabLength = 2;

  Future<bool> keluar() async {
    BlocProvider.of<NavigatorBloc>(context).add(NavigatePop(context));
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageIzinModel>(
        future: PengaturanBahasa().izin(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return BlocBuilder<AuthBloc, LoginRespon>(
                builder: (BuildContext context, LoginRespon loginRespon) {
              return WillPopScope(
                onWillPop: keluar,
                child: Scaffold(
                  appBar: AppBar(
                    centerTitle: true,
                    flexibleSpace: Image(
                      image: AssetImage(ValueImage.headerBiruDashboard),
                      fit: BoxFit.cover,
                    ),
                    backgroundColor: Colors.transparent,
                    title: Text(
                      snapshot.data!.menuIzin!.title!.titleIzin!,
                      style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                    ),
                  ),
                  body: HalamanListIzinPegawaiKlien(snapshot.data,
                      widget.idKlien[0], widget.idKlien[1], widget.idKlien[2]),
                ),
              );
            });
          } else {
            return CircularProgressIndicator(strokeWidth: 8);
          }
        });
  }
}
