import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mAktivitasPage.dart';
import 'package:absenkuv3/Repository/Model/mAktivitas.dart';
import 'package:absenkuv3/Repository/Model/mLaporanKinerja.dart';
import 'package:absenkuv3/UI/Template/halamanDetailMap.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/verticalDivider.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class CardLaporanKinerja extends StatefulWidget {
  final DataLaporanKinerja dataAktivitas;
  final GlobalKey<ScaffoldState> scaffoldKey;
  final String konteks;
  final PageAktivitasModel redaksional;
  CardLaporanKinerja(
      this.dataAktivitas, this.scaffoldKey, this.konteks, this.redaksional);

  @override
  _CardLaporanKinerjaState createState() => _CardLaporanKinerjaState();
}

class _CardLaporanKinerjaState extends State<CardLaporanKinerja> {
  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
          NavigateToDetailAktivitas(context, widget.dataAktivitas.idAktivitas)),
      child: Container(
        decoration: CustomStyle.boxDecoration,
        // padding: EdgeInsets.all(14),
        margin: EdgeInsets.only(top: 12, left: 17, right: 17),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Container(
              margin: EdgeInsetsDirectional.only(top: 10),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Container(
                    margin: EdgeInsetsDirectional.symmetric(
                        vertical: 5, horizontal: 15),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text('Tanggal', style: TextStyle(color: Colors.grey)),
                        SizedBox(
                          height: 10,
                        ),
                        Text(widget.dataAktivitas.tanggalRaw!,
                            style: TextStyle(fontWeight: FontWeight.bold)),
                      ],
                    ),
                  ),
                  Container(
                    margin: EdgeInsetsDirectional.symmetric(
                        vertical: 5, horizontal: 15),
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(15),
                        color: Colors.indigo),
                    padding: EdgeInsets.all(8),
                    child: Text(
                      widget.dataAktivitas.waktu!,
                      style: TextStyle(
                          color: Colors.white, fontWeight: FontWeight.bold),
                    ),
                  )
                ],
              ),
            ),
            SizedBox(
              height: 6,
            ),
            DashedLine(height: 1, color: Colors.grey, dashWidth: 6, dashSpace: 4),
            SizedBox(
              height: 10,
            ),
            Container(
              margin: EdgeInsets.symmetric(vertical: 0, horizontal: 10),
              child: Row(
                children: [
                  Expanded(
                    child: Align(
                      alignment: Alignment.centerLeft,
                      child: Text(
                        "Nama",
                        style: TextStyle(color: Colors.grey),
                        textAlign: TextAlign.start,
                      ),
                    ),
                  ),
                  Expanded(
                    child: Align(
                      alignment: Alignment.centerRight,
                      child: Text(
                        widget.dataAktivitas.namaKaryawan!,
                        textAlign: TextAlign.end,
                      ),
                    ),
                  ),
                ],
              ),
            ),
            SizedBox(
              height: 4,
            ),
            Container(
              margin: EdgeInsets.symmetric(vertical: 0, horizontal: 10),
              child: Row(
                children: [
                  Expanded(
                    child: Align(
                      alignment: Alignment.centerLeft,
                      child: Text(
                        "Lokasi",
                        style: TextStyle(color: Colors.grey),
                        textAlign: TextAlign.start,
                      ),
                    ),
                  ),
                  Expanded(
                    child: Align(
                      alignment: Alignment.centerRight,
                      child: Text(
                        widget.dataAktivitas.lokasi!,
                        textAlign: TextAlign.end,
                      ),
                    ),
                  ),
                ],
              ),
            ),
            SizedBox(
              height: 4,
            ),
            Container(
              margin: EdgeInsets.all(10),
              width: double.infinity,
              decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(10),
                  color: Color(0xffE5E5EA)),
              padding: EdgeInsets.all(10),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text("Keterangan",style: TextStyle(
                    color: Colors.grey
                  ),),
                  SizedBox(height: 5,),
                  Text(widget.dataAktivitas.keterangan!),
                ],
              ),
            )
          ],
        ),
      ),
    );
  }

  actionMenu() {
    return {'Detail'}.map((String choice) {
      return PopupMenuItem<String>(
        value: choice,
        child: Text(choice),
      );
    }).toList();
  }
}
class DashedLine extends StatelessWidget {
  final double height;
  final Color color;
  final double dashWidth;
  final double dashSpace;

  const DashedLine({
    this.height = 1,
    this.color = Colors.grey,
    this.dashWidth = 5,
    this.dashSpace = 3,
  });

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(builder: (context, constraints) {
      final boxWidth = constraints.constrainWidth();
      final dashCount = (boxWidth / (dashWidth + dashSpace)).floor();

      return Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: List.generate(dashCount, (_) {
          return SizedBox(
            width: dashWidth,
            height: height,
            child: DecoratedBox(
              decoration: BoxDecoration(color: color),
            ),
          );
        }),
      );
    });
  }
}

class TemplateRow extends StatelessWidget {
  final String title;
  final String? subTitle;
  final Color? color;
  final String? imageUrl;
  final bool titikDua;
  final fontSize;
  final List<int>? flex;
  final String? lat;
  final String? long;
  TemplateRow(this.title, this.subTitle, this.imageUrl, this.color,
      {this.fontSize,
      this.flex,
      this.titikDua = false,
      this.lat = '-',
      this.long = '-'});

  @override
  Widget build(BuildContext context) {
    return Row(
      children: [
        Expanded(
          flex: flex != null ? flex![0] : 4,
          child: Text(
            title,
            style: TextStyle(
                fontWeight: FontWeight.w600,
                color: color,
                fontSize: fontSize ?? CustomStyle.fontSizeSmall - 1),
          ),
        ),
        SizedBox(
          width: 12,
        ),
        titikDua
            ? Row(
                children: [
                  SizedBox(
                    width: 12,
                  ),
                  Text(
                    ":",
                    style: TextStyle(
                        color: CustomStyle.fontColorBlack,
                        fontSize: fontSize ?? CustomStyle.fontSizeSmall - 1),
                  ),
                  SizedBox(
                    width: 12,
                  ),
                ],
              )
            : Container(),
        Expanded(
          flex: flex != null ? flex![1] : 7,
          child: Container(
            color: Colors.white,
            child: Text(
              subTitle!,
              style: TextStyle(
                  color: CustomStyle.fontColorBlack,
                  fontSize: fontSize ?? CustomStyle.fontSizeSmall - 1),
            ),
          ),
        ),
        SizedBox(
          width: 8,
        ),
        imageUrl != null
            ? Expanded(
                flex: flex != null ? flex![2] : 1,
                child: imageUrl != null
                    ? GestureDetector(
                        onTap: () => BlocProvider.of<NavigatorBloc>(context)
                            .add(NavigateToDetailImageClicked(
                                context, imageUrl)),
                        child: Icon(
                          Icons.image,
                          color: Colors.grey[500],
                          size: 22,
                        ))
                    : Container(),
              )
            : Container(),
        SizedBox(
          width: 8,
        ),
        Expanded(
          flex: 1,
          child: lat != '-' && lat != null
              ? GestureDetector(
                  onTap: () => BlocProvider.of<NavigatorBloc>(context).add(
                      NavigateToDetailMap(
                          context,
                          ModelDetailMap("Lokasi Absen $title",
                              double.parse(lat!), double.parse(long!)))),
                  child: Icon(
                    Icons.pin_drop_rounded,
                    color: Colors.redAccent,
                    size: 21,
                  ))
              : Container(),
        ),
      ],
    );
  }
}
