import 'package:absenkuv3/Bloc/klien/LaporanKinerjaKlienBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Klien/LaporanKinerjaKlien/widget/KomponenLaporanKinerja.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/FilterToggle/UI/templateFilterTogle.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListLaporanKinerjaKlien extends StatefulWidget {
  const HalamanListLaporanKinerjaKlien({super.key});
  @override
  State<HalamanListLaporanKinerjaKlien> createState() =>
      _HalamanListLaporanKinerjaKlienState();
}

class _HalamanListLaporanKinerjaKlienState
    extends State<HalamanListLaporanKinerjaKlien> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context)
        .add(SetDate([DateTime.now(), DateTime.now()]));
    BlocProvider.of<LaporanKinerjaKlienBloc>(context)
        .add(getListLaporanKinerjaKlienEvent(context, null));
    _scrollController.addListener(() =>
        BlocProvider.of<LaporanKinerjaKlienBloc>(context)
            .add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      appBar: AppBar(
        title: Text(
          'Laporan Kinerja',
          style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
        ),
        centerTitle: true,
        flexibleSpace: Image(
          image: AssetImage(ValueImage.headerBiruDashboard),
          fit: BoxFit.cover,
        ),
        backgroundColor: Colors.transparent,
      ),
      body: FutureBuilder(
        future: PengaturanBahasa().aktivitas(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return Stack(
              children: [
                BlocBuilder<LaporanKinerjaKlienBloc, LaporanKinerjaKlienState>(
                  builder:
                      (BuildContext context, LaporanKinerjaKlienState state) {
                    if (state is getListLapoanKinerjaKlienSuccessState ||
                        state is LoadMoreProgressState)
                      return Stack(
                        children: <Widget>[
                          ListView.builder(
                            physics: AlwaysScrollableScrollPhysics(),
                            controller: _scrollController,
                            itemCount: state.data!.length,
                            itemBuilder: (BuildContext context, index) {
                              return CardLaporanKinerja(
                                state.data![index],
                                scaffoldKey,
                                'aktivitasPegawai',
                                snapshot.data!,
                              );
                            },
                          ),
                          state is LoadMoreProgressState
                              ? Positioned(
                                  bottom: 16,
                                  child: Container(
                                    width: MediaQuery.of(context).size.width,
                                    child: Center(
                                      child: CircularProgressIndicator(
                                        strokeWidth: 8,
                                      ),
                                    ),
                                  ),
                                )
                              : Container(),
                        ],
                      );
                    else if (state is LaporanKinerjaKlienProgressState)
                      return Center(
                        child: CircularProgressIndicator(
                          strokeWidth: 8,
                        ),
                      );
                    else
                      return Center(
                        child: Image.asset(
                          ValueImage.noData,
                          height: 250,
                        ),
                      );
                  },
                ),
                Positioned(
                  bottom: 16,
                  right: 14,
                  child:
                      BlocListener<DateRangePickerBloc, DateRangePickerState>(
                    listener: (BuildContext context,
                        DateRangePickerState dateRangePickerState) {
                      if (dateRangePickerState is DateAvailable)
                        BlocProvider.of<LaporanKinerjaKlienBloc>(context).add(
                          getListLaporanKinerjaKlienEvent(
                            context,
                            ModelFilter(dateRange: dateRangePickerState.date),
                          ),
                        );
                    },
                    child: TemplateFilterToggle(),
                  ),
                ),
              ],
            );
          } else {
            return Container();
          }
        },
      ),
    );
  }

}
