import 'package:absenkuv3/Bloc/klien/LaporanAbsensiKlienBloc.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Absensi/KomponenAbsensi.dart';
import 'package:absenkuv3/UI/Template/DateRangePicker/Bloc/DateRangePickerBloc.dart';
import 'package:absenkuv3/UI/Template/FilterToggle/UI/templateFilterTogle.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanListLaporanAbsensiKlien extends StatefulWidget {
  const HalamanListLaporanAbsensiKlien({super.key});

  @override
  State<HalamanListLaporanAbsensiKlien> createState() =>
      _HalamanListLaporanAbsensiKlienState();
}

class _HalamanListLaporanAbsensiKlienState
    extends State<HalamanListLaporanAbsensiKlien> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();
  DateTime? dateTime;
  ModelFilter? modelFilterDataAbsensi;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DateRangePickerBloc>(context).add(InitialDate());
    BlocProvider.of<LaporanAbsensiKlienBloc>(context)
        .add(getListLaporanAbsensiKlienEvent(context, modelFilterDataAbsensi));
    _scrollController.addListener(() =>
        BlocProvider.of<LaporanAbsensiKlienBloc>(context)
            .add(loadMoreEvent(context, scaffoldKey, _scrollController)));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      appBar: AppBar(
        title: Text(
          'Laporan Absensi Karyawan',
          style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
        ),
        centerTitle: true,
        flexibleSpace: Image(
          image: AssetImage(ValueImage.headerBiruDashboard),
          fit: BoxFit.cover,
        ),
        backgroundColor: Colors.transparent,
      ),
      body: FutureBuilder(
        future: PengaturanBahasa().dataAbsensi(),
        builder: (context, snapshot) {
          if (snapshot.connectionState == ConnectionState.done) {
            return Stack(
              children: [
                BlocBuilder<LaporanAbsensiKlienBloc, LaporanAbsensiKlienState>(
                  builder:
                      (BuildContext context, LaporanAbsensiKlienState state) {
                    if (state is getListLaporanAbsensiKlienSuccessState ||
                        state is LoadMoreProgressState)
                      return Stack(
                        children: <Widget>[
                          ListView.builder(
                              physics: AlwaysScrollableScrollPhysics(),
                              controller: _scrollController,
                              itemCount: state.data!.length,
                              itemBuilder: (BuildContext context, index) {
                                return CardAbsensi(
                                    state.data![index], snapshot.data!,absensiPegawai: true,);
                              }),
                          state is LoadMoreProgressState
                              ? Positioned(
                                  bottom: 16,
                                  child: Container(
                                    width: MediaQuery.of(context).size.width,
                                    child: Center(
                                      child: CircularProgressIndicator(
                                        strokeWidth: 8,
                                      ),
                                    ),
                                  ),
                                )
                              : Container(),
                        ],
                      );
                    else if (state is LaporanAbsensiKlienProgressState)
                      return Center(
                        child: CircularProgressIndicator(
                          strokeWidth: 8,
                        ),
                      );
                    else
                      return Center(
                        child: Image.asset(
                          ValueImage.noData,
                          height: 250,
                        ),
                      );
                  },
                ),
                Positioned(
                  bottom: 16,
                  right: 14,
                  child:
                      BlocListener<DateRangePickerBloc, DateRangePickerState>(
                    listener: (BuildContext context,
                        DateRangePickerState dateRangePickerState) {
                      if (dateRangePickerState is DateAvailable)
                        BlocProvider.of<LaporanAbsensiKlienBloc>(context).add(
                          getListLaporanAbsensiKlienEvent(
                            context,
                            ModelFilter(dateRange: dateRangePickerState.date),
                          ),
                        );
                    },
                    child: TemplateFilterToggle(),
                  ),
                ),
              ],
            );
          } else {
            return Container();
          }
        },
      ),
    );
  }
}
