import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/dialog/dialogConfirmationv2.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButtonAkun.dart';
import 'package:absenkuv3/UI/Template/templateIconInformation.dart';
import 'package:absenkuv3/UI/Template/verticalDivider.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanDetailKlien extends StatefulWidget {
  const HalamanDetailKlien({super.key});

  @override
  State<HalamanDetailKlien> createState() => _HalamanDetailKlienState();
}

class _HalamanDetailKlienState extends State<HalamanDetailKlien> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: CustomStyle.backgroundColor,
      appBar: AppBar(
        centerTitle: true,
        title: Text(
          'Akun',
          style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
        ),
        flexibleSpace: Image(
          image: AssetImage(ValueImage.headerBiruDashboard),
          fit: BoxFit.cover,
        ),
        forceMaterialTransparency: true,
        backgroundColor: Colors.transparent,
      ),
      body: Stack(
        children: [
          Column(
            children: <Widget>[
              Container(
                width: double.infinity,
                // height:MediaQuery.of(context).size.height,
                height: MediaQuery.of(context).size.height / 4,
                child: Image.asset(
                  ValueImage.headerBiruDashboard,
                  fit: BoxFit.fitWidth,
                ),
              ),
              // Expanded(
              //   child: Container(
              //     height: MediaQuery.of(context).size.height / 3,
              //     color: CustomStyle.backgroundDashboardColor,
              //     // color: Colors.orange,
              //   ),
              // ),
            ],
          ),
          BlocBuilder<AuthBloc, LoginRespon>(
              builder: (BuildContext context, LoginRespon loginRespon) {
            if (loginRespon != false) {
              return SafeArea(
                child: SingleChildScrollView(
                  child: Padding(
                    padding: const EdgeInsets.fromLTRB(12, 20, 12, 16),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: <Widget>[
                        cardNama(
                          loginRespon.dataLogin,
                          'Alamat',
                          'Kantor',
                        ),
                        SizedBox(
                          height: 15,
                        ),
                        TemplateButtonAkun(
                                icon: Icon(Icons.lock_outline),
                                title: 'Ganti Password',
                                onClick: () =>
                                    BlocProvider.of<NavigatorBloc>(context)
                                        .add(NavigateToHalamanUbahPassworKlien(context)),
                              ),
                              SizedBox(
                                height: 5,
                              ),
                        TemplateButtonAkun(
                          icon: Icon(Icons.subdirectory_arrow_left),
                          title: 'Logout',
                          onClick: () {
                            showDialog(
                              barrierDismissible: false,
                              context: context,
                              builder: (BuildContext contextAlert) =>
                                  AlertConfirmation(
                                      message:
                                          'Apakah anda akan keluar aplikasi',
                                      textBtnSubmit: 'Ya',
                                      textBtnCancel: 'Tidak',
                                      onClick: () async {
                                        Navigator.of(contextAlert).pop();
                                        BlocProvider.of<AuthBloc>(context).add(
                                            LogoutKlienEvent(context, null));
                                      }),
                            );
                          },
                        ),
                      ],
                    ),
                  ),
                ),
              );
            } else
              return Container(
                height: MediaQuery.of(context).size.height,
                child: Center(
                  child: CircularProgressIndicator(
                    strokeWidth: 8,
                  ),
                ),
              );
          }),
        ],
      ),
    );
  }

  Widget cardNama(
      DataLogin? dataLogin, String titleJabatan, String titleDepartemen) {
    return Container(
        width: MediaQuery.of(context).size.width,
        padding: EdgeInsets.fromLTRB(12, 16, 12, 8),
        decoration: CustomStyle.boxDecoration,
        child: Column(
          children: <Widget>[
            Row(
              children: <Widget>[
                Padding(
                  padding: const EdgeInsets.all(8.0),
                  child: Icon(
                    Icons.person,
                    color: Colors.grey[400],
                    size: 48,
                  ),
                ),
                SizedBox(
                  width: 12,
                ),
                Expanded(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Text(
                        dataLogin!.namaUser! ?? '',
                        style: TextStyle(
                            fontSize: CustomStyle.fontSizeSubTitle,
                            fontWeight: FontWeight.bold,
                            color: CustomStyle.fontColorBlack),
                      ),
                    ],
                  ),
                ),
                SizedBox(width: 15),
              ],
            ),
            SizedBox(
              height: 4,
            ),
            Divider(
              thickness: 1,
            ),
            SizedBox(
              height: 8,
            ),
            Row(
              children: [
                Expanded(
                  child: IconInformation(
                    icon: ValueImage.iconJabatan,
                    title: titleJabatan,
                    subtitle: dataLogin.alamat ?? '-',
                    sizeIcon: 25,
                  ),
                ),
                VerticalDividerAbsenku(),
                Expanded(
                  child: IconInformation(
                    icon: ValueImage.iconDepartement,
                    title: titleDepartemen,
                    subtitle: dataLogin.kantorPusat ?? '-',
                    sizeIcon: 25,
                  ),
                ),
              ],
            )
          ],
        ));
  }
}
