import 'package:absenkuv3/Bloc/Dropdown/DropdownJenisReimbursementBloc.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

class DropdownJenisReimbursement extends StatefulWidget {
  final color;
  final double fontSize;
  final String? initialData;
  final double? formHeight;
  final double radius;
  DropdownJenisReimbursement({this.initialData, this.color = Colors.grey, this.fontSize = 14, this.formHeight, this.radius = 6});

  @override
  _DropdownJenisReimbursementState createState() => _DropdownJenisReimbursementState();
}

class _DropdownJenisReimbursementState extends State<DropdownJenisReimbursement> {

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    BlocProvider.of<DropdownJenisReimbursementBloc>(context).add(GetDataDropdown());
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<String>(
        future: PengaturanBahasa().getDataBahasa(),
        builder: (context, snapshot) {
          return Container(
            margin: EdgeInsets.only(bottom: 12),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Padding(
                  padding: const EdgeInsets.only(bottom: 8),
                  child: Text(
                    snapshot.data == null || snapshot.data == 'en' ? 'Type' : 'Jenis',
                    style: TextStyle(color: widget.color, fontWeight: FontWeight.bold, fontSize: widget.fontSize),
                  ),
                ),
                BlocBuilder<DropdownJenisReimbursementBloc, DropdownState>(
                  builder: (BuildContext context, DropdownState state){
                    if(state is DropdownSuccessState) return Container(
                      height: widget.formHeight??CustomStyle.formHeight,
                      padding: EdgeInsets.only(right: 12),
                      decoration: BoxDecoration(
                          border: Border.all(
                              width: 0.8, //
                              color: CustomStyle.fontColorBlack!//                  <--- border width here
                          ),
                          borderRadius: new BorderRadius.all(Radius.circular(widget.radius))
                      ),
                      child: DropdownButton(
                        isExpanded: true,
                        underline: Container(),
                        elevation: 2,
                        style: TextStyle(color: widget.color, fontSize: 13, fontWeight: FontWeight.normal),
                        icon: Icon(Icons.keyboard_arrow_down),
                        hint: Container(
                            padding: EdgeInsets.only(left: 12),
                            child: Text(widget.initialData!=null
                                ? widget.initialData!
                                : snapshot.data == null || snapshot.data == 'en' ? 'All Kinds' : 'Pilih Jenis', style: TextStyle(color: widget.color, fontWeight: FontWeight.normal),)),
                        value: state.selectedValue,
                        items: state.dropdownRespon!.data!=null && state.dropdownRespon!.data!.length>0?state.dropdownRespon!.data!.map((item) {
                          return DropdownMenuItem(
                            child: Container(
                                padding: EdgeInsets.only(left: 12),
                                child: Text(item.nama!,)),
                            value: item,
                          );
                        }).toList():[],
                        onChanged: (dynamic value)=>BlocProvider.of<DropdownJenisReimbursementBloc>(context).add(SelectDataDropdown(value)),
                      ),
                    );
                    else return Container(
                      height: widget.formHeight??CustomStyle.formHeight,
                      width: MediaQuery.of(context).size.width,
                      child: Shimmer.fromColors(
                        baseColor: Colors.grey[200]!,
                        highlightColor: Colors.white,
                        period: Duration(seconds: 4),
                        child: Card(),
                      ),
                    );
                  },
                ),
              ],
            ),
          );
        }
    );
  }
}
