import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/DropdownCabangBloc.dart' as cabang;
import 'package:absenkuv3/Bloc/Dropdown/DropdownDepartemenBloc.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

class DropdownDepartemen extends StatefulWidget {
  final color;
  final double fontSize;
  final String? initialData;
  final double? formHeight;
  final double radius;
  DropdownDepartemen({this.initialData, this.color = Colors.grey, this.fontSize = 14, this.formHeight, this.radius = 6});

  @override
  _DropdownDepartemenState createState() => _DropdownDepartemenState();
}

class _DropdownDepartemenState extends State<DropdownDepartemen> {

  @override
  void initState() {
    super.initState();
    /*BlocProvider.of<DropdownDepartemenBloc>(context).add(GetDataDropdown());*/
  }

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<AuthBloc, LoginRespon>(
    builder: (BuildContext context, LoginRespon loginRespon){
      /*return loginRespon.dataLogin.level==4?BlocConsumer<cabang.DropdownCabangBloc, cabang.DropdownState>(
        listener: (BuildContext context, cabang.DropdownState stateCabang){
          if(stateCabang is cabang.DropdownSuccessState && stateCabang.selectedValue!=null){
            BlocProvider.of<DropdownDepartemenBloc>(context).add(GetDataDropdown(idCabang : stateCabang.selectedValue.id));
          }
        },
        builder: (BuildContext context, cabang.DropdownState stateCabang){
          if(stateCabang is cabang.DropdownSuccessState && stateCabang.selectedValue!=null) return content();
          else return Container();
        },
      ):content();*/
      return BlocListener<cabang.DropdownCabangBloc, cabang.DropdownState>(
        listener: (BuildContext context, cabang.DropdownState stateCabang){
          if(stateCabang is cabang.DropdownSuccessState && stateCabang.selectedValue!=null){
            BlocProvider.of<DropdownDepartemenBloc>(context).add(GetDataDropdown(idCabang : stateCabang.selectedValue!.id));
          }
        },
        child: content(),
      );
    });


  }

  Widget content(){
    return FutureBuilder<String>(
        future: PengaturanBahasa().getDataBahasa(),
        builder: (context, snapshot) {
          return Container(
            margin: EdgeInsets.only(bottom: 12),
            child: BlocBuilder<DropdownDepartemenBloc, DropdownState>(
              builder: (BuildContext context, DropdownState state){
                if(state is DropdownSuccessState) return Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Padding(
                      padding: const EdgeInsets.only(bottom: 8),
                      child: Text(
                        snapshot.data == null || snapshot.data == "en" ? 'Department' : 'Departemen',
                        style: TextStyle(color: widget.color, fontWeight: FontWeight.bold, fontSize: widget.fontSize),
                      ),
                    ),
                    Container(
                      height: widget.formHeight??CustomStyle.formHeight,
                      padding: EdgeInsets.only(right: 12),
                      decoration: BoxDecoration(
                          border: Border.all(
                              width: 0.8, //
                              color: CustomStyle.fontColorBlack!//                  <--- border width here
                          ),
                          borderRadius: new BorderRadius.all(Radius.circular(widget.radius))
                      ),
                      child: DropdownButton(
                        isExpanded: true,
                        underline: Container(),
                        elevation: 2,
                        style: TextStyle(color: widget.color, fontSize: 13, fontWeight: FontWeight.normal),
                        icon: Icon(Icons.keyboard_arrow_down),
                        hint: Container(
                            padding: EdgeInsets.only(left: 12),
                            child: Text(widget.initialData!=null
                                          ? widget.initialData!
                                          : snapshot.data == null || snapshot.data == "en" ? 'All Department' : 'Semua Departemen', style: TextStyle(color: widget.color, fontWeight: FontWeight.normal),)),
                        value: state.selectedValue,
                        items: state.dropdownRespon!.data!=null && state.dropdownRespon!.data!.length>0?state.dropdownRespon!.data!.map((item) {
                          return DropdownMenuItem(
                            child: Container(
                                padding: EdgeInsets.only(left: 12),
                                child: Text(item.nama!,)),
                            value: item,
                          );
                        }).toList():[],
                        onChanged: (dynamic value)=>BlocProvider.of<DropdownDepartemenBloc>(context).add(SelectDataDropdown(value)),
                      ),
                    ),
                  ],
                );
                else if(state is DropdownProgressState) return Container(
                  height: widget.formHeight??CustomStyle.formHeight,
                  width: MediaQuery.of(context).size.width,
                  child: Shimmer.fromColors(
                    baseColor: Colors.grey[200]!,
                    highlightColor: Colors.white,
                    period: Duration(seconds: 4),
                    child: Card(),
                  ),
                );
                else return Container();
              },
            ),
          );
        }
    );
  }
}
