import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownJenjangBloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:shimmer/shimmer.dart';

// ignore: must_be_immutable
class DropdownJenisJenjang extends StatefulWidget {
  String title;
  var color;
  double fontSize;
  String? initialData;
  double? formHeight;
  bool validate;
  double marginHorizontal;
  DropdownJenisJenjang(this.title, {this.initialData, this.color = Colors.grey, this.fontSize = 14, this.formHeight, this.validate = false, this.marginHorizontal = 0});

  @override
  _DropdownJenisJenjangState createState() => _DropdownJenisJenjangState();
}

class _DropdownJenisJenjangState extends State<DropdownJenisJenjang> {
  TextEditingController _controller = TextEditingController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DropdownJenjangBloc>(context).add(GetDataDropdownJenjang());
    if(widget.initialData != null){
      _controller.text = widget.initialData!;
    }
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(bottom: 12, top: 11, right: widget.marginHorizontal, left: widget.marginHorizontal),
      child: BlocBuilder<DropdownJenjangBloc, DropdownJenjangState>(
        builder: (BuildContext context, DropdownJenjangState state){
          if(state is DropdownJenjangSuccessState) return Container(
            child:  DropdownMenu(
              dropdownMenuEntries: state.dropdownRespon.data!.map((item) {
                return DropdownMenuEntry(
                    value: item,
                    label: item.nama!
                );
              }).toList(),
              inputDecorationTheme: InputDecorationTheme(
                contentPadding: EdgeInsets.symmetric(vertical: 7.0),
                enabledBorder: UnderlineInputBorder(borderSide: BorderSide(color: CustomStyle.colorLineFormDropdown)),
              ),
              controller: _controller,
              onSelected: (value)=> BlocProvider.of<DropdownJenjangBloc>(context).add(SelectDataDropdownJenjang(value!)),
              label: Row(
                children: [
                  Text(widget.title, style: TextStyle( fontSize: widget.fontSize, fontWeight: FontWeight.w400)),
                  SizedBox(width: 7),
                  Text('*', style: TextStyle(color: Colors.red, fontSize: widget.fontSize)),
                ],
              ),
              textStyle: TextStyle(fontSize: 13),
              requestFocusOnTap: true,
              width: MediaQuery.of(context).size.width-50,
            ),
          );
          else return Container(
            height: widget.formHeight??CustomStyle.formHeight,
            width: MediaQuery.of(context).size.width,
            child: Shimmer.fromColors(
              baseColor: Colors.grey[200]!,
              highlightColor: Colors.white,
              period: Duration(seconds: 4),
              child: Card(),
            ),
          );
        },
      ),
    );
  }
}
