import 'package:absenkuv3/Bloc/Akun/PengalamanKerja/DataPengalamanKerjaBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownKabupatenBloc.dart';
import 'package:absenkuv3/Bloc/Dropdown/Akun/DropdownProvinsiBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/PengalamanKerja/mPengalamanKerja.dart';
import 'package:absenkuv3/Repository/Model/Akun/PengalamanKerja/mPengalamanKerjaById.dart';
import 'package:absenkuv3/Repository/Model/Akun/mDataDiri.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataPengalamanKerjaPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisKabupaten.dart';
import 'package:absenkuv3/UI/Modul/Dropdown/Akun/DropdownJenisProvinsi.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetKabKot.dart';
import 'package:absenkuv3/UI/Template/BottomSheet/BottomSheetProvinsi.dart';
import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerTglKawinBloc.dart';
import 'package:absenkuv3/UI/Template/DatePicker/Bloc/DatePickerTglLahirBloc.dart';
import 'package:absenkuv3/UI/Template/DatePicker/UI/templateDatePickerTglKawin.dart';
import 'package:absenkuv3/UI/Template/DatePicker/UI/templateDatePickerTglLahir.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Bloc/MultiImagePickerBloc.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/Model/MultiImagePickerModel.dart';
import 'package:absenkuv3/UI/Template/MultiImagePicker/UI/templateMultiImagePicker.dart';
import 'package:flutter/material.dart';
import 'package:absenkuv3/Bloc/CustomFunction.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateTextFormAkun.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:intl/intl.dart';

// ignore: must_be_immutable
class HalamanEditPengajuanDataPengalamanKerja extends StatefulWidget {
  var idPengalamanKerja;
  HalamanEditPengajuanDataPengalamanKerja(this.idPengalamanKerja);

  @override
  _HalamanEditPengajuanDataPengalamanKerjaState createState() =>
      _HalamanEditPengajuanDataPengalamanKerjaState();
}

class _HalamanEditPengajuanDataPengalamanKerjaState
    extends State<HalamanEditPengajuanDataPengalamanKerja> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  String? idPengalamanKerja;
  TextEditingController namaPerusahaan = new TextEditingController();
  TextEditingController jenisPerusahaan = new TextEditingController();
  TextEditingController jabatanTerakhir = new TextEditingController();
  TextEditingController alamatPerusahaan = new TextEditingController();
  JenisData? provinsi;
  JenisData? kota;

  // final dateFormat = new DateFormat('dd-MM-yyyy');
  final dateFormat = new DateFormat('yyyy-MM-dd');
  DateFormat dateFormatRaw = DateFormat('d MMMM yyyy', 'id_ID');
  String tglMasukKerja = '0000-00-00';
  TextEditingController tglMasukKerjaRaw = new TextEditingController();
  String tglBerhentiKerja = '0000-00-00';
  TextEditingController tglBerhentiKerjaRaw = new TextEditingController();
  TextEditingController alasanBerhenti = new TextEditingController();
  List<MultiImagePickerModel>? listImage;

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataPengalamanKerjaBloc>(context).add(
        getDataPengalamanKerjaPengajuanByIdEvent(
            context, widget.idPengalamanKerja, 'pengajuan'));
  }

  Future<bool> keluar() async {
    Navigator.pop(context);
    return false;
  }

  void setDataKeluarga(DataDatapengalamankerjaById state, String bahasa) {
    dateFormatRaw = DateFormat('d MMMM yyyy', bahasa);
    idPengalamanKerja = state.idRiwayatPekerjaan!;
    namaPerusahaan.text = state.namaPerusahaan!;
    jenisPerusahaan.text = state.jenisPerusahaan!;
    jabatanTerakhir.text = state.jabatan!;
    alamatPerusahaan.text = state.alamatPerusahaan!;
    tglMasukKerja = state.tglMasuk!;
    if (tglMasukKerja != '0000-00-00') {
      tglMasukKerjaRaw.text =
          dateFormatRaw.format(DateTime.parse(tglMasukKerja));
    }
    tglBerhentiKerja = state.tglKeluar!;
    if (tglBerhentiKerja != '0000-00-00') {
      tglBerhentiKerjaRaw.text =
          dateFormatRaw.format(DateTime.parse(tglBerhentiKerja));
    }
    alasanBerhenti.text = state.alasanBerhenti!;
    provinsi = state.provinsi!;
    kota = state.kota!;
    BlocProvider.of<DropdownKabupatenBloc>(context).add(SetProvinsi(
        provinsi!.id!,
        kota == null ? null : JenisData(id: kota!.id, nama: kota!.nama)));
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataPengalamanKerjaModel>(
          future: PengaturanBahasa().dataPengalamanKerja(),
          builder: (context, snapshot) {
            if (snapshot.connectionState == ConnectionState.done) {
              return Scaffold(
                key: scaffoldKey,
                appBar: AppBar(
                  centerTitle: true,
                  iconTheme: IconThemeData(color: CustomStyle.color15),
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                  title: Text(
                    snapshot.data!.menuDataPengalamanKerja!.title!,
                    style: TextStyle(
                        fontSize: CustomStyle.fontSizeTitle,
                        color: CustomStyle.color15),
                  ),
                ),
                body: BlocBuilder<DataPengalamanKerjaBloc,
                        DataPengalamanKerjaState>(
                    builder:
                        (BuildContext context, DataPengalamanKerjaState state) {
                  if (state is getDataPengalamanKerjaByIdSuccessState) {
                    setDataKeluarga(state.dataById![0],
                        snapshot.data!.menuDataPengalamanKerja!.locale!);
                    return SingleChildScrollView(
                      child: Container(
                        margin: EdgeInsets.all(10),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            SizedBox(height: 17),
                            TemplateTextFormAkun(
                              adaValidasi: true,
                              controller: namaPerusahaan,
                              color: Colors.black,
                              fontSize: 13,
                              titleText: snapshot.data!.menuDataPengalamanKerja!
                                  .dataPengalamanKerja!.namaPerusahaan,
                              radius: CustomStyle.formRadius,
                              marginHorizontal: 13,
                              // hintText: "Nama Perusahaan",
                            ),
                            SizedBox(height: 17),
                            TemplateTextFormAkun(
                              adaValidasi: true,
                              controller: jenisPerusahaan,
                              color: Colors.black,
                              fontSize: 13,
                              titleText: snapshot.data!.menuDataPengalamanKerja!
                                  .dataPengalamanKerja!.jenisPerusahaan,
                              radius: CustomStyle.formRadius,
                              marginHorizontal: 13,
                              // hintText: "Jenis Perusahaan",
                            ),
                            SizedBox(height: 17),
                            TemplateTextFormAkun(
                              adaValidasi: true,
                              controller: jabatanTerakhir,
                              color: Colors.black,
                              fontSize: 13,
                              titleText: snapshot.data!.menuDataPengalamanKerja!
                                  .dataPengalamanKerja!.jabatanTerakhir,
                              radius: CustomStyle.formRadius,
                              marginHorizontal: 13,
                              // hintText: "Jabatan Terakhir",
                            ),
                            SizedBox(height: 17),
                            TemplateTextFormAkun(
                              adaValidasi: true,
                              controller: alamatPerusahaan,
                              marginHorizontal: 13,
                              color: Colors.black,
                              fontSize: 13,
                              titleText: snapshot.data!.menuDataPengalamanKerja!
                                  .dataPengalamanKerja!.alamatPerusahaan,
                              radius: CustomStyle.formRadius,
                              // hintText: "Jabatan Terakhir",
                            ),
                            BlocListener<DropdownProvinsiBloc,
                                DropdownProvinsiState>(
                              listener: (BuildContext context,
                                  DropdownProvinsiState state) {
                                if (state is DropdownProvinsiSuccessState &&
                                    state.selectedValue != null) {
                                  provinsi = state.selectedValue;
                                  BlocProvider.of<DropdownKabupatenBloc>(
                                          context)
                                      .add(SetProvinsi(provinsi!.id!, null));
                                }
                              },
                              child: BottomSheetProvinsi(
                                snapshot.data!.menuDataPengalamanKerja!
                                    .dataPengalamanKerja!.provinsi!,
                                initialData:
                                    provinsi == null ? null : provinsi!.nama,
                                color: Colors.black,
                                marginHorizontal: 15,
                              ),
                            ),
                            BlocListener<DropdownKabupatenBloc,
                                DropdownKabupatenState>(
                              listener: (BuildContext context,
                                  DropdownKabupatenState state) {
                                if (state is DropdownKabupatenSuccessState &&
                                    state.selectedValue != null) {
                                  kota = state.selectedValue;
                                }
                              },
                              child: BottomSheetKabKot(
                                snapshot.data!.menuDataPengalamanKerja!
                                    .dataPengalamanKerja!.kabupaten!,
                                initialData: kota == null ? null : kota,
                                validasi: true,
                                color: Colors.black,
                                marginHorizontal: 15,
                                idProv: provinsi == null ? null : provinsi!.id,
                              ),
                            ),
                            SizedBox(height: 17),
                            BlocListener<DatePickerTglLahirBloc, DateTime>(
                              listener: (BuildContext context, DateTime date) {
                                tglMasukKerja = dateFormat
                                    .format(date); //dateFormat.format(date);
                                tglMasukKerjaRaw.text =
                                    dateFormatRaw.format(date);
                              },
                              child: TemplateDatePickerTglLahir(
                                '${snapshot.data!.menuDataPengalamanKerja!.dataPengalamanKerja!.tanggalMulaiKerja} ',
                                marginHorizontal: 13,
                                textEditingController: tglMasukKerjaRaw,
                                initialData: tglMasukKerja == '0000-00-00'
                                    ? null
                                    : DateTime(
                                        int.parse(tglMasukKerja.split('-')[0]),
                                        int.parse(tglMasukKerja.split('-')[1]),
                                        int.parse(tglMasukKerja.split('-')[2])),
                              ),
                            ),
                            SizedBox(height: 17),
                            BlocListener<DatePickerTglKawinBloc, DateTime>(
                              listener: (BuildContext context, DateTime date) {
                                tglBerhentiKerja = dateFormat
                                    .format(date); //dateFormat.format(date);
                                tglBerhentiKerjaRaw.text =
                                    dateFormatRaw.format(date);
                              },
                              child: TemplateDatePickerTglKawin(
                                '${snapshot.data!.menuDataPengalamanKerja!.dataPengalamanKerja!.tanggalBerhentiKerja}',
                                validasi: true,
                                textEditingController: tglBerhentiKerjaRaw,
                                marginHorizontal: 13,
                                initialData: tglBerhentiKerja == '0000-00-00'
                                    ? null
                                    : DateTime(
                                        int.parse(
                                            tglBerhentiKerja.split('-')[2]),
                                        int.parse(
                                            tglBerhentiKerja.split('-')[1]),
                                        int.parse(
                                            tglBerhentiKerja.split('-')[0])),
                              ),
                            ),
                            SizedBox(height: 17),
                            TemplateTextFormAkun(
                              adaValidasi: true,
                              controller: alasanBerhenti,
                              color: Colors.black,
                              marginHorizontal: 13,
                              fontSize: 13,
                              titleText: snapshot.data!.menuDataPengalamanKerja!
                                  .dataPengalamanKerja!.alasanBerhenti,
                              radius: CustomStyle.formRadius,
                              // hintText: "Alasan Berhenti",
                            ),
                            Container(
                                margin: EdgeInsets.only(
                                    bottom: 9, right: 15, left: 15, top: 17),
                                child: Row(
                                  children: [
                                    Text(
                                        snapshot.data!.menuDataPengalamanKerja!
                                            .dataPengalamanKerja!.lampiran!,
                                        style:
                                            TextStyle(color: Colors.grey[600])),
                                  ],
                                )),
                            BlocListener<MultiImagePickerBloc,
                                MultiImagePickerState>(
                              listener: (BuildContext context,
                                  MultiImagePickerState state) {
                                if (state is MultiImageSuccessState)
                                  listImage = state.listData;
                              },
                              child: Container(
                                  margin: EdgeInsets.only(left: 15, right: 15),
                                  child: TemplateMultiImagePicker(
                                      multiImage: false,
                                      initialData: state.dataById![0].file == ""
                                          ? null
                                          : [state.dataById![0].file])),
                            ),
                            Container(
                              margin: EdgeInsets.only(top: 15),
                              width: double.infinity,
                              height: 41,
                              child: MaterialButton(
                                onPressed: () {
                                  if (namaPerusahaan.text.trim().isEmpty)
                                    showSnackBarDelayed(
                                        scaffoldKey,
                                        snapshot.data!.menuDataPengalamanKerja!
                                            .message!.namaPerusahaanEmpty,
                                        context);
                                  else if (jenisPerusahaan.text.trim().isEmpty)
                                    showSnackBarDelayed(
                                        scaffoldKey,
                                        snapshot.data!.menuDataPengalamanKerja!
                                            .message!.jenisPerusahaanEmpty,
                                        context);
                                  else if (jabatanTerakhir.text.trim().isEmpty)
                                    showSnackBarDelayed(
                                        scaffoldKey,
                                        snapshot.data!.menuDataPengalamanKerja!
                                            .message!.jabatanTerakhirEmpty,
                                        context);
                                  else if (alamatPerusahaan.text.trim().isEmpty)
                                    showSnackBarDelayed(
                                        scaffoldKey,
                                        snapshot.data!.menuDataPengalamanKerja!
                                            .message!.alamatPerusahaanEmpty,
                                        context);
                                  else if (provinsi == null)
                                    showSnackBarDelayed(
                                        scaffoldKey,
                                        snapshot.data!.menuDataPengalamanKerja!
                                            .message!.provinsiEmpty,
                                        context);
                                  else if (kota == null)
                                    showSnackBarDelayed(
                                        scaffoldKey,
                                        snapshot.data!.menuDataPengalamanKerja!
                                            .message!.kabupatenEmpty,
                                        context);
                                  else if (tglMasukKerja == '0000-00-00')
                                    showSnackBarDelayed(
                                        scaffoldKey,
                                        snapshot.data!.menuDataPengalamanKerja!
                                            .message!.tanggalMulaiEmpty,
                                        context);
                                  else if (tglBerhentiKerja == '0000-00-00')
                                    showSnackBarDelayed(
                                        scaffoldKey,
                                        snapshot.data!.menuDataPengalamanKerja!
                                            .message!.tanggalSelesaiEmpty,
                                        context);
                                  else if (alasanBerhenti.text.trim().isEmpty)
                                    showSnackBarDelayed(
                                        scaffoldKey,
                                        snapshot.data!.menuDataPengalamanKerja!
                                            .message!.alasanEmpty,
                                        context);
                                  else
                                    BlocProvider.of<DataPengalamanKerjaBloc>(
                                            context)
                                        .add(
                                            EditPengajuanDataPengamalanKerjaEvent(
                                                context,
                                                scaffoldKey,
                                                DataDatapengalamankerja(
                                                    idRiwayatPekerjaan:
                                                        idPengalamanKerja,
                                                    namaPerusahaan:
                                                        namaPerusahaan.text,
                                                    jenisPerusahaan:
                                                        jenisPerusahaan.text,
                                                    jabatan:
                                                        jabatanTerakhir.text,
                                                    kota: kota!.id,
                                                    provinsi: provinsi!.id,
                                                    alamatPerusahaan:
                                                        alamatPerusahaan.text,
                                                    tglMasuk: tglMasukKerja ==
                                                            '0000-00-00'
                                                        ? tglMasukKerja
                                                        : tglMasukKerja,
                                                    tglKeluar:
                                                        tglBerhentiKerja ==
                                                                '0000-00-00'
                                                            ? tglBerhentiKerja
                                                            : tglBerhentiKerja,
                                                    alasanBerhenti:
                                                        alasanBerhenti.text),
                                                listImage));
                                },
                                shape: RoundedRectangleBorder(
                                    borderRadius: BorderRadius.circular(15)),
                                color: CustomStyle.color1,
                                textColor: Colors.white,
                                child: Text(snapshot
                                    .data!
                                    .menuDataPengalamanKerja!
                                    .button!
                                    .ajukanPerubahanData!),
                              ),
                            )
                          ],
                        ),
                      ),
                    );
                  } else if (state is DataPengalamanKerjaProgressState)
                    return Center(
                      child: CircularProgressIndicator(
                        strokeWidth: 8,
                      ),
                    );
                  else
                    return Center(
                      child: Image.asset(
                        ValueImage.noData,
                        height: 250,
                      ),
                    );
                }),
              );
            } else {
              return Container();
            }
          }),
    );
  }
}
