import 'package:absenkuv3/Bloc/Akun/PengalamanKerja/DataPengalamanKerjaBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/NotifBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataPengalamanKerjaPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Akun/PengalamanKerja/CardDataPengalamanKerja.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanDetailNotifikasiDataPengalamanKerja extends StatefulWidget {
  final DataNotifikasiAkun data;
  HalamanDetailNotifikasiDataPengalamanKerja(this.data);

  @override
  _HalamanDetailNotifikasiDataPengalamanKerjaState createState() => _HalamanDetailNotifikasiDataPengalamanKerjaState();
}

class _HalamanDetailNotifikasiDataPengalamanKerjaState extends State<HalamanDetailNotifikasiDataPengalamanKerja> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataPengalamanKerjaBloc>(context).add(getDetailDataPengalamanKerjaByIdEvent(context, widget.data));
    BlocProvider.of<NotifBloc>(context).add(BacaNotifAkun(widget.data.idNotif, context));
  }

  Future<bool> keluar() async {
    Navigator.pop(context);
    BlocProvider.of<NavigatorBloc>(context).add(NavigateToReplacementHalamanNotifikasiAkun(context));
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataPengalamanKerjaModel>(
        future: PengaturanBahasa().dataPengalamanKerja(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
              key: scaffoldKey,
              appBar: AppBar(centerTitle: true,
                iconTheme: IconThemeData(color: CustomStyle.color15),
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
                title: Text(snapshot.data!.menuDataPengalamanKerja!.title!,
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle,color: CustomStyle.color15),
                ),
              ),
              body: BlocBuilder<DataPengalamanKerjaBloc, DataPengalamanKerjaState>(
                  builder: (BuildContext context, DataPengalamanKerjaState state){
                    if(state is getDataPengalamanKerjaSuccessState) {
                      return ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          controller: _scrollController,
                          itemCount: state.data!.length,
                          itemBuilder: (BuildContext context, index) {
                            return CardDataPengalamanKerjaPengajuan(scaffoldKey,state.data![index],"history", snapshot.data!);
                          }
                      );
                    }
                    else if(state is DataPengalamanKerjaProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                    else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
                  }
              ),
            );
          }else{
            return Container();
          }
        }
      ),
    );
  }

}
