import 'package:absenkuv3/Bloc/Akun/PengalamanKerja/DataPengalamanKerjaBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataPengalamanKerjaPage.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Akun/PengalamanKerja/CardDataPengalamanKerja.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanDataPengalamanKerjaPengajuan extends StatefulWidget {
  final PageDataPengalamanKerjaModel redaksional;
  HalamanDataPengalamanKerjaPengajuan(this.redaksional);

  @override
  _HalamanDataPengalamanKerjaPengajuanState createState() => _HalamanDataPengalamanKerjaPengajuanState();
}

class _HalamanDataPengalamanKerjaPengajuanState extends State<HalamanDataPengalamanKerjaPengajuan> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataPengalamanKerjaBloc>(context).add(getDataPengalamanKerjaPengajuanEvent(context));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: BlocBuilder<DataPengalamanKerjaBloc, DataPengalamanKerjaState>(
          builder: (BuildContext context, DataPengalamanKerjaState state){
            if(state is getDataPengalamanKerjaSuccessState) {
              return ListView.builder(
                  physics: AlwaysScrollableScrollPhysics(),
                  controller: _scrollController,
                  itemCount: state.data!.length,
                  itemBuilder: (BuildContext context, index) {
                    return CardDataPengalamanKerjaPengajuan(scaffoldKey,state.data![index],"pengajuan", widget.redaksional);
                  }
              );
            }
            else if(state is DataPengalamanKerjaProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
            else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
          }
      ),
    );
  }

}
