import 'package:absenkuv3/Bloc/Akun/PengalamanKerja/DataPengalamanKerjaBloc.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/PengalamanKerja/mPengalamanKerja.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataPengalamanKerjaPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter_bloc/flutter_bloc.dart';


// ignore: must_be_immutable
class CardDataPengalamanKerjaPengajuan extends StatefulWidget {
  GlobalKey<ScaffoldState> scaffoldKey;
  DataDatapengalamankerja dataPengalamanKerja;
  String jenis;
  PageDataPengalamanKerjaModel redaksional;

  CardDataPengalamanKerjaPengajuan(this.scaffoldKey,this.dataPengalamanKerja,this.jenis, this.redaksional);

  @override
  _CardDataPengalamanKerjaPengajuanState createState() => _CardDataPengalamanKerjaPengajuanState();
}

class _CardDataPengalamanKerjaPengajuanState extends State<CardDataPengalamanKerjaPengajuan> {

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<AuthBloc, LoginRespon>(
        builder: (context, stateLogin) {
          return  SingleChildScrollView(
            child: Container(
              width: MediaQuery.of(context).size.width,
              margin: EdgeInsets.all(10),
              child: Card(
                elevation: 5,
                shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(15)),
                child: Container(
                  margin: EdgeInsets.only(left: 13, right: 0),
                  child: Column(
                    children: [
                      Container(
                        padding: EdgeInsets.all(15),
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Text(widget.dataPengalamanKerja.title!,
                                style: TextStyle(color: CustomStyle.color1, fontWeight: FontWeight.w500, fontSize: 17)),
                            Row(
                              children: [
                                GestureDetector(
                                  onTap: (){
                                    if(widget.dataPengalamanKerja.buttonRevisi! && widget.dataPengalamanKerja.ketRevisi != ""){
                                      showDialog(context: context,
                                          barrierDismissible: false,
                                          builder: (_) => AlertDialog(
                                            shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(13)),
                                            title: Container(
                                              padding: EdgeInsets.only(top: 13, bottom: 13),
                                              decoration: BoxDecoration(
                                                  color: CustomStyle.color1,
                                                  borderRadius: BorderRadius.only(topLeft: Radius.circular(13), topRight: Radius.circular(13))
                                              ),
                                              child: Center(child: Text(widget.redaksional.menuDataPengalamanKerja!.button!.catatanRevisi!, style: TextStyle(fontWeight: FontWeight.bold, color: Colors.white, fontSize: 17),)),
                                            ),
                                            titlePadding: EdgeInsets.all(0),
                                            content: Container(
                                              child: Column(
                                                mainAxisSize: MainAxisSize.min,
                                                children: [
                                                  TextFormField(
                                                    // minLines: 1,
                                                      initialValue: widget.dataPengalamanKerja.ketRevisi??"",
                                                      maxLines: 6,
                                                      style: TextStyle(fontSize: 13, color: Colors.black),
                                                      decoration: InputDecoration(
                                                          disabledBorder: OutlineInputBorder(
                                                            borderRadius: BorderRadius.circular(13),
                                                            borderSide: BorderSide(
                                                              color: Colors.grey,
                                                              width: 0.8,
                                                            ),
                                                          ),
                                                          enabled: false,
                                                          labelStyle: TextStyle(color: Colors.grey),
                                                          fillColor: Colors.transparent,
                                                          filled: true
                                                      )
                                                  ),
                                                  SizedBox(height: 27),
                                                  Row(
                                                    children: [
                                                      Expanded(
                                                        child: TemplateButton(
                                                          onClick: (){
                                                            Navigator.pop(context);
                                                          },
                                                          label: widget.redaksional.menuDataPengalamanKerja!.button!.btnTutup,
                                                          color: Colors.transparent,
                                                          contentColor: CustomStyle.color1,
                                                          borderColor: CustomStyle.color1,
                                                          fontSize: CustomStyle.fontSizeSmall,
                                                          bold: true,
                                                        ),
                                                      ),
                                                    ],
                                                  )
                                                ],
                                              ),
                                            ),
                                          ));
                                    }
                                  },
                                  child: Container(
                                    decoration: BoxDecoration(
                                        color: Color(int.parse(widget.dataPengalamanKerja.colorStatusPengajuan!)),
                                        borderRadius: BorderRadius.circular(5)
                                    ),
                                    padding: EdgeInsets.all(5),
                                    child: Text(widget.dataPengalamanKerja.statusPengajuan??'',
                                      style: TextStyle(color: Colors.grey.shade600,fontWeight: FontWeight.bold, fontSize: 11),),
                                  ),
                                ),
                                SizedBox(width: 7),
                                widget.jenis == 'history' ? Container() :
                                stateLogin.dataLogin!.komponenMobile![9] == '0' ? Container() :
                                PopupMenuButton<String>(
                                  onSelected: (value) {
                                    if (value == widget.redaksional.menuDataPengalamanKerja!.button!.ubahData){
                                      if(widget.jenis == 'pengajuan'){
                                        BlocProvider.of<NavigatorBloc>(context).add(NavigateToHalamanEditPengajuanDataPengalamanKerja(context,widget.dataPengalamanKerja.idRiwayatPekerjaan));
                                      }else{
                                        BlocProvider.of<NavigatorBloc>(context).add(NavigateToHalamanEditDataPengalamanKerja(context,widget.dataPengalamanKerja.idRiwayatPekerjaan));
                                      }
                                    }
                                    else if(value == widget.redaksional.menuDataPengalamanKerja!.button!.hapusData) _showDialog(context, widget.jenis);
                                  },
                                  itemBuilder: (BuildContext context) {
                                    // return {'Hapus'}.map((String choice) {
                                    return widget.dataPengalamanKerja.buttonRevisi!
                                        ? {widget.redaksional.menuDataPengalamanKerja!.button!.ubahData!}.map((String choice) {
                                      return PopupMenuItem<String>(
                                        value: choice,
                                        child: Text(choice, style: TextStyle(fontSize: 12),),
                                      );
                                    }).toList()
                                        : {widget.redaksional.menuDataPengalamanKerja!.button!.ubahData!, widget.redaksional.menuDataPengalamanKerja!.button!.hapusData!}.map((String choice) {
                                      return PopupMenuItem<String>(
                                        value: choice,
                                        child: Text(choice, style: TextStyle(fontSize: 12),),
                                      );
                                    }).toList();
                                  },
                                  child: Icon(
                                    Icons.more_vert_sharp,
                                    color: CustomStyle.fontColorGrey,
                                  ),
                                )
                              ],
                            )
                          ],
                        ),
                      ),
                      Container(height: 0,child: Divider(thickness: 2,), margin: EdgeInsets.only(right: 13)),
                      Container(
                        padding: EdgeInsets.all(15),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataPengalamanKerja!.dataPengalamanKerja!.namaPerusahaan!, widget.dataPengalamanKerja.namaPerusahaan!)),
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataPengalamanKerja!.dataPengalamanKerja!.jenisPerusahaan!, widget.dataPengalamanKerja.jenisPerusahaan!)),
                              ],
                            ),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataPengalamanKerja!.dataPengalamanKerja!.jabatanTerakhir!, widget.dataPengalamanKerja.jabatan!)),
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataPengalamanKerja!.dataPengalamanKerja!.alamatPerusahaan!, widget.dataPengalamanKerja.alamatPerusahaan!)),
                              ],
                            ),
                            //
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataPengalamanKerja!.dataPengalamanKerja!.provinsi!,
                                        widget.dataPengalamanKerja.provinsi!)),
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataPengalamanKerja!.dataPengalamanKerja!.kabupaten!, widget.dataPengalamanKerja.kota!)),
                              ],
                            ),
                            //
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataPengalamanKerja!.dataPengalamanKerja!.tanggalMulaiKerja!, widget.dataPengalamanKerja.tglMasuk!)),
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataPengalamanKerja!.dataPengalamanKerja!.tanggalBerhentiKerja!, widget.dataPengalamanKerja.tglKeluar!)),
                              ],
                            ),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataPengalamanKerja!.dataPengalamanKerja!.alasanBerhenti!, widget.dataPengalamanKerja.alasanBerhenti!))
                              ],
                            ),
                            //
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                  child:
                                  Column(
                                    mainAxisAlignment: MainAxisAlignment.start,
                                    crossAxisAlignment: CrossAxisAlignment.start,
                                    children: [
                                      Text(
                                        widget.redaksional.menuDataPengalamanKerja!.dataPengalamanKerja!.lampiran!,
                                        style: TextStyle(color: Colors.grey[400], fontWeight: FontWeight.w700, fontSize: 13),),
                                      SizedBox(height: 9),
                                      widget.dataPengalamanKerja.file == null || widget.dataPengalamanKerja.file == "-"
                                          ? Text("-") : widget.dataPengalamanKerja.file == "" || widget.dataPengalamanKerja.file == "-" ? Text("-")
                                          : Image.network(widget.dataPengalamanKerja.file!)
                                    ],
                                  ),
                                ),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ),
          );
        });
  }

  void _showDialog(BuildContext ctx, String konteks){
    showDialog(context: ctx, builder: (_){
      return AlertDialog(
        shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(11)),
        content: Container(
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Icon(Icons.info_outline,size: 70,color: Colors.orange),
              SizedBox(height: 13),
              konteks == 'pengajuan'
                  ? Text('Apakah anda yakin menghapus data ini?', textAlign: TextAlign.center)
                  : Text('Apakah anda yakin mengajukan penghapusan data ini?', textAlign: TextAlign.center),
              SizedBox(height: 35),
              Row(
                children: [
                  Expanded(
                    child: TemplateButton(
                      onClick: (){
                        Navigator.pop(ctx);
                      },
                      label: "Batal",
                      color: Colors.transparent,
                      contentColor: Colors.black,
                      borderColor: CustomStyle.colorRed,
                      fontSize: CustomStyle.fontSizeNormal,
                      bold: true,
                    ),
                  ),
                  SizedBox(width: 7),
                  Expanded(
                    child: TemplateButton(
                      onClick: () {
                        Navigator.pop(ctx);
                        if(konteks == 'pengajuan'){
                          BlocProvider.of<DataPengalamanKerjaBloc>(ctx)
                              .add(deletePengajuanDataPengalamanKerjaEvent(ctx, widget.dataPengalamanKerja.idRiwayatPekerjaan));
                        }else{
                          BlocProvider.of<DataPengalamanKerjaBloc>(ctx)
                              .add(deleteDataPengalamanKerjaEvent(ctx, widget.dataPengalamanKerja.idRiwayatPekerjaan));
                        }
                      },
                      label: "Kirim",
                      color: Colors.teal,
                      contentColor: Colors.white,
                      borderColor: Colors.teal,
                      fontSize: CustomStyle.fontSizeNormal,
                      bold: true,
                    ),
                  )
                  // RaisedButton(onPressed: (){
                  //     Navigator.pop(ctx);
                  //     BlocProvider.of<DataKeluargaBloc>(ctx).add(
                  //         DeleteDataKeluargaEvent(
                  //             ctx,
                  //             scaffoldKey,
                  //             widget.dataKeluarga.idKeluarga
                  //         ));
                  //   }, child: Text('Ya'),color: Colors.teal,textColor: Colors.white,shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(11)))
                ],
              )
            ],
          ),
        ),
      );
    });
  }

  Widget formSee(String title, String data){
    return Container(
      margin: EdgeInsets.only(bottom: 15),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            title,
            style: TextStyle(color: Colors.grey, fontWeight: FontWeight.w400, fontSize: 12),),
          Text(
            data,
            style: TextStyle(color: Colors.black, fontWeight: FontWeight.w600, fontSize: 13.5),),
        ],
      ),
    );
  }
}