import 'package:absenkuv3/Bloc/Akun/KelengkapanFile/DataKelengkapanFileBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKelengkapanFilePage.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Akun/KelengkapanFile/CardDataKelengkapanFile.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanKelengkapanFileTerverifikasi extends StatefulWidget {
  final PageDataKelengkapanFileModel redaksional;
  HalamanKelengkapanFileTerverifikasi(this.redaksional);

  @override
  _HalamanKelengkapanFileTerverifikasiState createState() => _HalamanKelengkapanFileTerverifikasiState();
}

class _HalamanKelengkapanFileTerverifikasiState extends State<HalamanKelengkapanFileTerverifikasi> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<KelengkapanFileBloc>(context).add(getKelengkapanFileTerverifikasiEvent(context));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: BlocBuilder<KelengkapanFileBloc, KelengkapanFileState>(
          builder: (BuildContext context, KelengkapanFileState state){
            if(state is getKelengkapanFileSuccessState) {
              return ListView.builder(
                  physics: AlwaysScrollableScrollPhysics(),
                  controller: _scrollController,
                  itemCount: state.data!.length,
                  itemBuilder: (BuildContext context, index) {
                    return CardDataKelengkapanFilePengajuan(scaffoldKey,state.data![index],"data", widget.redaksional);
                  }
              );
            }
            else if(state is KelengkapanFileProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
            else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
          }
      ),
    );
  }

}
