import 'package:absenkuv3/Bloc/Akun/KelengkapanFile/DataKelengkapanFileBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/NotifBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKelengkapanFilePage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Akun/KelengkapanFile/CardDataKelengkapanFile.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanDetailNotifikasiKelengkapanFile extends StatefulWidget {
  DataNotifikasiAkun data;
  HalamanDetailNotifikasiKelengkapanFile(this.data);

  @override
  _HalamanDetailNotifikasiKelengkapanFileState createState() => _HalamanDetailNotifikasiKelengkapanFileState();
}

class _HalamanDetailNotifikasiKelengkapanFileState extends State<HalamanDetailNotifikasiKelengkapanFile> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<KelengkapanFileBloc>(context).add(getDetailDataKelengkapanFileByIdEvent(context, widget.data));
    BlocProvider.of<NotifBloc>(context).add(BacaNotifAkun(widget.data.idNotif, context));
  }

  Future<bool> keluar() async {
    Navigator.pop(context);
    BlocProvider.of<NavigatorBloc>(context).add(NavigateToReplacementHalamanNotifikasiAkun(context));
    return false;
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataKelengkapanFileModel>(
        future: PengaturanBahasa().dataKelengkapanFile(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
              key: scaffoldKey,
              appBar: AppBar(centerTitle: true,
                iconTheme: IconThemeData(color: CustomStyle.color15),
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
                title: Text(snapshot.data!.menuDataKelengkapanFile!.title!,
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle,color: CustomStyle.color15),
                ),
              ),
              body: BlocBuilder<KelengkapanFileBloc, KelengkapanFileState>(
                  builder: (BuildContext context, KelengkapanFileState state){
                    if(state is getKelengkapanFileSuccessState) {
                      return ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          controller: _scrollController,
                          itemCount: state.data!.length,
                          itemBuilder: (BuildContext context, index) {
                            return CardDataKelengkapanFilePengajuan(scaffoldKey,state.data![index],"history", snapshot.data!);
                          }
                      );
                    }
                    else if(state is KelengkapanFileProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                    else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
                  }
              ),
            );
          }else{
            return Container();
          }
        }
      ),
    );
  }

}
