import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mUbahPasswordPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:absenkuv3/UI/Template/templateFormPassword.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanUbahPassword extends StatefulWidget {
  @override
  _HalamanUbahPasswordState createState() => _HalamanUbahPasswordState();
}

class _HalamanUbahPasswordState extends State<HalamanUbahPassword> {
  GlobalKey<ScaffoldState> scaffoldKey = GlobalKey();
  final GlobalKey<FormState> formKey = GlobalKey<FormState>();
  TextEditingController passwordLama = new TextEditingController();
  TextEditingController passwordBaru = new TextEditingController();
  TextEditingController konfirmasiPasswordBaru = new TextEditingController();

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageUbahPasswordModel>(
        future: PengaturanBahasa().ubahPassword(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
              key: scaffoldKey,
              backgroundColor: Colors.white,
              appBar: AppBar(
                centerTitle: true,
                title: Text(
                  snapshot.data!.menuUbahPassword!.title!,
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                ),
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
              ),
              body: SingleChildScrollView(
                child: Container(
                  padding: EdgeInsets.fromLTRB(24, 24, 24, 18),
                  child: Form(
                    key: formKey,
                    child: Column(
                      children: [
                        TemplateFormPassword(
                          controller: passwordLama,
                          color: CustomStyle.formColor,
                          radius: CustomStyle.formRadius,
                          formHeight: CustomStyle.formHeight,
                          titleText: snapshot.data!.menuUbahPassword!.data!.passwordLama,
                        ),
                        TemplateFormPassword(
                          controller: passwordBaru,
                          color: CustomStyle.formColor,
                          radius: CustomStyle.formRadius,
                          formHeight: CustomStyle.formHeight,
                          titleText: "${snapshot.data!.menuUbahPassword!.data!.passwordBaru} ${snapshot.data!.menuUbahPassword!.data!.minimalKarakter}",
                        ),
                        TemplateFormPassword(
                          controller: konfirmasiPasswordBaru,
                          color: CustomStyle.formColor,
                          radius: CustomStyle.formRadius,
                          formHeight: CustomStyle.formHeight,
                          titleText: "${snapshot.data!.menuUbahPassword!.data!.konfirmasiPasswordBaru} ${snapshot.data!.menuUbahPassword!.data!.minimalKarakter}",
                        ),
                        SizedBox(
                          height: 12,
                        ),
                        TemplateButton(
                          onClick: () => BlocProvider.of<AuthBloc>(context).add(
                              GantiPasswordEvent(passwordLama.text, passwordBaru.text,
                                  konfirmasiPasswordBaru.text, context, scaffoldKey)),
                          radius: CustomStyle.formRadius + 6,
                          label: snapshot.data!.menuUbahPassword!.button!.btnUbahPassword,
                          color: CustomStyle.color1,
                          expand: true,
                          bold: true,
                          heightButton: 40,
                        ),
                      ],
                    ),
                  ),
                ),
              ),
            );
          }else{
            return Container();
          }
        }
    );
  
  }
}
