import 'package:absenkuv3/Bloc/Akun/DataKeluarga/DataKeluargaBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Bloc/NotifBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/mNotifikasiAkun.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKeluargaPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataKeluarga/CardDataKeluarga.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanDetailNotifikasiDataKeluarga extends StatefulWidget {
  final DataNotifikasiAkun data;
  HalamanDetailNotifikasiDataKeluarga(this.data);

  @override
  _HalamanDetailNotifikasiDataKeluargaState createState() => _HalamanDetailNotifikasiDataKeluargaState();
}

class _HalamanDetailNotifikasiDataKeluargaState extends State<HalamanDetailNotifikasiDataKeluarga> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataKeluargaBloc>(context).add(getDetailDataKeluargaByIdEvent(context, widget.data));
    BlocProvider.of<NotifBloc>(context).add(BacaNotifAkun(widget.data.idNotif, context));
  }

  Future<bool> keluar() async {
    Navigator.pop(context);
    BlocProvider.of<NavigatorBloc>(context).add(NavigateToReplacementHalamanNotifikasiAkun(context));
    return false;
  }


  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: keluar,
      child: FutureBuilder<PageDataKeluargaModel>(
        future: PengaturanBahasa().dataKeluarga(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
              key: scaffoldKey,
              appBar: AppBar(centerTitle: true,
                iconTheme: IconThemeData(color: CustomStyle.color15),
                flexibleSpace: Image(
                  image: AssetImage(ValueImage.headerBiruDashboard),
                  fit: BoxFit.cover,
                ),
                backgroundColor: Colors.transparent,
                title: Text(snapshot.data!.menuDataKeluarga!.title!,
                  style: TextStyle(fontSize: CustomStyle.fontSizeTitle,color: CustomStyle.color15),
                ),
              ),
              body: BlocBuilder<DataKeluargaBloc, DataKeluargaState>(
                  builder: (BuildContext context, DataKeluargaState state){
                    if(state is getDataKeluargaSuccessState) {
                      return ListView.builder(
                          physics: AlwaysScrollableScrollPhysics(),
                          controller: _scrollController,
                          itemCount: state.data!.length,
                          itemBuilder: (BuildContext context, index) {
                            return CardDataKeluargaPengajuan(scaffoldKey,state.data![index],"history", snapshot.data!);
                          }
                      );
                    }
                    else if(state is DataKeluargaProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                    else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
                  }
              ),
            );
          }else{
            return Container();
          }
        }
      ),
    );
  }

}
