import 'package:absenkuv3/Bloc/Akun/DataKeluarga/DataKeluargaBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKeluargaPage.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:absenkuv3/UI/Modul/Akun/DataKeluarga/CardDataKeluarga.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

class HalamanDataKeluargaPengajuan extends StatefulWidget {
  final PageDataKeluargaModel redaksional;
  HalamanDataKeluargaPengajuan(this.redaksional);

  @override
  _HalamanDataKeluargaPengajuanState createState() => _HalamanDataKeluargaPengajuanState();
}

class _HalamanDataKeluargaPengajuanState extends State<HalamanDataKeluargaPengajuan> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();
  ScrollController _scrollController = new ScrollController();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataKeluargaBloc>(context).add(getDataKeluargaPengajuanEvent(context));
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      key: scaffoldKey,
      body: BlocBuilder<DataKeluargaBloc, DataKeluargaState>(
          builder: (BuildContext context, DataKeluargaState state){
            if(state is getDataKeluargaSuccessState) {
              return ListView.builder(
                  physics: AlwaysScrollableScrollPhysics(),
                  controller: _scrollController,
                  itemCount: state.data!.length,
                  itemBuilder: (BuildContext context, index) {
                    return CardDataKeluargaPengajuan(scaffoldKey,state.data![index],"pengajuan", widget.redaksional);
                  }
              );
            }
            else if(state is DataKeluargaProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
            else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
          }
      ),
    );
  }

}
