import 'package:absenkuv3/Bloc/Akun/DataKeluarga/DataKeluargaBloc.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/Akun/DataKeluarga/mDataKeluarga.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataKeluargaPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/UI/Template/templateButton.dart';
import 'package:flutter/material.dart';
import 'package:absenkuv3/UI/Template/style.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

// ignore: must_be_immutable
class CardDataKeluargaPengajuan extends StatefulWidget {
  GlobalKey<ScaffoldState> scaffoldKey;
  DataDatakeluarga dataKeluarga;
  String jenis;
  PageDataKeluargaModel redaksional;

  CardDataKeluargaPengajuan(this.scaffoldKey,this.dataKeluarga,this.jenis, this.redaksional);

  @override
  _CardDataKeluargaPengajuanState createState() => _CardDataKeluargaPengajuanState();
}

class _CardDataKeluargaPengajuanState extends State<CardDataKeluargaPengajuan> {

  @override
  Widget build(BuildContext context) {
    return BlocBuilder<AuthBloc, LoginRespon>(
        builder: (context, stateLogin) {
          return SingleChildScrollView(
            child: Container(
              width: MediaQuery.of(context).size.width,
              margin: EdgeInsets.all(10),
              child: Card(
                elevation: 5,
                shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(15)),
                child: Container(
                  margin: EdgeInsets.only(left: 13, right: 0),
                  child: Column(
                    children: [
                      Container(
                        padding: EdgeInsets.all(15),
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Expanded(
                              child: Text(widget.dataKeluarga.hubKeluarga!,
                                  style: TextStyle(color: CustomStyle.color1, fontWeight: FontWeight.w500, fontSize: 17)),
                            ),
                            Expanded(
                              flex: 2,
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.end,
                                children: [
                                  GestureDetector(
                                    onTap: (){
                                      if(widget.dataKeluarga.buttonRevisi! && widget.dataKeluarga.ketRevisi != ""){
                                        showDialog(context: context,
                                            barrierDismissible: false,
                                            builder: (_) => AlertDialog(
                                              shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(13)),
                                              title: Container(
                                                padding: EdgeInsets.only(top: 13, bottom: 13),
                                                decoration: BoxDecoration(
                                                    color: CustomStyle.color1,
                                                    borderRadius: BorderRadius.only(topLeft: Radius.circular(13), topRight: Radius.circular(13))
                                                ),
                                                child: Center(child: Text(widget.redaksional.menuDataKeluarga!.button!.catatanRevisi!, style: TextStyle(fontWeight: FontWeight.bold, color: Colors.white, fontSize: 17),)),
                                              ),
                                              titlePadding: EdgeInsets.all(0),
                                              content: Container(
                                                child: Column(
                                                  mainAxisSize: MainAxisSize.min,
                                                  children: [
                                                    TextFormField(
                                                        minLines: 4,
                                                        initialValue: widget.dataKeluarga.ketRevisi??"",
                                                        maxLines: 6,
                                                        style: TextStyle(fontSize: 13, color: Colors.black),
                                                        decoration: InputDecoration(
                                                            disabledBorder: OutlineInputBorder(
                                                              borderRadius: BorderRadius.circular(13),
                                                              borderSide: BorderSide(
                                                                color: Colors.grey,
                                                                width: 0.8,
                                                              ),
                                                            ),
                                                            enabled: false,
                                                            labelStyle: TextStyle(color: Colors.grey),
                                                            fillColor: Colors.transparent,
                                                            filled: true
                                                        )
                                                    ),
                                                    SizedBox(height: 27),
                                                    Row(
                                                      children: [
                                                        Expanded(
                                                          child: TemplateButton(
                                                            onClick: (){
                                                              Navigator.pop(context);
                                                            },
                                                            label: widget.redaksional.menuDataKeluarga!.button!.btnTutup,
                                                            color: Colors.transparent,
                                                            contentColor: CustomStyle.color1,
                                                            borderColor: CustomStyle.color1,
                                                            fontSize: CustomStyle.fontSizeSmall,
                                                            bold: true,
                                                          ),
                                                        ),
                                                      ],
                                                    )
                                                  ],
                                                ),
                                              ),
                                            ));
                                      }
                                    },
                                    child: Container(
                                      decoration: BoxDecoration(
                                          color: Color(int.parse(widget.dataKeluarga.colorStatusPengajuan!)),
                                          borderRadius: BorderRadius.circular(5)
                                      ),
                                      padding: EdgeInsets.all(5),
                                      child: Text(widget.dataKeluarga.statusPengajuan??'',
                                          style: TextStyle(color: Colors.grey.shade600,fontWeight: FontWeight.bold, fontSize: 11)),
                                    ),
                                  ),
                                  SizedBox(width: 7),
                                  widget.jenis == 'history' ? Container() :
                                  stateLogin.dataLogin!.komponenMobile![9] == '0' ? Container() :
                                  PopupMenuButton<String>(
                                    onSelected: (value) {
                                      if (value == widget.redaksional.menuDataKeluarga!.button!.ubahData){
                                        if(widget.jenis == 'pengajuan'){
                                          BlocProvider.of<NavigatorBloc>(context).add(NavigateToHalamanEditPengajuanDataKeluarga(context,widget.dataKeluarga.idKeluarga));
                                        }else{
                                          BlocProvider.of<NavigatorBloc>(context).add(NavigateToHalamanEditDataKeluarga(context,widget.dataKeluarga.idKeluarga));
                                        }
                                      }
                                      else if(value == widget.redaksional.menuDataKeluarga!.button!.hapusData) _showDialog(context, widget.jenis, widget.redaksional);
                                    },
                                    itemBuilder: (BuildContext context) {
                                      // return {'Hapus'}.map((String choice) {
                                      return widget.dataKeluarga.buttonRevisi!
                                          ? {widget.redaksional.menuDataKeluarga!.button!.ubahData!}.map((String choice) {
                                        return PopupMenuItem<String>(
                                          value: choice,
                                          child: Text(choice, style: TextStyle(fontSize: 12),),
                                        );
                                      }).toList()
                                          : {widget.redaksional.menuDataKeluarga!.button!.ubahData!, widget.redaksional.menuDataKeluarga!.button!.hapusData!}.map((String choice) {
                                        return PopupMenuItem<String>(
                                          value: choice,
                                          child: Text(choice, style: TextStyle(fontSize: 12),),
                                        );
                                      }).toList();
                                    },
                                    child: Icon(
                                      Icons.more_vert_sharp,
                                      color: CustomStyle.fontColorGrey,
                                    ),
                                  )
                                ],
                              ),
                            )
                          ],
                        ),
                      ),
                      Container(height: 0,child: Divider(thickness: 2,), margin: EdgeInsets.only(right: 13)),
                      Container(
                        padding: EdgeInsets.all(15),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.nik!, widget.dataKeluarga.nik!)),
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.namaLengkap!, widget.dataKeluarga.namaLengkap!)),
                              ],
                            ),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.tempatLahir!, widget.dataKeluarga.tempatLahir!)),
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.tanggalLahir!, widget.dataKeluarga.tglLahir!)),
                              ],
                            ),
                            //
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.jenisKelamin!,
                                        widget.dataKeluarga.jenisKelamin!)),
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.agama!, widget.dataKeluarga.agama!)),
                              ],
                            ),
                            //
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.pendidikanTerakhir!, widget.dataKeluarga.pendidikanTerakhir!)),
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.pekerjaan!, widget.dataKeluarga.pekerjaan!)),
                              ],
                            ),
                            //
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.statusPerkawinan!, widget.dataKeluarga.statusPerkawinan!)),
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.tanggalPerkawinan!, widget.dataKeluarga.tanggalPerkawinan!)),
                              ],
                            ),

                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.telepon!, widget.dataKeluarga.telepon!)),
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.noBpjsKes!, widget.dataKeluarga.noBpjs!)),
                              ],
                            ),
                            Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                Expanded(
                                    child: formSee(widget.redaksional.menuDataKeluarga!.dataKeluarga!.status!, widget.dataKeluarga.status!)),
                                Expanded(
                                    child: formSee("", "")),
                              ],
                            ),
                          ],
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ),
          );
        });
  }

  void _showDialog(BuildContext ctx, String konteks, PageDataKeluargaModel redaksional){
    showDialog(context: ctx, builder: (_){
      return AlertDialog(
        shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(11)),
        content: Container(
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: [
              Icon(Icons.info_outline,size: 70,color: Colors.orange),
              SizedBox(height: 13),
              konteks == 'pengajuan'
                  ? Text(redaksional.menuDataKeluarga!.message!.hapusData!, textAlign: TextAlign.center)
                  : Text(redaksional.menuDataKeluarga!.message!.pengajuanHapus!, textAlign: TextAlign.center),
              SizedBox(height: 35),
              Row(
                children: [
                  Expanded(
                    child: TemplateButton(
                      onClick: (){
                        Navigator.pop(ctx);
                      },
                      label: redaksional.menuDataKeluarga!.button!.btnBatal,
                      color: Colors.transparent,
                      contentColor: Colors.black,
                      borderColor: CustomStyle.colorRed,
                      fontSize: CustomStyle.fontSizeNormal,
                      bold: true,
                    ),
                  ),
                  SizedBox(width: 7),
                  Expanded(
                    child: TemplateButton(
                      onClick: () {
                        Navigator.pop(ctx);
                        if(konteks == 'pengajuan'){
                          BlocProvider.of<DataKeluargaBloc>(ctx)
                              .add(deletePengajuanDataKeluargaEvent(ctx, widget.dataKeluarga.idKeluarga));
                        }else{
                          BlocProvider.of<DataKeluargaBloc>(ctx)
                              .add(deleteDataKeluargaEvent(ctx, widget.dataKeluarga.idKeluarga));
                        }
                      },
                      label: redaksional.menuDataKeluarga!.button!.btnYa,
                      color: Colors.teal,
                      contentColor: Colors.white,
                      borderColor: Colors.teal,
                      fontSize: CustomStyle.fontSizeNormal,
                      bold: true,
                    ),
                  )
                  // RaisedButton(onPressed: (){
                  //     Navigator.pop(ctx);
                  //     BlocProvider.of<DataKeluargaBloc>(ctx).add(
                  //         DeleteDataKeluargaEvent(
                  //             ctx,
                  //             scaffoldKey,
                  //             widget.dataKeluarga.idKeluarga
                  //         ));
                  //   }, child: Text('Ya'),color: Colors.teal,textColor: Colors.white,shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(11)))
                ],
              )
            ],
          ),
        ),
      );
    });
  }

  Widget formSee(String title, String data){
    return Container(
      margin: EdgeInsets.only(bottom: 15),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            title,
            style: TextStyle(color: Colors.grey, fontWeight: FontWeight.w400, fontSize: 12),),
          Text(
            data,
            style: TextStyle(color: Colors.black, fontWeight: FontWeight.w600, fontSize: 13.5),),
        ],
      ),
    );
  }
}