import 'package:absenkuv3/Bloc/Akun/DataDiri/DataDiriBloc.dart';
import 'package:absenkuv3/Bloc/AuthBloc.dart';
import 'package:absenkuv3/Bloc/NavigatorBloc.dart';
import 'package:absenkuv3/Repository/Model/PageModel/mDataDiriPage.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:absenkuv3/UI/Template/style.dart';

class HalamanDataDiri extends StatefulWidget {

  @override
  _HalamanDataDiriState createState() => _HalamanDataDiriState();
}

class _HalamanDataDiriState extends State<HalamanDataDiri> {

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataDiriBloc>(context).add(getDataDiriEvent(context));
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageDataDiriModel>(
        future: PengaturanBahasa().dataDiri(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return BlocBuilder<AuthBloc, LoginRespon>(
                builder: (context, stateLogin) {
                  return Scaffold(
                    body: BlocBuilder<DataDiriBloc, DataDiriState>(
                        builder: (BuildContext context, DataDiriState state){
                          if(state is getDataDiriSuccessState)
                            return SingleChildScrollView(
                              child: Container(
                                width: MediaQuery.of(context).size.width,
                                margin: EdgeInsets.fromLTRB(21, 10, 10, 10),
                                child: Column(
                                  mainAxisAlignment: MainAxisAlignment.start,
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Container(
                                      child: Column(
                                        crossAxisAlignment: CrossAxisAlignment.start,
                                        children: [
                                          SizedBox(height: 5),
                                          Row(
                                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                            children: [
                                              Text(snapshot.data!.menuDataDiri!.dataDiri!.header!,style: TextStyle(color: CustomStyle.color1,fontWeight: FontWeight.bold)),
                                              Row(
                                                children: [
                                                  Container(
                                                      decoration: BoxDecoration(
                                                          color: Colors.green.shade100,
                                                          borderRadius: BorderRadius.circular(3)
                                                      ),
                                                      padding: EdgeInsets.all(5),
                                                      child: Text(state.data!.statusPengajuan!,style: TextStyle(color: Color(int.parse(state.data!.colorStatusPengajuan!)),
                                                          fontWeight: FontWeight.w700, fontSize: 12))),
                                                  SizedBox(width: 7),
                                                  stateLogin.dataLogin!.komponenMobile![9] == '0' ? Container() :
                                                  PopupMenuButton<String>(
                                                    onSelected: (value) {
                                                      if (value == snapshot.data!.menuDataDiri!.button!.ubahData)
                                                        BlocProvider.of<NavigatorBloc>(context)
                                                            .add(NavigateToHalamanEditDataDiri(context));
                                                    },
                                                    itemBuilder: (BuildContext context) {
                                                      return {snapshot.data!.menuDataDiri!.button!.ubahData!}.map((String choice) {
                                                        return PopupMenuItem<String>(
                                                          value: choice,
                                                          child: Text(choice, style: TextStyle(fontSize: 12),),
                                                        );
                                                      }).toList();
                                                    },
                                                    child: Icon(
                                                      Icons.more_vert_sharp,
                                                      color: CustomStyle.fontColorGrey,
                                                    ),
                                                  )
                                                ],
                                              ),
                                            ],
                                          ),
                                          // SizedBox(height: 5),
                                          Divider(thickness: 1),
                                          SizedBox(height: 5)
                                        ],
                                      ),
                                    ),
                                    formSee(snapshot.data!.menuDataDiri!.dataDiri!.nomorIndukKaryawan!, state.data!.nik!),
                                    formSee(snapshot.data!.menuDataDiri!.dataDiri!.namaLengkap!, state.data!.namaLengkap!),
                                    formSee(snapshot.data!.menuDataDiri!.dataDiri!.pendidikanTerakhir!, state.data!.pendidikanTerakhir!),
                                    Row(
                                      children: [
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.gelarDepan!, state.data!.gelarDepan!)),
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.gelarBelakang!, state.data!.gelarBelakang!)),
                                      ],
                                    ),
                                    Row(
                                      children: [
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.jenisKelamin!, state.data!.jenisKelamin!)),
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.golonganDarah!, state.data!.golonganDarah!)),
                                      ],
                                    ),
                                    Row(
                                      children: [
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.tempatLahir!, state.data!.tempatLahir!)),
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.tanggalLahir!, state.data!.tglLahir!)),
                                      ],
                                    ),
                                    Row(
                                      children: [
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.noTelepon!, state.data!.telepon!)),
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.agama!, state.data!.agama!)),
                                      ],
                                    ),
                                    Row(
                                      children: [
                                        Expanded(child: formSee("${snapshot.data!.menuDataDiri!.dataDiri!.nomorIndukKaryawan}", state.data!.noKtp!)),
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.noBpjsKes!, state.data!.noBpjsKes!)),
                                      ],
                                    ),
                                    Row(
                                      children: [
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataDiri!.noBpjsTk!, state.data!.noBpjsTk!)),
                                        Expanded(child: formSee("", "")),
                                      ],
                                    ),
                                    Container(
                                        margin: EdgeInsets.only(top: 15),
                                        child: Column(
                                          crossAxisAlignment: CrossAxisAlignment.start,
                                          children: [
                                            SizedBox(height: 5),
                                            Text(snapshot.data!.menuDataDiri!.dataAlamat!.header!,style: TextStyle(color: CustomStyle.color1,fontWeight: FontWeight.bold)),
                                            SizedBox(height: 5),
                                            Divider(thickness: 1),
                                            SizedBox(height: 5)
                                          ],
                                        )
                                    ),
                                    Row(
                                      children: [
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.provinsi!, state.data!.namaProvinsi!)),
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.kabupaten!, state.data!.namaKabupaten!)),
                                      ],
                                    ),
                                    Row(
                                      children: [
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.kecamatan!, state.data!.namaKecamatan!)),
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.kelurahan!, state.data!.namaKelurahan!)),
                                      ],
                                    ),
                                    Row(
                                      children: [
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.rt!, state.data!.rt == null ? "-" : state.data!.rt == "" ? "-" : state.data!.rt!)),
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.rw!, state.data!.rw == null ? "-" : state.data!.rw == "" ? "-" : state.data!.rw!)),
                                      ],
                                    ),
                                    Row(
                                      children: [
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.alamatDomisili!, state.data!.alamatDomisili == null ? "-" : state.data!.alamatDomisili == "" ? "-" : state.data!.alamatDomisili!)),
                                        Expanded(child: formSee(snapshot.data!.menuDataDiri!.dataAlamat!.kodePos!, state.data!.kodePos == null ? "-" : state.data!.kodePos == "" ? "-" : state.data!.kodePos!)),
                                      ],
                                    ),
                                  ],
                                ),
                              ),
                            );
                          else if(state is DataDiriProgressState) return Center(child: CircularProgressIndicator(strokeWidth: 8,),);
                          else return Center(child: Image.asset(ValueImage.noData, height: 250,),);
                        }
                    ),
                  );
                }
            );
          }else{
            return Container();
          }
        }
    );
  }

  Widget formSee(String title, String data){
    return Container(
      margin: EdgeInsets.only(bottom: 15, left: 15, right: 15),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.start,
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Text(
            title,
            style: TextStyle(color: Color(0xFF828282), fontSize: 11.5)),
          SizedBox(height: 3),
          Text(
            data,
            style: TextStyle(color: Colors.black, fontWeight: FontWeight.w500, fontSize: 13)),
        ],
      ),
    );
  }

}
