import 'package:absenkuv3/Repository/Model/PageModel/mDetailAbsensiPage.dart';
import 'package:absenkuv3/Setting/PengaturanBahasa.dart';
import 'package:absenkuv3/Setting/value_image.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../../../Bloc/Absensi/DataDetailAbsensiBloc.dart';
import '../../../Bloc/NavigatorBloc.dart';
import '../../../Repository/Model/mAbsensi.dart';
import '../../Template/halamanDetailMap.dart';
import '../../Template/style.dart';
import '../../Template/templateButton.dart';

class HalamanDetailListAbsensi extends StatefulWidget {
  final List<String> data;

  HalamanDetailListAbsensi(this.data);
  @override
  _HalamanDetailListAbsensiState createState() =>
      _HalamanDetailListAbsensiState();
}

class _HalamanDetailListAbsensiState extends State<HalamanDetailListAbsensi> {
  final GlobalKey<ScaffoldState> scaffoldKey = GlobalKey<ScaffoldState>();

  @override
  void initState() {
    super.initState();
    BlocProvider.of<DataDetailAbsensiBloc>(context).add(
        getDataDetailAbsensiEvent(
            context, null, widget.data[0], widget.data[1]));
  }

  @override
  Widget build(BuildContext context) {
    return FutureBuilder<PageDetailAbsensiModel>(
        future: PengaturanBahasa().detailAbsensi(),
        builder: (context, snapshot) {
          if(snapshot.connectionState == ConnectionState.done){
            return Scaffold(
                key: scaffoldKey,
                backgroundColor: Colors.white,
                appBar: AppBar(
                  flexibleSpace: Image(
                    image: AssetImage(ValueImage.headerBiruDashboard),
                    fit: BoxFit.cover,
                  ),
                  backgroundColor: Colors.transparent,
                  centerTitle: true,
                  title: Text(
                    snapshot.data!.menuDetailAbsensi!.title!,
                    style: TextStyle(fontSize: CustomStyle.fontSizeTitle),
                  ),
                ),
                body: BlocBuilder<DataDetailAbsensiBloc, DataDetailAbsensiState>(
                    builder: (BuildContext context, DataDetailAbsensiState state) {
                      if (state is getDataDetailAbsensiSuccessState) {
                        DataRekapAbsensi data = state.data!.first;
                        return 
                        SingleChildScrollView(
                          child: Container(
                            padding: EdgeInsets.all(20),
                            child: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                komponenKalendar(data: data,redaksional: snapshot.data!.menuDetailAbsensi,),
                                SizedBox(
                                  height: 15,
                                ),
                                KomponenCardAbsensi(
                                  data: data,
                                  title: snapshot.data!.menuDetailAbsensi!.data!.absensi!.header,
                                  redaksional: snapshot.data!.menuDetailAbsensi,
                                ),
                                SizedBox(
                                  height: 15,
                                ),
                                KomponenCardAbsensi(
                                  data: data,
                                  title: snapshot.data!.menuDetailAbsensi!.data!.istirahat!.header,
                                  redaksional: snapshot.data!.menuDetailAbsensi,
                                )
                              ],
                            ),
                          ),
                        );
                      } else if (state is DataDetailAbsensiProgressState) {
                        return Center(
                          child: CircularProgressIndicator(
                            strokeWidth: 8,
                          ),
                        );
                      } else {
                        return Center(
                          child: Image.asset(
                            ValueImage.noData,
                            height: 250,
                          ),
                        );
                      }
                    }));
          }else{
            return CircularProgressIndicator(strokeWidth: 8);
          }
        }
    );


  }
}

class komponenKalendar extends StatelessWidget {
  final DataRekapAbsensi? data;
  final MenuDetailAbsensi? redaksional;
  komponenKalendar({Key? key, this.data,this.redaksional}) : super(key: key);

  @override
  Widget build(BuildContext context) {

    return Column(
      mainAxisAlignment: MainAxisAlignment.start,
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          children: [
            Row(
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                Icon(
                  Icons.calendar_month_outlined,
                  size: 28,
                ),
                SizedBox(
                  width: 10,
                ),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Text(
                      data!.tglAbsensi.toString(),
                      style:
                          TextStyle(fontSize: 14, fontWeight: FontWeight.w600),
                    ),
                    SizedBox(
                      height: 4,
                    ),
                    Text(
                      "${data!.jadwalAbsensi!.jenis.toString()} (${data!.jadwalAbsensi!.jamKerja})",
                      style: TextStyle(
                          fontSize: 12,
                          fontWeight: FontWeight.w400,
                          color: CustomStyle.fontColorGrey),
                    ),
                  ],
                ),
              ],
            ),
            Wrap(
              spacing: 8,
              runSpacing: 4,
              children: data!.jadwalAbsensi!.kodeAbsensi!
                  .map(
                    (item) => Container(
                        padding: EdgeInsets.only(bottom: 4),
                        child: TemplateButton(
                          label: item.kodeAbsensi,
                          fontSize: 16,
                          color: Colors.redAccent,
                          heightButton: 20,
                          radius: 4,
                          paddingTopBottom: 0,
                          paddingLeftRight: 8,
                          contentColor: Colors.white,
                          bold: true,
                        )),
                  )
                  .toList(),
            )
          ],
        ),
        SizedBox(
          height: 18,
        ),
        InfoDisplay(label: redaksional!.data!.dataKaryawan!.nama.toString(), value: data!.karyawan!.nama.toString()),
        InfoDisplay(label: redaksional!.data!.dataKaryawan!.nik.toString(), value: data!.karyawan!.nik.toString()),
        InfoDisplay(label: redaksional!.data!.dataKaryawan!.jabatan.toString(), value: data!.karyawan!.jabatan.toString()),
        InfoDisplay(label: redaksional!.data!.dataKaryawan!.cabang.toString(), value: data!.karyawan!.cabang.toString()),
        InfoDisplay(label: redaksional!.data!.dataKaryawan!.departemen.toString(), value: data!.karyawan!.departemen.toString()),
        Divider(
          thickness: 2,
        )
      ],
    );
  }
}
class InfoDisplay extends StatelessWidget {
  final String label;
  final String value;
  final Color labelColor;
  final FontWeight valueFontWeight;

  const InfoDisplay({
    Key? key,
    required this.label,
    required this.value,
    this.labelColor = Colors.grey,
    this.valueFontWeight = FontWeight.bold,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          '$label',
          style: TextStyle(
            fontWeight: FontWeight.w400,
            color: labelColor,
          ),
        ),
        SizedBox(height: 3),
        Text(
          value,
          style: TextStyle(
            fontWeight: valueFontWeight,
          ),
        ),
        SizedBox(height: 15),
      ],
    );
  }
}
class KomponenCardAbsensi extends StatelessWidget {
  final DataRekapAbsensi? data;
  final String? title;
  final MenuDetailAbsensi? redaksional;

  KomponenCardAbsensi({Key? key, this.data, this.title, this.redaksional}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    String? titleMulai;
    String? titleSelesai;
    String? jamAbsenMasuk;
    String? keteranganMasuk;
    String? fotoMasuk;
    String? latMasuk;
    String? longMasuk;

    String? jamAbsenPulang;
    String? keteranganPulang;
    String? fotoPulang;
    String? latPulang;
    String? longPulang;
    if (title == redaksional!.data!.absensi!.header) {
      titleMulai = redaksional!.data!.absensi!.masuk;
      titleSelesai = redaksional!.data!.absensi!.pulang;
      jamAbsenMasuk = data!.absensiMasuk!.jam;
      keteranganMasuk = data!.absensiMasuk!.keterangan;
      fotoMasuk = data!.absensiMasuk!.foto;
      latMasuk = data!.absensiMasuk!.lat;
      longMasuk = data!.absensiMasuk!.long;

      jamAbsenPulang = data!.absensiPulang!.jam;
      keteranganPulang = data!.absensiPulang!.keterangan;
      fotoPulang = data!.absensiPulang!.foto;
      latPulang = data!.absensiPulang!.lat;
      longPulang = data!.absensiPulang!.long;
    } else if (title == redaksional!.data!.istirahat!.header) {
      titleMulai = redaksional!.data!.istirahat!.mulaiIstirahat;
      titleSelesai = redaksional!.data!.istirahat!.selesaiIstirahat;
      jamAbsenMasuk = data!.istirahatMulai!.jam;
      keteranganMasuk = data!.istirahatMulai!.keterangan;
      fotoMasuk = data!.istirahatMulai!.foto;
      latMasuk = data!.istirahatMulai!.lat;
      longMasuk = data!.istirahatMulai!.long;

      jamAbsenPulang = data!.istirahatSelesai!.jam;
      keteranganPulang = data!.istirahatSelesai!.keterangan;
      fotoPulang = data!.istirahatSelesai!.foto;
      latPulang = data!.istirahatSelesai!.lat;
      longPulang = data!.istirahatSelesai!.long;
    }
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Text(
          title!,
          style: TextStyle(fontSize: 16, fontWeight: FontWeight.w600),
        ),
        SizedBox(
          height: 20,
        ),
        Container(
          decoration: BoxDecoration(
              color: Colors.green,
              borderRadius:
                  BorderRadius.all(Radius.circular(CustomStyle.cardRadius))),
          child: Container(
              margin: EdgeInsets.only(left: 5),
              decoration: CustomStyle.boxDecoration2,
              child: Container(
                padding: EdgeInsets.all(15),
                child: Row(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Expanded(
                      flex: 2,
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            titleMulai.toString(),
                            style: TextStyle(
                                fontSize: 12,
                                fontWeight: FontWeight.w400,
                                color: CustomStyle.fontColorGrey),
                          ),
                          SizedBox(
                            height: 8,
                          ),
                          Text(
                            jamAbsenMasuk.toString(),
                            style: TextStyle(
                                fontSize: 12, fontWeight: FontWeight.w600),
                          ),
                          SizedBox(
                            height: 12,
                          ),
                          Text(
                            redaksional!.data!.absensi!.keterangan!,
                            style: TextStyle(
                                fontSize: 12,
                                fontWeight: FontWeight.w400,
                                color: CustomStyle.fontColorGrey),
                          ),
                          SizedBox(
                            height: 8,
                          ),
                          Text(
                            keteranganMasuk.toString(),
                            style: TextStyle(
                                fontSize: 12, fontWeight: FontWeight.w600),
                          ),
                          SizedBox(
                            height: 12,
                          ),
                        ],
                      ),
                    ),
                    Row(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Row(
                          children: [
                            fotoMasuk != '-'
                                ? GestureDetector(
                                    onTap: () =>
                                        BlocProvider.of<NavigatorBloc>(context)
                                            .add(NavigateToDetailImageClicked(
                                                context, fotoMasuk)),
                                    child: ClipOval(
                                      child: Image.network(
                                        fotoMasuk.toString(),
                                        height: 30,
                                        width: 30,
                                        fit: BoxFit.cover,
                                        errorBuilder: (BuildContext context,
                                            Object exception,
                                            StackTrace? stackTrace) {
                                          return Icon(
                                            Icons.image,
                                            size: 30,
                                          );
                                        },
                                      ),
                                    ))
                                : Container(),
                            SizedBox(
                              width: 4,
                            ),
                            latMasuk!.isNotEmpty && latMasuk != '-'
                                ? GestureDetector(
                                    onTap: () =>
                                        BlocProvider.of<NavigatorBloc>(context)
                                            .add(NavigateToDetailMap(
                                                context,
                                                ModelDetailMap(
                                                    "Lokasi Absen $title",
                                                    double.parse(latMasuk!),
                                                    double.parse(longMasuk!)))),
                                    child: Icon(
                                      Icons.pin_drop,
                                      size: 30,
                                      color: Colors.redAccent,
                                    ),
                                  )
                                : Container(),
                          ],
                        )
                      ],
                    )
                  ],
                ),
              )),
        ),
        SizedBox(
          height: 12,
        ),
        Container(
          decoration: BoxDecoration(
              color: Colors.redAccent,
              borderRadius:
                  BorderRadius.all(Radius.circular(CustomStyle.cardRadius))),
          child: Container(
            margin: EdgeInsets.only(left: 5),
            decoration: CustomStyle.boxDecoration2,
            child: Container(
              padding: EdgeInsets.all(15),
              child: Row(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Expanded(
                    flex: 2,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(
                          titleSelesai.toString(),
                          style: TextStyle(
                              fontSize: 12,
                              fontWeight: FontWeight.w400,
                              color: CustomStyle.fontColorGrey),
                        ),
                        SizedBox(
                          height: 8,
                        ),
                        Text(
                          jamAbsenPulang.toString(),
                          style: TextStyle(
                              fontSize: 12, fontWeight: FontWeight.w600),
                        ),
                        SizedBox(
                          height: 12,
                        ),
                        Text(
                          redaksional!.data!.istirahat!.keterangan!,
                          style: TextStyle(
                              fontSize: 12,
                              fontWeight: FontWeight.w400,
                              color: CustomStyle.fontColorGrey),
                        ),
                        SizedBox(
                          height: 8,
                        ),
                        Text(
                          keteranganPulang.toString(),
                          style: TextStyle(
                              fontSize: 12, fontWeight: FontWeight.w600),
                        ),
                        SizedBox(
                          height: 12,
                        ),
                      ],
                    ),
                  ),
                  Row(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        children: [
                          fotoPulang != '-'
                              ? GestureDetector(
                                  onTap: () =>
                                      BlocProvider.of<NavigatorBloc>(context)
                                          .add(NavigateToDetailImageClicked(
                                              context, fotoPulang)),
                                  child: ClipOval(
                                    child: Image.network(
                                      fotoPulang.toString(),
                                      height: 30,
                                      width: 30,
                                      fit: BoxFit.cover,
                                      errorBuilder: (BuildContext context,
                                          Object exception,
                                          StackTrace? stackTrace) {
                                        return Icon(
                                          Icons.image,
                                          size: 30,
                                        );
                                      },
                                    ),
                                  ))
                              : Container(),
                          SizedBox(
                            width: 4,
                          ),
                          latPulang!.isNotEmpty && latPulang != '-'
                              ? GestureDetector(
                                  onTap: () =>
                                      BlocProvider.of<NavigatorBloc>(context)
                                          .add(NavigateToDetailMap(
                                              context,
                                              ModelDetailMap(
                                                  "Lokasi Absen $title",
                                                  double.parse(latPulang!),
                                                  double.parse(longPulang!)))),
                                  child: Icon(
                                    Icons.pin_drop,
                                    size: 30,
                                    color: Colors.redAccent,
                                  ),
                                )
                              : Container(),
                        ],
                      )
                    ],
                  )
                ],
              ),
            ),
          ),
        )
      ],
    );
  }
}
