import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSos.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:dio/dio.dart';
import '../../Setting/Header.dart';
import 'package:intl/intl.dart';

class SosApi{
  Dio dio = ServerInfo().getConnection();
    final dateFormat = new DateFormat('yyyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');
    Future<BasicRespon> pengajuanSos(ModelPengajuanSos data) async {
    Map<String, dynamic> parameters;
    parameters = {
      "keterangan": data.keterangan,
      "id_klien": data.idKlien,
    };

    if (data.listImage != null) {
      int imageCount = 0;
      for (int i = 0; i < data.listImage!.length; i++) {
        imageCount++;
        parameters.putIfAbsent(
            'image${i + 1}', () => data.listImage![i].base64);
      }
      parameters.putIfAbsent('image_count', () => imageCount);
    }

    var respon = await dio.post("sos/pengajuan",
        data: parameters,
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }
  Future<SosRespon> getDataSos(
      offset, konteks, ModelFilter? modelFilter) async {
    var respon = await dio.get("sos/data",
        queryParameters: {
          "id_karyawan_select":
              modelFilter != null ? modelFilter.idPegawai ?? null : null,
          "id_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
          "id_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": konteks,
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
          "status": modelFilter != null && modelFilter.status != null
              ? modelFilter.status
              : null
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return sosResponFromJson(respon.data);
    } else {
      return SosRespon(success: false);
    }
  }
  Future<SosRespon> getDataklienSos(
      offset, konteks, ModelFilter? modelFilter) async {
    var respon = await dio.get("sos/klien/data",
        queryParameters: {
          "id_karyawan_select":
              modelFilter != null ? modelFilter.idPegawai ?? null : null,
          "id_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
          "id_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": konteks,
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
          "status": modelFilter != null && modelFilter.status != null
              ? modelFilter.status
              : null
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return sosResponFromJson(respon.data);
    } else {
      return SosRespon(success: false);
    }
  }
  Future<SosRespon> getDetailDataSos(
      String? id_sos, konteks) async {
    var respon = await dio.get("sos/data",
        queryParameters: {
          "id_sos":id_sos,
          "konteks":konteks
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return sosResponFromJson(respon.data);
    } else {
      return SosRespon(success: false);
    }
  }

}