import 'package:absenkuv3/Repository/Model/mChekpoint.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/Model/mValidasi.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';

class PatroliApi {
  final dateFormat = new DateFormat('yyy-MM-dd');
  final monthYearFormat = new DateFormat('yyyy-MM');

  Dio dio = ServerInfo().getConnection();

  Future<CheckpointRespon> getDataChekpoint(
      offset, ModelFilter? modelFilter) async {
    var respon = await dio.get("patroli/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": 'checkpointSaya',
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return checkpointResponFromJson(respon.data);
    } else {
      return CheckpointRespon(success: false);
    }
  }

  Future<CheckpointRespon> getDataDetailChekpoint(idChekpoint) async {
    var respon = await dio.get("patroli/data",
        queryParameters: {
          "limit": ServerInfo.limit,
          "offset": 0,
          "konteks": 'detailCheckpoint',
          "id_checkpoint": idChekpoint,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return checkpointResponFromJson(respon.data);
    } else {
      return CheckpointRespon(success: false);
    }
  }

  Future<CheckpointRespon> getDataChekpointPegawai(
      offset, ModelFilter? modelFilter) async {
    var respon = await dio.get("patroli/data",
        queryParameters: {
          "id_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
          "id_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "id_karyawan_select":
              modelFilter != null ? modelFilter.idPegawai ?? null : null,
          "limit": ServerInfo.limit,
          "offset": offset,
          "konteks": 'checkpointPegawai',
          "month_year": modelFilter != null && modelFilter.monthYear != null
              ? monthYearFormat.format(modelFilter.monthYear!).toString()
              : null,
          "range_tanggal_mulai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![0]).toString()
                  : null,
          "range_tanggal_selesai":
              modelFilter != null && modelFilter.dateRange != null
                  ? dateFormat.format(modelFilter.dateRange![1]).toString()
                  : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return checkpointResponFromJson(respon.data);
    } else {
      return CheckpointRespon(success: false);
    }
  }

  Future<CekLokasiRespon?> cekLokasi(DataAbsensi data) async {
    // print('wkwk');
    // print(data);
    var respon = await dio.get("patroli/lokasi",
        queryParameters: {
          "latitude": data.latitude,
          "longitude": data.longitude,
        },
        options: Options(headers: await Header().getHeader()));
    // print("ini response chek lokasi ${respon}");
    if (respon.statusCode == 200) {
      return cekLokasiResponFromJson(respon.data);
    } else {
      return null;
    }
  }

  //ABSENSI LEMBUR POST
  Future<BasicRespon> tambahChekpoint(DataAbsensi dataAbsensi) async {
    var respon = await dio.post("patroli/tambah",
        data: {
          "lokasi_absen": dataAbsensi.lokasiAbsen,
          "latitude": dataAbsensi.latitude,
          "longitude": dataAbsensi.longitude,
          "keterangan": dataAbsensi.keteranganAbsen,
          "image": dataAbsensi.foto,
          "nm_qr": dataAbsensi.qr,
          "min_absen":dataAbsensi.minAbsen,
          "max_absen":dataAbsensi.maxAbsen,
          "nm_jadwal":dataAbsensi.nmJadwal
        },
        options: Options(headers: await Header().getHeader()));
    // print("${dataAbsensi.lokasiAbsen}");
    // print("${dataAbsensi.jenisAbsen}");
    // print("${dataAbsensi.latitude}");
    // print("${dataAbsensi.longitude}");
    // print("${dataAbsensi.keteranganAbsen}");
    // print("${dataAbsensi.foto}");
    // print("${dataAbsensi.minAbsen}");
    // print("${dataAbsensi.maxAbsen}");
    // print("${dataAbsensi.nmJadwal}");

    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<JadwalChekpointRespone> getJadwalChekpoint(String? waktu,String? waktulocal) async {
    var respon = await dio.get("patroli/jadwal",
        queryParameters: {
          "waktu":waktu,
          "waktu_lokal":waktulocal
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jadwalCheckpointResponFromJson(respon.data);
    } else {
      return JadwalChekpointRespone(success: false);
    }
  }

  Future<ValidasiWaktu> cekWaktu(String? waktu) async{
    var respon = await dio.get("patroli/cekwaktu",
        queryParameters: {
          "waktu_devices":waktu,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return validasiWaktuFromJson(respon.data);
    } else {
      return ValidasiWaktu(success: false);
    }
  }
}
