import 'package:absenkuv3/Repository/Model/SalesActivity/mDataProduct.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mJenisAktivitasSales.dart';
import 'package:absenkuv3/Repository/Model/mDropdown.dart';
import 'package:absenkuv3/Repository/Model/mDropdownLokasi.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mPerusahaan.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:dio/dio.dart';
import 'package:pretty_dio_logger/pretty_dio_logger.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class DropdownApi {
  Dio dio = ServerInfo().getConnection();
  DropdownApi() {
    dio.interceptors.add(PrettyDioLogger(
      requestHeader: true,
      requestBody: true,
      responseHeader: false,
      responseBody: true,
      error: true,
      compact: true,
      maxWidth: 120,
    ));
  }

  Future<DropdownRespon?> getJenisIzin() async {
    var respon = await dio.get("izin/jenis",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownResponFromJson(respon.data);
    } else {
      return null;
    }
  }

  Future<DataProductRespon> getDataProduct() async {
    var respon = await dio.get("dropdown/produk",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataProductResponFromJson(respon.data);
    } else {
      return DataProductRespon(success: false);
    }
  }

  Future<DropdownRespon> getDataLeadMaster() async {
    var respon = await dio.get("dropdown/sales/lead_master",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownResponFromJson(respon.data);
    } else {
      return DropdownRespon(success: false);
    }
  }

  Future<DropdownRespon> getDataJenisPerusahaanMaster(
      String jenisPerusahaan) async {
    var respon = await dio.get("dropdown/sales/jenis_perusahaan_master",
        queryParameters: {"jenis_perusahaan": jenisPerusahaan},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownResponFromJson(respon.data);
    } else {
      return DropdownRespon(success: false);
    }
  }

  Future<DropdownRespon?> getCabang() async {
    var respon = await dio.get("dropdown/cabang",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownResponFromJson(respon.data);
    } else {
      return null;
    }
  }

  Future<DropdownRespon?> getStatus() async {
    var respon = await dio.get("dropdown/status",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownResponFromJson(respon.data);
    } else {
      return null;
    }
  }

  Future<DropdownRespon?> getDepartemen(idCabang) async {
    String? id_cabang;
    LoginRespon data = await sharedPreferences().getUserData();
    if (data.dataLogin!.level == 1 || data.dataLogin!.level == 4) {
      id_cabang = '';
    } else {
      id_cabang = data.dataLogin!.idCabang;
    }
    var respon = await dio.get("dropdown/departemen",
        queryParameters: {
          "id_cabang": idCabang ?? id_cabang,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownResponFromJson(respon.data);
    } else {
      return null;
    }
  }

  Future<DropdownRespon> getPegawai(keywords, ModelFilter? modelFilter) async {
    var respon = await dio.get("dropdown/pegawai",
        queryParameters: {
          "id_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "id_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
          "keywords": keywords
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownResponFromJson(respon.data);
    } else {
      return DropdownRespon(success: false);
    }
  }

  Future<DropdownRespon> getPegawaiV2(ModelFilter? modelFilter) async {
    var respon = await dio.get("dropdown/pegawaiV2",
        queryParameters: {
          "id_departemen":
              modelFilter != null ? modelFilter.idDepartemen ?? null : null,
          "id_cabang":
              modelFilter != null ? modelFilter.idCabang ?? null : null,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownResponFromJson(respon.data);
    } else {
      return DropdownRespon(success: false);
    }
  }

  Future<DropdownRespon> getPegawaiBawahan(keywords, idGroupM, limit) async {
    var respon = await dio.get("dropdown/pegawai-bawahan",
        queryParameters: {
          "keywords": keywords,
          "id_group_m": idGroupM,
          "limit": limit
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownResponFromJson(respon.data);
    } else {
      return DropdownRespon(success: false);
    }
  }

  Future<DropdownRespon> getFilterPerusahaan(keywords) async {
    var respon = await dio.get("dropdown/sales/filter-perusahaan",
        queryParameters: {"keywords": keywords},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownResponFromJson(respon.data);
    } else {
      return DropdownRespon(success: false);
    }
  }

  Future<DropdownRespon> getFilterGroupArea(keywords) async {
    var respon = await dio.get("dropdown/sales/filter-group-area",
        queryParameters: {"keywords": keywords},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownResponFromJson(respon.data);
    } else {
      return DropdownRespon(success: false);
    }
  }

  Future<DropdownRespon?> getJenisReimbursement() async {
    var respon = await dio.get("reimbursement/jenis",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownResponFromJson(respon.data);
    } else {
      return null;
    }
  }

  Future<PerusahaanRespon> getPerusahaan(keywords, kategori) async {
    print("keywordnya bos $keywords");
    var respon = await dio.get("dropdown/sales/perusahaan",
        queryParameters: {"keywords": keywords, "kategori": kategori},
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return perusahaanResponFromJson(respon.data);
    } else {
      return PerusahaanRespon(success: false);
    }
  }

  Future<JenisAktivitasSalesRespon> getDataJenisAktivitas() async {
    var respon = await dio.get("dropdown/sales/jenis-aktivitas",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return jenisAktivitasSalesResponFromJson(respon.data);
    } else {
      return JenisAktivitasSalesRespon(success: false);
    }
  }

  Future<DropdownLokasi> getLokasiAtivitas() async {
    var respon = await dio.get("aktivitas/data-lokasi",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dropdownLokasiFromJson(respon.data);
    } else {
      return DropdownLokasi(success: false);
    }
  }
}
