import 'package:absenkuv3/Repository/Model/Cuti/mDataCuti.dart';
import 'package:absenkuv3/Repository/Model/Cuti/mDataHistoryCuti.dart';
import 'package:absenkuv3/Repository/Model/Cuti/mDataPeriodeCuti.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class CutiApi {
  final dateFormat = new DateFormat('yyyy-MM-dd');
  Dio dio = ServerInfo().getConnection();
  Future<Respondatacuti> getDataCuti() async {
    var respon = await dio.get("cuti/getCuti",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return respondatacutiFromJson(respon.data);
    } else {
      return Respondatacuti(success: false);
    }
  }
  Future<ResponPeriodeCuti> getDataPeriodeCuti(String? id_karyawan) async {
    var respon = await dio.get("cuti/getPeriodeCuti",
        queryParameters: {
          "id_karyawan":id_karyawan
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return responPeriodeCutiFromJson(respon.data);
    } else {
      return ResponPeriodeCuti(success: false);
    }
  }
  Future<Responlisthistorycuti> getHistoryCuti(String konteks,offset,String periodeAwal,String periodeAkhir) async {
    var respon = await dio.get("cuti/getHistoryCuti",
        queryParameters: {
          "konteks": konteks,
          "limit": ServerInfo.limit,
          "offset": offset,
          "periode_awal":periodeAwal,
          "periode_akhir":periodeAkhir
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return responlisthistorycutiFromJson(respon.data);
    } else {
      return Responlisthistorycuti(success: false, data: null);
    }
  }
}
