// import 'package:absenkuv3/Repository/Model/SalesActivity/DashboardSales/mSummarySales.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDailyActivity.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataAktivitasSales.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDetailKanbanBoard.dart' as detailKanban;
import 'package:absenkuv3/Repository/Model/SalesActivity/mJenisAktivitasSales.dart' as jenisAktivitas;
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataLayananDetail.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mTargetSales.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mTotalDataLayananDetail.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataKanban.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataLayanan.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mDataProduct.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mTotalKanban.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mMasterTahapan.dart';
import 'package:absenkuv3/Repository/Model/SalesActivity/mPerusahaan.dart';
import 'package:absenkuv3/Repository/Model/mLogin.dart';
import 'package:absenkuv3/Repository/Model/mSplashScreen.dart';
import 'package:absenkuv3/Repository/sharedPreference.dart';
import 'package:dio/dio.dart';
import 'package:intl/intl.dart';
import '../../Setting/Header.dart';
import 'serviceInfo.dart';

class SalesActivityApi {
  final monthYearFormat = new DateFormat('yyyy-MM');
  final dateFormat = new DateFormat('yyyy-MM-dd');
  Dio dio = ServerInfo().getConnection();

  Future<DataProductRespon> addLayananDraft(DataProduct dataProduct) async {
    var respon = await dio.post("sales_activity/tambah_layanan_draft",
        data: {
          "id_product_m": dataProduct.idProductM,
          "id_product_group_m": dataProduct.idProductGroupM,
          "nominal": dataProduct.harga,
          "jumlah_product": dataProduct.jmlProduk,
          "diskon": dataProduct.diskon,
          "harga_total": dataProduct.totalHarga
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataProductResponFromJson(respon.data);
    } else {
      return DataProductRespon(success: false);
    }
  }

  Future<DataProductRespon> addLayanan(DataProduct dataProduct, String idPipelineMain) async {
    var respon = await dio.post("sales_activity/tambah_layanan",
        data: {
          "id_product_m": dataProduct.idProductM,
          "id_product_group_m": dataProduct.idProductGroupM,
          "nominal": dataProduct.harga,
          "jumlah_product": dataProduct.jmlProduk,
          "diskon": dataProduct.diskon,
          "harga_total": dataProduct.totalHarga,
          "id_pipeline_main": idPipelineMain
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataProductResponFromJson(respon.data);
    } else {
      return DataProductRespon(success: false);
    }
  }

  Future<BasicRespon> editLayananDraft(DataProduct dataProduct, String idPipelineLayananDraft, String idKaryawan, String idCompany) async {
    var respon = await dio.patch("sales_activity/edit_data_layanan_draft",
        queryParameters: {
          "id_product_m": dataProduct.idProductM,
          "id_product_group_m": dataProduct.idProductGroupM,
          "nominal": dataProduct.harga,
          "jumlah_product": dataProduct.jmlProduk,
          "diskon": dataProduct.diskon,
          "harga_total": dataProduct.totalHarga,
          "id_pipeline_layanan_draft": idPipelineLayananDraft,
          "id_karyawan": idKaryawan,
          "id_company": idCompany
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<DataProductRespon> editLayanan(DataProduct dataProduct, String idPipelineMain, String idPipelineLayanan) async {
    var respon = await dio.patch("sales_activity/edit_data_layanan",
        queryParameters: {
          "id_product_m": dataProduct.idProductM,
          "id_product_group_m": dataProduct.idProductGroupM,
          "nominal": dataProduct.harga,
          "jumlah_product": dataProduct.jmlProduk,
          "diskon": dataProduct.diskon,
          "harga_total": dataProduct.totalHarga,
          "id_pipeline_main": idPipelineMain,
          "id_pipeline_layanan": idPipelineLayanan
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataProductResponFromJson(respon.data);
    } else {
      return DataProductRespon(success: false);
    }
  }

  Future<BasicRespon> addKamban(DataPerusahaan dataKamban) async {
    print(dataKamban.leadSource!.idLeadM);
    var respon = await dio.post("sales_activity/tambah_kamban",
        data: {
          "id_sales_selected": dataKamban.idSalesBawahan,
          "id_pelanggan": dataKamban.idPelanggan,
          "nama_perusahaan": dataKamban.namaPerusahaan,
          // "id_jenis_perusahaan_m": dataKamban.kategoriPelanggan=='Perusahaan'
          //     ? dataKamban.jenisPerusahaan!.idJenisPerusahaanM
          //     : null,
          "id_jenis_perusahaan_m": dataKamban.jenisPerusahaan!.idJenisPerusahaanM,
          "nama_jenis_perusahaan_m": dataKamban.jenisPerusahaan!.namaJenisPerusahaan,
          "id_lead_m": dataKamban.leadSource!.idLeadM,
          "nama_lead_source": dataKamban.leadSource!.namaLeadM,
          "alamat": dataKamban.alamat,
          "id_kota": dataKamban.kota!.idKota,
          "nama_kota": dataKamban.kota!.namaKota,
          "id_provinsi": dataKamban.provinsi!.idProvinsi,
          "nama_provinsi": dataKamban.provinsi!.namaProvinsi,
          "id_kecamatan": dataKamban.kecamatan == null ? null : dataKamban.kecamatan!.idKecamatan,
          "nama_kecamatan": dataKamban.kecamatan == null ? null : dataKamban.kecamatan!.namaKecamatan,
          "id_kelurahan": dataKamban.kelurahan==null?null:dataKamban.kelurahan!.idKelurahan,
          "nama_kelurahan": dataKamban.kelurahan==null?null:dataKamban.kelurahan!.namaKelurahan,
          "pic_nama": dataKamban.kategoriPelanggan=='Perusahaan'
              ? dataKamban.picNama
              : "",
          "pic_email": dataKamban.picEmail,
          "pic_telp": dataKamban.picTelp,
          "pelanggan_baru": dataKamban.pelangganBaru,
          "kategori_pelanggan": dataKamban.kategoriPelanggan,
          "title": dataKamban.title,
          "keterangan": dataKamban.keterangan
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<DataProductRespon> deleteLayananDraft(Layanan dataProduct) async {
    var respon = await dio.delete("sales_activity/delete_data_layanan_draft",
        queryParameters: {
          "id_pipeline_layanan_draft": dataProduct.idPipelineLayanan,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataProductResponFromJson(respon.data);
    } else {
      return DataProductRespon(success: false);
    }
  }

  Future<DataLayananRespon> getDataLayanan(offset, ModelFilter) async {
    var respon = await dio.get("sales_activity/data_layanan_draft",
        queryParameters: {
          "offset": offset,
          "limit": ServerInfo.limit
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataLayananResponFromJson(respon.data);
    } else {
      return DataLayananRespon(success: false);
    }
  }

  Future<MasterTahapanRespon> getDataTahapan(String bulan, String tahun) async {
    var respon = await dio.get("sales_activity/data_tahapan",
        queryParameters: {
          "tahun": tahun,
          "bulan": bulan
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return masterTahapanResponFromJson(respon.data);
    } else {
      return MasterTahapanRespon(success: false);
    }
  }

  Future<TotalKanbanRespon> getTotalKanban(idTahapanM, ModelFilter modelFilter) async {
    var respon = await dio.get("sales_activity/total_lead_nominal",
        queryParameters: {
          "bulan": modelFilter.monthYear!.month,
          "tahun": modelFilter.monthYear!.year,
          "id_tahapan_m": idTahapanM,
          "filter_perusahaan": modelFilter.idPerusahaan,
          "filter_sales": modelFilter.idPegawai,
          "filter_group": modelFilter.idGroup
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return totalKanbanResponFromJson(respon.data);
    } else {
      return TotalKanbanRespon(success: false);
    }
  }

  Future<PerusahaanRespon> getPelanggan(idPelanggan, idPipelineMain) async {
    var respon = await dio.get("sales_activity/get-data-pelanggan",
        queryParameters: {
          "id_pelanggan": idPelanggan,
          "id_pipeline_main": idPipelineMain
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return perusahaanResponFromJson(respon.data);
    } else {
      return PerusahaanRespon(success: false);
    }
  }

  Future<DataKanbanRespon> getDataKanban(idTahapanM, offset, ModelFilter modelFilter) async {
    var respon = await dio.get("sales_activity/data_kanban",
        queryParameters: {
          "id_tahapan_m": idTahapanM,
          "tahun": modelFilter.monthYear!.year,
          "bulan": modelFilter.monthYear!.month,
          "filter_perusahaan": modelFilter.idPerusahaan,
          "filter_sales": modelFilter.idPegawai,
          "filter_group": modelFilter.idGroup,
          "offset": offset,
          "limit": ServerInfo.limit
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataKanbanResponFromJson(respon.data);
    } else {
      return DataKanbanRespon(success: false);
    }
  }

  Future<detailKanban.DetailKanbanBoardRespon> getDetailDataKanban(idPipelineMain, idPipelineMainLog) async {
    var respon = await dio.get("sales_activity/detail_data_kanban",
        queryParameters: {
          "id_pipeline_main": idPipelineMain,
          "id_pipeline_main_log": idPipelineMainLog
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return detailKanban.detailKanbanBoardResponFromJson(respon.data);
    } else {
      return detailKanban.DetailKanbanBoardRespon(success: false);
    }
  }

  Future<TotalDataLayananRespon> getTotalDataLayananDetail(idPipelineMain) async {
    var respon = await dio.get("sales_activity/get-data-total-layanan-detail",
        queryParameters: {
          "id_pipeline_main": idPipelineMain
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return totalDataLayananResponFromJson(respon.data);
    } else {
      return TotalDataLayananRespon(success: false);
    }
  }

  Future<DataLayananDetailRespon> getDataLayananDetail(idPipelineMain, offset) async {
    var respon = await dio.get("sales_activity/get-data-layanan-detail",
        queryParameters: {
          "id_pipeline_main": idPipelineMain,
          "limit": ServerInfo.limit,
          "offset": offset
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataLayananDetailResponFromJson(respon.data);
    } else {
      return DataLayananDetailRespon(success: false);
    }
  }

  Future<DataLayananDetailRespon> getDataLayananDetailById(idPipelineMain) async {
    var respon = await dio.get("sales_activity/get-data-layanan-detail-by-id",
        queryParameters: {
          "id_pipeline_main": idPipelineMain
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataLayananDetailResponFromJson(respon.data);
    } else {
      return DataLayananDetailRespon(success: false);
    }
  }

  Future<BasicRespon> ubahTahapan(DataKanban data, statuPengajuan, tahapanSebelumId, tahapanSebelumNm, tahapanSesudahId, tahapanSesudahNm, ketPO, ketFailed) async {
    var respon = await dio.patch("sales_activity/ganti_tahapan",
        queryParameters: {
          "id_pipeline_main_log": data.idPipelineMainLog,
          "id_pipeline_main": data.idPipelineMain,
          "status_pengajuan": statuPengajuan,
          "tahapan_sebelum_id": tahapanSebelumId,
          "tahapan_sebelum_nm": tahapanSebelumNm,
          "tahapan_sesudah_id": tahapanSesudahId,
          "tahapan_sesudah_nm": tahapanSesudahNm,
          "ket_po": ketPO,
          "ket_failed": ketFailed
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> deleteLayanan(Layanan dataProduct) async {
    var respon = await dio.delete("sales_activity/delete_data_layanan",
        queryParameters: {
          "id_pipeline_layanan": dataProduct.idPipelineLayanan,
          "id_pipeline_main": dataProduct.idPipelineMain,
          "id_product_m": dataProduct.idProductM
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> deleteKanban(String idPipelineMain) async {
    var respon = await dio.delete("sales_activity/delete_data_kanban",
        queryParameters: {
          "id_pipeline_main": idPipelineMain
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> batalkanKanban(String idPipelineMain) async {
    var respon = await dio.patch("sales_activity/batalkan_data_kanban",
        queryParameters: {
          "id_pipeline_main": idPipelineMain
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> pindahBulanKanban(String idPipelineMain, String idPipelineMainLog) async {
    var respon = await dio.post("sales_activity/pindah_bulan",
        data: {
          "id_pipeline_main": idPipelineMain,
          "id_pipeline_main_log": idPipelineMainLog
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<DataAktivitasSalesRespon> getDataAktivitasSales(idPelanggan, idPipelineMain, offset) async {
    var respon = await dio.get("sales_activity/get-data-aktivitas-sales",
        queryParameters: {
          "id_pelanggan": idPelanggan,
          "id_pipeline_main": idPipelineMain,
          "offset": offset,
          "limit": ServerInfo.limit
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dataAktivitasSalesResponFromJson(respon.data);
    } else {
      return DataAktivitasSalesRespon(success: false);
    }
  }

  Future<BasicRespon> addAktivitasSales(
      idPelanggan, idPipelineMain, keterangan,
      jenisAktivitas.Data jenisAktivitas, lat, long, pathfoto, tanggal, jam) async {
    var respon = await dio.post("sales_activity/tambah_aktivitas_sales",
        data: {
          "id_pelanggan": idPelanggan,
          "id_pipeline_main": idPipelineMain,
          "jenis_activity": jenisAktivitas.nama,
          "keterangan": keterangan,
          "poin": jenisAktivitas.poin,
          "flag_lokasi": jenisAktivitas.flagLokasi,
          "flag_upload_foto": jenisAktivitas.flagUploadFoto,
          "lat": lat,
          "long": long,
          "path_foto": pathfoto,
          "tanggal": tanggal,
          "jam": jam
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<DailyAktivitasSalesRespon> getDataDailyAktivitasSales(status, offset, ModelFilter? modelFilter) async {
    var respon = await dio.get("sales_activity/get-data-daily-sales-activity",
        queryParameters: {
          "status": status,
          "offset": offset,
          "limit": ServerInfo.limit,
          "filter_perusahaan": modelFilter!=null ? modelFilter.idPerusahaan:null,
          "filter_sales": modelFilter!=null ? modelFilter.idPegawai:null,
          "range_tanggal_mulai":
              modelFilter == null
                  ? null
                  : modelFilter.dateRange == null
                    ? null
                    : modelFilter.dateRange!.length > 0
                      ? dateFormat.format(modelFilter.dateRange![0]).toString()
                      : null,
          "range_tanggal_selesai":
              modelFilter == null
                ? null
                : modelFilter.dateRange == null
                  ? null
                  : modelFilter.dateRange!.length > 0
                    ? dateFormat.format(modelFilter.dateRange![1]).toString()
                    : null,
          "filter_group": modelFilter==null?"":modelFilter.idGroup
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dailyAktivitasSalesResponFromJson(respon.data);
    } else {
      return DailyAktivitasSalesRespon(success: false);
    }
  }

  Future<DailyAktivitasSalesRespon> getDetailDailyAktivitasSales(status, idKaryawan, idPipelineMain, idPipelineMainLog, idPelanggan, tanggal, jam, tabel) async {
    LoginRespon? loginData = await sharedPreferences().getUserData();
    var respon = await dio.get("sales_activity/get-detail-data-daily-sales-activity",
        queryParameters: {
          "status": status,
          "id_karyawan": idKaryawan,
          "id_pipeline_main": idPipelineMain,
          "id_pipeline_main_log": idPipelineMainLog,
          "id_pelanggan": idPelanggan,
          "tanggal": tanggal,
          "jam": jam,
          "tabel": tabel,
          "is_admin_atasan": loginData.dataLogin!.adminAtasan
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dailyAktivitasSalesResponFromJson(respon.data);
    } else {
      return DailyAktivitasSalesRespon(success: false);
    }
  }

  Future<DailyAktivitasSalesRespon> getDetailDailyAktivitasSalesById(status, idKaryawan, idPipelineMain, idPipelineMainLog, idPelanggan, tanggal, jam, tabel) async {
    LoginRespon? loginData = await sharedPreferences().getUserData();
    var respon = await dio.get("sales_activity/get-data-daily-sales-activity-by-id",
        queryParameters: {
          "status": status,
          "id_karyawan": idKaryawan,
          "id_pipeline_main": idPipelineMain,
          "id_pipeline_main_log": idPipelineMainLog,
          "id_pelanggan": idPelanggan,
          "tanggal": tanggal,
          "jam": jam,
          "tabel": tabel,
          "is_admin_atasan": loginData.dataLogin!.adminAtasan
        }, options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return dailyAktivitasSalesResponFromJson(respon.data);
    } else {
      return DailyAktivitasSalesRespon(success: false);
    }
  }

  Future<TargetSalesRespon> getDataTargetSales() async {
    var respon = await dio.get("sales_activity/get-data-target-sales-activity",
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return targetSalesResponFromJson(respon.data);
    } else {
      return TargetSalesRespon(success: false);
    }
  }

  // Future<TargetSalesRespon> getDataTargetSales(DateTime monthYear) async {
  //   var respon = await dio.get("sales_activity/get-data-target-sales-activity",
  //       queryParameters: {
  //         "tahun": monthYear.year,
  //         "bulan": monthYear.month < 10 ? "0${monthYear.month}" : monthYear.month
  //       },
  //       options: Options(headers: await Header().getHeader()));
  //   if (respon.statusCode == 200) {
  //     return targetSalesResponFromJson(respon.data);
  //   } else {
  //     return TargetSalesRespon(success: false);
  //   }
  // }

  Future<BasicRespon> setujuiKanban(String idPipelineMain, String idPipelineMainLog) async {
    var respon = await dio.patch("sales_activity/setujui-kanban", queryParameters: {
      "id_pipeline_main": idPipelineMain,
      "id_pipeline_main_log": idPipelineMainLog
    },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> tolakKanban(String idPipelineMain, String idPipelineMainLog, String idTahapanM, String jenisTahapan) async {
    var respon = await dio.patch("sales_activity/tolak-kanban", queryParameters: {
      "id_pipeline_main": idPipelineMain,
      "id_pipeline_main_log": idPipelineMainLog,
      "id_tahapan_m": idTahapanM,
      "jenis_tahapan": jenisTahapan
    },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> setujuiActivity(DataDailyAktivitasSales param) async {
    var respon = await dio.patch("sales_activity/setujui-activity", queryParameters: {
      "id_karyawan": param.idKaryawan,
      "tgl_activity": param.tanggal,
      "jam_activity": param.jam,
      "id_pipeline_main": param.idPipelineMain,
      "id_pipeline_main_log": param.idPipelineMainLog
    },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  Future<BasicRespon> tolakActivity(DataDailyAktivitasSales param) async {
    var respon = await dio.patch("sales_activity/tolak-activity", queryParameters: {
      "id_karyawan": param.idKaryawan,
      "tgl_activity": param.tanggal,
      "jam_activity": param.jam,
      "id_pipeline_main": param.idPipelineMain,
      "id_pipeline_main_log": param.idPipelineMainLog
    },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return basicResponFromJson(respon.data);
    } else {
      return BasicRespon(success: false);
    }
  }

  // Future<SalesSummaryRespon> getDataSalesSummary(DateTime monthYear) async {
  //   LoginRespon? loginData = await sharedPreferences().getUserData();
  //   var respon = await dio.get("sales_activity/get-data-sales-summary",
  //       queryParameters: {
  //         "bulan": monthYear.month < 10 ? "0${monthYear.month}" : monthYear.month,
  //         "tahun": monthYear.year,
  //         "sales_admin": loginData.dataLogin!.salesAdmin,
  //         "sales_atasan": loginData.dataLogin!.salesAtasan
  //       },
  //       options: Options(headers: await Header().getHeader()));
  //   if (respon.statusCode == 200) {
  //     return salesSummaryResponFromJson(respon.data);
  //   } else {
  //     return SalesSummaryRespon(success: false);
  //   }
  // }
}
