import 'package:absenkuv3/Repository/Model/MonitorAbsen/mMonitorAbsen.dart';
import 'package:absenkuv3/Repository/Model/mAbsensi.dart';
import 'package:absenkuv3/Repository/Model/mFilter.dart';
import 'package:absenkuv3/Repository/Model/mLembur.dart';
import 'package:absenkuv3/Repository/Service/serviceInfo.dart';
import 'package:absenkuv3/Setting/Header.dart';
import 'package:dio/dio.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';

class MonitorAbsenApi {
  final monthYearFormat = new DateFormat('yyyy-MM');
  Dio dio = ServerInfo().getConnection();
  Future<MonitorabsensiRespon> getDataMonitorAbsen(
      String konteks, $offset,String limit) async {
    var respon = await dio.get("dashboard-absensi/data",
        queryParameters: {
          "jenis": konteks,
          "limit": limit,
          "offset": $offset,
        },
        options: Options(headers: await Header().getHeader()));
    debugPrint('respon dashbard ' + respon.data);
    if (respon.statusCode == 200) {
      return monitorabsensiFromJson(respon.data);
    } else {
      return MonitorabsensiRespon(success: false);
    }
  }
  Future<RekapAbsensiRespon> getDataListMonitor(
  ModelFilter? modelFilter,
      String konteks, $offset) async {
    var respon = await dio.get("dashboard-absensi/datalist",
        queryParameters: {
          "month_year"  : modelFilter!=null && modelFilter.monthYear!=null?monthYearFormat.format(modelFilter.monthYear!).toString():null,
          "konteks": konteks,
          "limit": 12,
          "offset": $offset,
        },
        options: Options(headers: await Header().getHeader()));
    debugPrint('respon dashbard ' + respon.data);
    if (respon.statusCode == 200) {
      return rekapAbsensiResponFromJson(respon.data);
    } else {
      return RekapAbsensiRespon(success: false,data:null);
    }
  }
  Future<MonitorabsensiRespon> getDataListIzinMonitor(
      ModelFilter? modelFilter,
      String konteks, $offset) async {
    var respon = await dio.get("dashboard-absensi/listIzin",
        queryParameters: {
          "month_year"  : modelFilter!=null && modelFilter.monthYear!=null?monthYearFormat.format(modelFilter.monthYear!).toString():null,
          "konteks": konteks,
          "limit": 12,
          "offset": $offset,
        },
        options: Options(headers: await Header().getHeader()));
    debugPrint('respon dashbard ' + respon.data);
    if (respon.statusCode == 200) {
      return monitorabsensiFromJson(respon.data);
    } else {
      return MonitorabsensiRespon(success: false,data:null);
    }
  }
  Future<LemburRespon> getDataLemburMonitor(
      offset, ModelFilter? modelFilter) async {
    var respon = await dio.get("dashboard-absensi/listLembur",
        queryParameters: {
          "month_year"  : modelFilter!=null && modelFilter.monthYear!=null?monthYearFormat.format(modelFilter.monthYear!).toString():null,
          "limit": ServerInfo.limit,
          "offset": offset,
        },
        options: Options(headers: await Header().getHeader()));
    if (respon.statusCode == 200) {
      return lemburResponFromJson(respon.data);
    } else {
      return LemburRespon(success: false);
    }
  }
}
